/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CImage;
import apple.awt.CSurfaceData;
import apple.awt.RuntimeOptions;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import sun.awt.image.ImageRepresentation;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.pipe.DrawImagePipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.ShapeDrawPipe;

public class CRenderer
implements PixelDrawPipe,
PixelFillPipe,
ShapeDrawPipe,
DrawImagePipe {
    static native void init();

    native void doLine(SurfaceData var1, ByteBuffer var2, Object[] var3, float var4, float var5, float var6, float var7);

    public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.drawLine(sunGraphics2D, (float)n, (float)n2, (float)n3, (float)n4);
    }

    public void drawLine(SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4) {
        ((CSurfaceData)sunGraphics2D.surfaceData).doLine(this, sunGraphics2D, f, f2, f3, f4);
    }

    native void doRect(SurfaceData var1, ByteBuffer var2, Object[] var3, float var4, float var5, float var6, float var7, boolean var8);

    public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.drawRect(sunGraphics2D, (float)n, (float)n2, (float)n3, (float)n4);
    }

    public void drawRect(SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4) {
        if (f3 >= 0.0f && f4 >= 0.0f) {
            ((CSurfaceData)sunGraphics2D.surfaceData).doRect(this, sunGraphics2D, f, f2, f3, f4, false);
        }
    }

    public void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.fillRect(sunGraphics2D, (float)n, (float)n2, (float)n3, (float)n4);
    }

    public void fillRect(SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4) {
        if (f3 >= 0.0f && f4 >= 0.0f) {
            ((CSurfaceData)sunGraphics2D.surfaceData).doRect(this, sunGraphics2D, f, f2, f3, f4, true);
        }
    }

    native void doRoundRect(SurfaceData var1, ByteBuffer var2, Object[] var3, float var4, float var5, float var6, float var7, float var8, float var9, boolean var10);

    public void drawRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawRoundRect(sunGraphics2D, (float)n, (float)n2, (float)n3, (float)n4, (float)n5, (float)n6);
    }

    public void drawRoundRect(SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4, float f5, float f6) {
        if (f3 >= 0.0f && f4 >= 0.0f) {
            ((CSurfaceData)sunGraphics2D.surfaceData).doRoundRect(this, sunGraphics2D, f, f2, f3, f4, f5, f6, false);
        }
    }

    public void fillRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillRoundRect(sunGraphics2D, (float)n, (float)n2, (float)n3, (float)n4, (float)n5, (float)n6);
    }

    public void fillRoundRect(SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4, float f5, float f6) {
        if (f3 >= 0.0f && f4 >= 0.0f) {
            ((CSurfaceData)sunGraphics2D.surfaceData).doRoundRect(this, sunGraphics2D, f, f2, f3, f4, f5, f6, true);
        }
    }

    native void doOval(SurfaceData var1, ByteBuffer var2, Object[] var3, float var4, float var5, float var6, float var7, boolean var8);

    public void drawOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.drawOval(sunGraphics2D, (float)n, (float)n2, (float)n3, (float)n4);
    }

    public void drawOval(SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4) {
        if (f3 >= 0.0f && f4 >= 0.0f) {
            ((CSurfaceData)sunGraphics2D.surfaceData).doOval(this, sunGraphics2D, f, f2, f3, f4, false);
        }
    }

    public void fillOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.fillOval(sunGraphics2D, (float)n, (float)n2, (float)n3, (float)n4);
    }

    public void fillOval(SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4) {
        if (f3 >= 0.0f && f4 >= 0.0f) {
            ((CSurfaceData)sunGraphics2D.surfaceData).doOval(this, sunGraphics2D, f, f2, f3, f4, true);
        }
    }

    native void doArc(SurfaceData var1, ByteBuffer var2, Object[] var3, float var4, float var5, float var6, float var7, float var8, float var9, int var10, boolean var11);

    public void drawArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawArc(sunGraphics2D, n, n2, n3, n4, n5, n6, 0);
    }

    public void drawArc(SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4, float f5, float f6, int n) {
        if (f3 >= 0.0f && f4 >= 0.0f) {
            ((CSurfaceData)sunGraphics2D.surfaceData).doArc(this, sunGraphics2D, f, f2, f3, f4, f5, f6, n, false);
        }
    }

    public void fillArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillArc(sunGraphics2D, n, n2, n3, n4, n5, n6, 2);
    }

    public void fillArc(SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4, float f5, float f6, int n) {
        if (f3 >= 0.0f && f4 >= 0.0f) {
            ((CSurfaceData)sunGraphics2D.surfaceData).doArc(this, sunGraphics2D, f, f2, f3, f4, f5, f6, n, true);
        }
    }

    native void doPoly(SurfaceData var1, ByteBuffer var2, Object[] var3, int[] var4, int[] var5, int var6, boolean var7, boolean var8);

    public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        ((CSurfaceData)sunGraphics2D.surfaceData).doPolygon(this, sunGraphics2D, nArray, nArray2, n, false, false);
    }

    public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        ((CSurfaceData)sunGraphics2D.surfaceData).doPolygon(this, sunGraphics2D, nArray, nArray2, n, true, false);
    }

    public void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        ((CSurfaceData)sunGraphics2D.surfaceData).doPolygon(this, sunGraphics2D, nArray, nArray2, n, true, true);
    }

    native void doShape(SurfaceData var1, ByteBuffer var2, Object[] var3, int var4, FloatBuffer var5, IntBuffer var6, int var7, boolean var8);

    void drawfillShape(SunGraphics2D sunGraphics2D, Shape shape, boolean bl) {
        if (shape == null) {
            throw new NullPointerException();
        }
        if (RuntimeOptions.OptimizeShapes) {
            if (shape instanceof Rectangle2D) {
                Rectangle2D rectangle2D = (Rectangle2D)shape;
                float f = (float)rectangle2D.getX();
                float f2 = (float)rectangle2D.getY();
                float f3 = (float)rectangle2D.getWidth();
                float f4 = (float)rectangle2D.getHeight();
                if (bl) {
                    this.fillRect(sunGraphics2D, f, f2, f3, f4);
                } else {
                    this.drawRect(sunGraphics2D, f, f2, f3, f4);
                }
            } else if (shape instanceof Ellipse2D) {
                Ellipse2D ellipse2D = (Ellipse2D)shape;
                float f = (float)ellipse2D.getX();
                float f5 = (float)ellipse2D.getY();
                float f6 = (float)ellipse2D.getWidth();
                float f7 = (float)ellipse2D.getHeight();
                if (bl) {
                    this.fillOval(sunGraphics2D, f, f5, f6, f7);
                } else {
                    this.drawOval(sunGraphics2D, f, f5, f6, f7);
                }
            } else if (shape instanceof Arc2D) {
                Arc2D arc2D = (Arc2D)shape;
                float f = (float)arc2D.getX();
                float f8 = (float)arc2D.getY();
                float f9 = (float)arc2D.getWidth();
                float f10 = (float)arc2D.getHeight();
                float f11 = (float)arc2D.getAngleStart();
                float f12 = (float)arc2D.getAngleExtent();
                if (bl) {
                    this.fillArc(sunGraphics2D, f, f8, f9, f10, f11, f12, arc2D.getArcType());
                } else {
                    this.drawArc(sunGraphics2D, f, f8, f9, f10, f11, f12, arc2D.getArcType());
                }
            } else if (shape instanceof RoundRectangle2D) {
                RoundRectangle2D roundRectangle2D = (RoundRectangle2D)shape;
                float f = (float)roundRectangle2D.getX();
                float f13 = (float)roundRectangle2D.getY();
                float f14 = (float)roundRectangle2D.getWidth();
                float f15 = (float)roundRectangle2D.getHeight();
                float f16 = (float)roundRectangle2D.getArcWidth();
                float f17 = (float)roundRectangle2D.getArcHeight();
                if (bl) {
                    this.fillRoundRect(sunGraphics2D, f, f13, f14, f15, f16, f17);
                } else {
                    this.drawRoundRect(sunGraphics2D, f, f13, f14, f15, f16, f17);
                }
            } else if (shape instanceof Line2D) {
                Line2D line2D = (Line2D)shape;
                float f = (float)line2D.getX1();
                float f18 = (float)line2D.getY1();
                float f19 = (float)line2D.getX2();
                float f20 = (float)line2D.getY2();
                this.drawLine(sunGraphics2D, f, f18, f19, f20);
            } else if (shape instanceof Point2D) {
                Point2D point2D = (Point2D)((Object)shape);
                float f = (float)point2D.getX();
                float f21 = (float)point2D.getY();
                this.drawLine(sunGraphics2D, f, f21, f, f21);
            } else {
                GeneralPath generalPath = shape instanceof GeneralPath ? (GeneralPath)shape : new GeneralPath(shape);
                PathIterator pathIterator = generalPath.getPathIterator(null);
                if (!pathIterator.isDone()) {
                    ((CSurfaceData)sunGraphics2D.surfaceData).drawfillShape(this, sunGraphics2D, generalPath, bl);
                }
            }
        } else {
            GeneralPath generalPath = shape instanceof GeneralPath ? (GeneralPath)shape : new GeneralPath(shape);
            PathIterator pathIterator = generalPath.getPathIterator(null);
            if (!pathIterator.isDone()) {
                ((CSurfaceData)sunGraphics2D.surfaceData).drawfillShape(this, sunGraphics2D, generalPath, bl);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        if (sunGraphics2D.strokeState != 2) {
            if (sunGraphics2D.paintState == 0) {
                this.drawfillShape(sunGraphics2D, shape, false);
                return;
            }
        }
        this.drawfillShape(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(shape), true);
    }

    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        if (sunGraphics2D.strokeState != 2) {
            this.drawfillShape(sunGraphics2D, shape, true);
        } else {
            this.drawfillShape(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(shape), true);
        }
    }

    native boolean doFastCopyAreaInWindow(ByteBuffer var1, Object[] var2, long var3, int var5, int var6, int var7, int var8, int var9, int var10);

    native boolean doCopyAreaInWindow(ByteBuffer var1, Object[] var2, long var3, int var5, int var6, int var7, int var8, int var9, int var10);

    boolean copyAreaInWindow(SunGraphics2D sunGraphics2D, long l, int n, int n2, int n3, int n4, int n5, int n6) {
        return ((CSurfaceData)sunGraphics2D.surfaceData).copyAreaInWindow(this, sunGraphics2D, l, n, n2, n3, n4, n5, n6);
    }

    native boolean doCopyAreaFromWindow(SurfaceData var1, int var2, int var3, int var4, int var5, SurfaceData var6);

    BufferedImage copyAreaFromWindow(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, BufferedImage bufferedImage, SurfaceData surfaceData) {
        return ((CSurfaceData)sunGraphics2D.surfaceData).copyAreaFromWindow(this, sunGraphics2D, n, n2, n3, n4, bufferedImage, surfaceData);
    }

    native int doStartExternal(SurfaceData var1, ByteBuffer var2, Object[] var3);

    int startExternal(SunGraphics2D sunGraphics2D) {
        return ((CSurfaceData)sunGraphics2D.surfaceData).startExternal(this, sunGraphics2D);
    }

    native void doEndExternal(SurfaceData var1);

    void endExternal(SunGraphics2D sunGraphics2D) {
        ((CSurfaceData)sunGraphics2D.surfaceData).endExternal(this, sunGraphics2D);
    }

    native void doImage(SurfaceData var1, ByteBuffer var2, Object[] var3, SurfaceData var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    native void doNSImage(SurfaceData var1, ByteBuffer var2, Object[] var3, long var4, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13);

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, Color color) {
        if (n3 >= 0 && n4 >= 0) {
            int n5 = 0;
            int n6 = 0;
            int n7 = image.getWidth(null);
            int n8 = image.getHeight(null);
            return this.scaleImage(sunGraphics2D, image, n, n2, n + n3, n2 + n4, n5, n6, n5 + n7, n6 + n8, color);
        }
        return true;
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color) {
        int n9 = image.getWidth(null);
        int n10 = image.getHeight(null);
        int n11 = Math.min(n5, n7);
        int n12 = Math.min(n6, n8);
        int n13 = Math.abs(n7 - n5);
        int n14 = Math.abs(n8 - n6);
        if (n11 < 0) {
            n13 += n11;
            n11 = 0;
        }
        if (n12 < 0) {
            n14 += n12;
            n12 = 0;
        }
        if (n11 + n13 > n9) {
            n13 = Math.max(0, n9 - n11);
        }
        if (n12 + n14 > n10) {
            n14 = Math.max(0, n10 - n12);
        }
        int n15 = Math.min(n, n3);
        int n16 = Math.min(n2, n4);
        int n17 = Math.abs(n3 - n);
        int n18 = Math.abs(n4 - n2);
        boolean bl = false;
        boolean bl2 = false;
        if (n > n3) {
            boolean bl3 = bl = !bl;
        }
        if (n2 > n4) {
            boolean bl4 = bl2 = !bl2;
        }
        if (n5 > n7) {
            boolean bl5 = bl = !bl;
        }
        if (n6 > n8) {
            bl2 = !bl2;
        }
        return this.blitImage(sunGraphics2D, image, bl, bl2, n11, n12, n13, n14, n15, n16, n17, n18, color);
    }

    private boolean blitImage(SunGraphics2D sunGraphics2D, Image image, boolean bl, boolean bl2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color) {
        if (image instanceof CImage) {
            CImage cImage = (CImage)image;
            long l = cImage.getNSImage();
            if (l != 0L) {
                cImage.convertToBI();
                if (cImage.isConvertedToBI()) {
                    image = cImage.getConvertedBI();
                    SurfaceData surfaceData = cImage.getConvertedSurfaceData();
                    ((CSurfaceData)sunGraphics2D.surfaceData).blitImage(this, sunGraphics2D, surfaceData, bl, bl2, n, n2, n3, n4, n5, n6, n7, n8, color);
                } else {
                    ((CSurfaceData)sunGraphics2D.surfaceData).blitNSImage(this, sunGraphics2D, l, n, n2, n3, n4, n5, n6, n7, n8, color);
                }
            }
        } else {
            SurfaceData surfaceData = SurfaceData.getSurfaceDataFromImage((Image)image, (SurfaceData)sunGraphics2D.surfaceData, (CompositeType)sunGraphics2D.imageComp, (Color)color, (boolean)false);
            ((CSurfaceData)sunGraphics2D.surfaceData).blitImage(this, sunGraphics2D, surfaceData, bl, bl2, n, n2, n3, n4, n5, n6, n7, n8, color);
        }
        return true;
    }

    protected boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, Color color) {
        if (image == null) {
            return true;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        int n7 = n5;
        int n8 = n6;
        return this.scaleImage(sunGraphics2D, image, n, n2, n + n7, n2 + n8, n3, n4, n3 + n5, n4 + n6, color);
    }

    protected boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, Color color) {
        if (n5 >= 0 && n6 >= 0) {
            return this.scaleImage(sunGraphics2D, image, n, n2, n + n5, n2 + n6, n3, n4, n3 + n5, n4 + n6, color);
        }
        return true;
    }

    protected void transformImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, BufferedImageOp bufferedImageOp, AffineTransform affineTransform, Color color) {
        Object object;
        if (image == null) {
            throw new NullPointerException();
        }
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        if (bufferedImageOp != null && image instanceof BufferedImage) {
            if (((BufferedImage)image).getType() == 0) {
                object = null;
                object = new BufferedImage(n3, n4, 3);
                Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
                graphics2D.drawImage(image, 0, 0, null);
                graphics2D.dispose();
                image = bufferedImageOp.filter((BufferedImage)object, null);
            } else {
                image = bufferedImageOp.filter((BufferedImage)image, null);
            }
            n3 = image.getWidth(null);
            n4 = image.getHeight(null);
        }
        if (affineTransform != null) {
            object = sunGraphics2D.getTransform();
            sunGraphics2D.transform(affineTransform);
            this.scaleImage(sunGraphics2D, image, n, n2, n + n3, n2 + n4, 0, 0, n3, n4, color);
            sunGraphics2D.setTransform((AffineTransform)object);
        } else {
            this.scaleImage(sunGraphics2D, image, n, n2, n + n3, n2 + n4, 0, 0, n3, n4, color);
        }
    }

    protected boolean imageReady(sun.awt.image.Image image, ImageObserver imageObserver) {
        if (image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate((Image)image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        return true;
    }

    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        if (image == null) {
            throw new NullPointerException();
        }
        if (!(image instanceof sun.awt.image.Image)) {
            return this.copyImage(sunGraphics2D, image, n, n2, color);
        }
        sun.awt.image.Image image2 = (sun.awt.image.Image)image;
        if (!this.imageReady(image2, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, image2, n, n2, color, imageObserver);
    }

    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, Color color, ImageObserver imageObserver) {
        if (image == null) {
            throw new NullPointerException();
        }
        if (!(image instanceof sun.awt.image.Image)) {
            return this.copyImage(sunGraphics2D, image, n, n2, n3, n4, n5, n6, color);
        }
        sun.awt.image.Image image2 = (sun.awt.image.Image)image;
        if (!this.imageReady(image2, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, image2, n, n2, n + n5, n2 + n6, n3, n4, n3 + n5, n4 + n6, null, imageObserver);
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (image == null) {
            throw new NullPointerException();
        }
        if (!(image instanceof sun.awt.image.Image)) {
            return this.scaleImage(sunGraphics2D, image, n, n2, n3, n4, color);
        }
        sun.awt.image.Image image2 = (sun.awt.image.Image)image;
        if (!this.imageReady(image2, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, image2, n, n2, n3, n4, color, imageObserver);
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (image == null) {
            throw new NullPointerException();
        }
        if (!(image instanceof sun.awt.image.Image)) {
            return this.scaleImage(sunGraphics2D, image, n, n2, n3, n4, n5, n6, n7, n8, color);
        }
        sun.awt.image.Image image2 = (sun.awt.image.Image)image;
        if (!this.imageReady(image2, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, image2, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    public boolean transformImage(SunGraphics2D sunGraphics2D, Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        if (image == null) {
            throw new NullPointerException();
        }
        if (!(image instanceof sun.awt.image.Image)) {
            this.transformImage(sunGraphics2D, image, 0, 0, null, affineTransform, null);
            return true;
        }
        sun.awt.image.Image image2 = (sun.awt.image.Image)image;
        if (!this.imageReady(image2, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, image2, affineTransform, imageObserver);
    }

    public void transformImage(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        if (bufferedImage == null) {
            throw new NullPointerException();
        }
        this.transformImage(sunGraphics2D, bufferedImage, n, n2, bufferedImageOp, null, null);
    }

    public CRenderer traceWrap() {
        return new Tracer();
    }

    static {
        CRenderer.init();
    }

    public static class Tracer
    extends CRenderer {
        void doLine(SurfaceData surfaceData, ByteBuffer byteBuffer, Object[] objectArray, float f, float f2, float f3, float f4) {
            GraphicsPrimitive.tracePrimitive("QuartzLine");
            super.doLine(surfaceData, byteBuffer, objectArray, f, f2, f3, f4);
        }

        void doRect(SurfaceData surfaceData, ByteBuffer byteBuffer, Object[] objectArray, float f, float f2, float f3, float f4, boolean bl) {
            GraphicsPrimitive.tracePrimitive("QuartzRect");
            super.doRect(surfaceData, byteBuffer, objectArray, f, f2, f3, f4, bl);
        }

        void doRoundRect(SurfaceData surfaceData, ByteBuffer byteBuffer, Object[] objectArray, float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
            GraphicsPrimitive.tracePrimitive("QuartzRoundRect");
            super.doRoundRect(surfaceData, byteBuffer, objectArray, f, f2, f3, f4, f5, f6, bl);
        }

        void doOval(SurfaceData surfaceData, ByteBuffer byteBuffer, Object[] objectArray, float f, float f2, float f3, float f4, boolean bl) {
            GraphicsPrimitive.tracePrimitive("QuartzOval");
            super.doOval(surfaceData, byteBuffer, objectArray, f, f2, f3, f4, bl);
        }

        void doArc(SurfaceData surfaceData, ByteBuffer byteBuffer, Object[] objectArray, float f, float f2, float f3, float f4, float f5, float f6, int n, boolean bl) {
            GraphicsPrimitive.tracePrimitive("QuartzArc");
            super.doArc(surfaceData, byteBuffer, objectArray, f, f2, f3, f4, f5, f6, n, bl);
        }

        void doPoly(SurfaceData surfaceData, ByteBuffer byteBuffer, Object[] objectArray, int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
            GraphicsPrimitive.tracePrimitive("QuartzDoPoly");
            super.doPoly(surfaceData, byteBuffer, objectArray, nArray, nArray2, n, bl, bl2);
        }

        void doShape(SurfaceData surfaceData, ByteBuffer byteBuffer, Object[] objectArray, int n, FloatBuffer floatBuffer, IntBuffer intBuffer, int n2, boolean bl) {
            GraphicsPrimitive.tracePrimitive("QuartzFillOrDrawShape");
            super.doShape(surfaceData, byteBuffer, objectArray, n, floatBuffer, intBuffer, n2, bl);
        }

        boolean doCopyAreaInWindow(ByteBuffer byteBuffer, Object[] objectArray, long l, int n, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("QuartzCopyAreaInWindow");
            return super.doCopyAreaInWindow(byteBuffer, objectArray, l, n, n2, n3, n4, n5, n6);
        }

        boolean doFastCopyAreaInWindow(ByteBuffer byteBuffer, Object[] objectArray, long l, int n, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("QuartzFastCopyAreaInWindow");
            return super.doFastCopyAreaInWindow(byteBuffer, objectArray, l, n, n2, n3, n4, n5, n6);
        }

        boolean doCopyAreaFromWindow(SurfaceData surfaceData, int n, int n2, int n3, int n4, SurfaceData surfaceData2) {
            GraphicsPrimitive.tracePrimitive("QuartzCopyAreaFromWindow");
            return super.doCopyAreaFromWindow(surfaceData, n, n2, n3, n4, surfaceData2);
        }

        void doImage(SurfaceData surfaceData, ByteBuffer byteBuffer, Object[] objectArray, SurfaceData surfaceData2, boolean bl, boolean bl2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            GraphicsPrimitive.tracePrimitive("QuartzDrawImage");
            super.doImage(surfaceData, byteBuffer, objectArray, surfaceData2, bl, bl2, n, n2, n3, n4, n5, n6, n7, n8);
        }

        void doNSImage(SurfaceData surfaceData, ByteBuffer byteBuffer, Object[] objectArray, long l, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            GraphicsPrimitive.tracePrimitive("QuartzDrawNSImage");
            super.doNSImage(surfaceData, byteBuffer, objectArray, l, n, n2, n3, n4, n5, n6, n7, n8);
        }
    }
}

