/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CSurfaceData;
import apple.awt.CWindow;
import apple.awt.ComponentModel;
import apple.awt.ContainerModel;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.SurfaceType;

public class CPeerSurfaceData
extends CSurfaceData {
    private ContainerModel fPeer;
    private boolean fActiveSurface = true;
    private boolean fIsLockFocused = false;
    private Object fLockFocusedLOCK = new Object();
    public static final String DESC_INT_RGB_Q = "Integer RGB Display Quartz";
    public static final SurfaceType IntRgbQ = SurfaceType.IntRgb.deriveSubType("Integer RGB Display Quartz");

    public static CPeerSurfaceData createData(ContainerModel containerModel, boolean bl) {
        return new CPeerSurfaceData(containerModel, bl);
    }

    public static SurfaceType getSurfaceType(ColorModel colorModel, boolean bl) {
        return IntRgbQ;
    }

    private CPeerSurfaceData(ContainerModel containerModel, boolean bl) {
        super(CPeerSurfaceData.getSurfaceType(containerModel.getColorModel(), false), containerModel.getColorModel(), containerModel.getGraphicsConfiguration(), new Rectangle(containerModel.fOldWidth, containerModel.fOldHeight));
        this.fPeer = containerModel;
        boolean bl2 = EventQueue.isDispatchThread();
        boolean bl3 = !EventQueue.isDispatchThread();
        this.enableGraphicsQueue(true, bl3, containerModel);
        if (!containerModel.isInactiveSurfaceSituation() && bl) {
            this.initOps(containerModel.getCGContext(), containerModel.getViewPtr(), bl3);
        } else {
            this.fActiveSurface = false;
            this.initOps(0L, containerModel.getViewPtr(), true);
        }
    }

    private native void initOps(long var1, long var3, boolean var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFocusLocked() {
        Object object = this.fLockFocusedLOCK;
        synchronized (object) {
            this.fIsLockFocused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeContext() {
        Object object = this.fLockFocusedLOCK;
        synchronized (object) {
            this.flush();
            this._completeContext();
            this.fIsLockFocused = false;
        }
    }

    native void _completeContext();

    public SurfaceData getReplacement() {
        this.markDirty(false);
        return this.fPeer.getSurfaceData();
    }

    public boolean copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        Cloneable cloneable;
        if (!this.fActiveSurface) {
            return true;
        }
        Component component = this.fPeer.fTarget;
        int n7 = 0;
        int n8 = 0;
        while (component != null && !(component instanceof Window)) {
            n7 += component.getX();
            n8 += component.getY();
            component = component.getParent();
        }
        if (component.getPeer() instanceof CWindow) {
            cloneable = ((CWindow)component.getPeer()).getLocationInWindow();
            n7 += ((Point)cloneable).x;
            n8 += ((Point)cloneable).y;
        }
        cloneable = sunGraphics2D.getCompBounds();
        CWindow cWindow = ((ComponentModel)component.getPeer()).getCWindowContainer();
        Shape shape = sunGraphics2D.getClip();
        Rectangle rectangle = new Rectangle(0, 0, cloneable.width, cloneable.height);
        sunGraphics2D.setClip(rectangle);
        CSurfaceData.fCRenderer.copyAreaInWindow(sunGraphics2D, cWindow.getModelPtr(), n + (n7 += cloneable.x), n2 + (n8 += cloneable.y), n3, n4, n5, n6);
        sunGraphics2D.setClip(shape);
        return true;
    }

    public BufferedImage copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, BufferedImage bufferedImage) {
        Object object;
        Object object2;
        if (!this.fActiveSurface) {
            return null;
        }
        Component component = this.fPeer.fTarget;
        int n5 = 0;
        int n6 = 0;
        while (component != null && !(component instanceof Window)) {
            n5 += component.getX();
            n6 += component.getY();
            component = component.getParent();
        }
        if (component.getPeer() instanceof CWindow) {
            object2 = ((CWindow)component.getPeer()).getLocationInWindow();
            n5 += ((Point)object2).x;
            n6 += ((Point)object2).y;
        }
        if (bufferedImage == null) {
            object2 = this.getDeviceConfiguration();
            bufferedImage = ((GraphicsConfiguration)object2).createCompatibleImage(n3, n4);
            object = bufferedImage.getGraphics();
            ((Graphics)object).dispose();
        }
        object2 = BufImgSurfaceData.getSurfaceData((BufferedImage)bufferedImage);
        object = null;
        try {
            object = CSurfaceData.fCRenderer.copyAreaFromWindow(sunGraphics2D, n + n5, n2 + n6, n3, n4, bufferedImage, (SurfaceData)object2);
        }
        catch (InvalidPipeException invalidPipeException) {
            object = null;
        }
        return object;
    }

    public void validatePipe(SunGraphics2D sunGraphics2D) {
        if (this.fActiveSurface) {
            super.validatePipe(sunGraphics2D);
        } else {
            sunGraphics2D.drawpipe = CSurfaceData.sNullPipe;
            sunGraphics2D.fillpipe = CSurfaceData.sNullPipe;
            sunGraphics2D.shapepipe = CSurfaceData.sNullPipe;
            sunGraphics2D.textpipe = CSurfaceData.sNullPipe;
            sunGraphics2D.imagepipe = CSurfaceData.sNullPipe;
        }
    }

    public boolean isActive() {
        return this.fActiveSurface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        if (this.isValid()) {
            Object object = this.fLockFocusedLOCK;
            synchronized (object) {
                if (this.fIsLockFocused) {
                    this.completeContext();
                }
            }
            this._markInvalid();
            super.invalidate();
        }
    }

    private native void _markInvalid();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flushIfNeeded() {
        ContainerModel containerModel = this.fPeer;
        if (containerModel == null) {
            return;
        }
        ContainerModel containerModel2 = containerModel;
        synchronized (containerModel2) {
            if (!containerModel.isDisposed()) {
                super.flushIfNeeded();
            }
        }
    }
}

