/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CComponent;
import apple.awt.CGraphicsConfig;
import apple.awt.RuntimeOptions;
import java.awt.AWTPermission;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.Window;
import sun.awt.DisplayChangedListener;
import sun.awt.SunDisplayChanger;

public class CGraphicsDevice
extends GraphicsDevice
implements DisplayChangedListener {
    private SunDisplayChanger topLevels = new SunDisplayChanger();
    private static AWTPermission fullScreenExclusivePermission;
    GraphicsConfiguration[] configs;
    int screenIndex;
    boolean inFullScreenMode;
    int displayID;
    int fadeToken;

    public CGraphicsDevice(int n) {
        this.screenIndex = n;
    }

    public int getType() {
        return 0;
    }

    public String getIDstring() {
        return ((CGraphicsConfig)this.getDefaultConfiguration()).getIDString();
    }

    public GraphicsConfiguration[] getConfigurations() {
        GraphicsConfiguration[] graphicsConfigurationArray = this.configs;
        if (graphicsConfigurationArray == null) {
            graphicsConfigurationArray = new GraphicsConfiguration[]{new CGraphicsConfig(this)};
            this.configs = graphicsConfigurationArray;
        }
        return graphicsConfigurationArray;
    }

    public GraphicsConfiguration getDefaultConfiguration() {
        return this.getConfigurations()[0];
    }

    public int getScreen() {
        return this.screenIndex;
    }

    public void displayChanged() {
        this.configs = null;
        this.topLevels.notifyListeners();
    }

    public void paletteChanged() {
    }

    public void addDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.topLevels.add(displayChangedListener);
    }

    public void removeDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.topLevels.remove(displayChangedListener);
    }

    public boolean isOffscreenAccelerationEnabled() {
        return true;
    }

    public boolean isDisplayChangeSupported() {
        return true;
    }

    public boolean isFullScreenSupported() {
        return true;
    }

    public void setFullScreenWindow(Window window) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (fullScreenExclusivePermission == null) {
                fullScreenExclusivePermission = new AWTPermission("fullScreenExclusive");
            }
            securityManager.checkPermission(fullScreenExclusivePermission);
        }
        if (window != null && this.getFullScreenWindow() == null) {
            super.setFullScreenWindow(window);
            if (!RuntimeOptions.FakeFullScreen) {
                this.enterFullScreen();
                this.inFullScreenMode = true;
            }
        } else if (this.getFullScreenWindow() != null) {
            super.setFullScreenWindow(window);
            if (!RuntimeOptions.FakeFullScreen) {
                this.exitFullScreen();
                this.inFullScreenMode = false;
            }
        }
    }

    public void setDisplayMode(DisplayMode displayMode) {
        if (displayMode == null || !this._setDisplayMode(displayMode)) {
            throw new IllegalArgumentException("Invalid display mode");
        }
        Window window = this.getFullScreenWindow();
        if (window != null) {
            if (displayMode.getBitDepth() == 8) {
                throw new IllegalArgumentException("Invalid display mode");
            }
            CComponent cComponent = (CComponent)window.getPeer();
            this._configDisplayMode(this.screenIndex, cComponent, displayMode.getWidth(), displayMode.getHeight(), displayMode.getBitDepth(), displayMode.getRefreshRate());
        }
    }

    private native boolean _setDisplayMode(DisplayMode var1);

    private void _configDisplayMode(int n, CComponent cComponent, int n2, int n3, int n4, int n5) {
    }

    public boolean isFullScreen() {
        return this.inFullScreenMode;
    }

    public native DisplayMode getDisplayMode();

    public DisplayMode[] getDisplayModes() {
        return this.getDisplayModes(this.isFullScreen());
    }

    private native DisplayMode[] getDisplayModes(boolean var1);

    native long getNSScreen();

    native int getScreenResolution();

    native Insets getScreenInsets();

    static native int getScreenIndexForCWindow(long var0);

    public native void enterFullScreen();

    public native void exitFullScreen();
}

