/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CGraphicsDevice;
import apple.awt.IntegerNIORaster;
import apple.awt.OSXVolatileImage;
import java.awt.BufferCapabilities;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.security.AccessController;
import sun.security.action.LoadLibraryAction;

public class CGraphicsConfig
extends GraphicsConfiguration {
    static ColorModel sDefaultColorModelWithAlpha;
    static ColorModel sDefaultColorModelNoAlpha;
    BufferCapabilities bufferCaps;
    ImageCapabilities imageCaps;
    ImageCapabilities imageCapsAccel;
    CGraphicsDevice device;

    public CGraphicsConfig(CGraphicsDevice cGraphicsDevice) {
        this.device = cGraphicsDevice;
    }

    public GraphicsDevice getDevice() {
        return this.device;
    }

    public BufferedImage createCompatibleImage(int n, int n2) {
        return this.createCompatibleImage(n, n2, 3);
    }

    public VolatileImage createCompatibleVolatileImage(int n, int n2) {
        return new OSXVolatileImage(this, n, n2);
    }

    public BufferedImage createCompatibleImage(int n, int n2, int n3) {
        DirectColorModel directColorModel = (DirectColorModel)this.getColorModel(n3);
        WritableRaster writableRaster = IntegerNIORaster.createNIORaster(n, n2, directColorModel.getMasks(), null);
        return new BufferedImage(directColorModel, writableRaster, directColorModel.isAlphaPremultiplied(), null);
    }

    public ColorModel getColorModel() {
        return this.getColorModel(3);
    }

    public ColorModel getColorModel(int n) {
        if (n == 1) {
            return sDefaultColorModelNoAlpha;
        }
        if (n == 3) {
            return sDefaultColorModelWithAlpha;
        }
        return sDefaultColorModelWithAlpha;
    }

    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    public AffineTransform getNormalizingTransform() {
        return new AffineTransform();
    }

    public Rectangle getBounds() {
        return this.getBoundsForDisplay();
    }

    native String getIDString();

    private native Rectangle getBoundsForDisplay();

    public BufferCapabilities getBufferCapabilities() {
        if (this.bufferCaps == null) {
            this.bufferCaps = new BufferCapabilities(this.getImageCapabilities(), this.getImageCapabilities(true), null);
        }
        return this.bufferCaps;
    }

    public ImageCapabilities getImageCapabilities() {
        return this.getImageCapabilities(false);
    }

    public ImageCapabilities getImageCapabilities(boolean bl) {
        if (!bl) {
            if (this.imageCaps == null) {
                this.imageCaps = new ImageCapabilities(bl);
            }
            return this.imageCaps;
        }
        if (this.imageCapsAccel == null) {
            this.imageCapsAccel = new ImageCapabilities(bl);
        }
        return this.imageCapsAccel;
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        sDefaultColorModelWithAlpha = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
        sDefaultColorModelNoAlpha = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
    }
}

