/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CImage;
import apple.awt.SimpleSystemAPI;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.security.AccessController;
import sun.security.action.LoadLibraryAction;

public class CColorPaint
extends Color {
    private long fNSColor = 0L;

    public CColorPaint(long l) {
        super(0, 0, 0);
        this.setNSColor(l);
    }

    public CColorPaint(TexturePaint texturePaint) {
        super(0, 0, 0);
        CImage cImage = new CImage(texturePaint.getImage());
        this.setColorFromCImage(cImage);
        cImage.dispose();
    }

    public CColorPaint(CImage cImage) {
        super(0, 0, 0);
        this.setColorFromCImage(cImage);
    }

    public CColorPaint(long l, int n, int n2, int n3) {
        super(n, n2, n3);
        this.setNSColor(l);
    }

    public CColorPaint(float f, float f2, float f3, float f4) {
        super(0, 0, 0);
        long l = CColorPaint.color(f, f2, f3, f4);
        this.setNSColor(l);
        SimpleSystemAPI.release(l);
    }

    public CColorPaint(float f, float f2) {
        super(0, 0, 0);
        long l = CColorPaint.color(f, f2);
        this.setNSColor(l);
        SimpleSystemAPI.release(l);
    }

    private void setColorFromCImage(CImage cImage) {
        long l = this.pattern(cImage.getNSImage());
        this.setNSColor(l);
        SimpleSystemAPI.release(l);
    }

    private void setNSColor(long l) {
        SimpleSystemAPI.release(this.fNSColor);
        this.fNSColor = l;
        SimpleSystemAPI.retain(this.fNSColor);
    }

    public void dispose() {
        SimpleSystemAPI.release(this.fNSColor);
        this.fNSColor = 0L;
    }

    public long getNSColor() {
        return this.fNSColor;
    }

    protected void finalize() {
        this.dispose();
    }

    public boolean equals(Object object) {
        return object instanceof CColorPaint && ((CColorPaint)object).fNSColor == this.fNSColor;
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        throw new IllegalAccessError("createContext() not valid for CColorPaint");
    }

    public int getTransparency() {
        return 3;
    }

    private native long pattern(long var1);

    private static native long color(float var0, float var1, float var2, float var3);

    private static native long color(float var0, float var1);

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
    }
}

