/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.transform;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.geotools.xml.transform.Translator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;

public abstract class TransformerBase {
    private int indentation = -1;
    private boolean xmlDecl = false;
    private boolean nsDecl = true;

    public abstract Translator createTranslator(ContentHandler var1);

    public Transformer createTransformer() throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        if (this.indentation > -1) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", this.indentation + "");
        } else {
            transformer.setOutputProperty("indent", "no");
        }
        if (this.xmlDecl) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        } else {
            transformer.setOutputProperty("omit-xml-declaration", "no");
        }
        return transformer;
    }

    public void transform(Object object, OutputStream out) throws TransformerException {
        this.transform(object, new StreamResult(out));
    }

    public void transform(Object object, Writer out) throws TransformerException {
        this.transform(object, new StreamResult(out));
    }

    public void transform(Object object, StreamResult result) throws TransformerException {
        Transformer t = this.createTransformer();
        SAXSource xmlSource = new SAXSource(this.createXMLReader(object), new InputSource());
        try {
            t.transform(xmlSource, result);
        }
        catch (RuntimeException re) {
            throw new TransformerException("Encoding Error", re);
        }
    }

    public XMLReader createXMLReader(Object object) {
        return new XMLReaderSupport(this, object);
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int amt) {
        this.indentation = amt;
    }

    public boolean isOmitXMLDeclaration() {
        return this.xmlDecl;
    }

    public void setOmitXMLDeclaration(boolean xmlDecl) {
        this.xmlDecl = xmlDecl;
    }

    public boolean isNamespaceDeclartionEnabled() {
        return this.nsDecl;
    }

    public void setNamespaceDeclarationEnabled(boolean enabled) {
        this.nsDecl = enabled;
    }

    protected static class XMLReaderSupport
    extends XMLFilterImpl {
        TransformerBase base;
        Object object;

        public XMLReaderSupport(TransformerBase transfomerBase, Object object) {
            this.base = transfomerBase;
            this.object = object;
        }

        public void parse(InputSource in) throws SAXException {
            Translator translator;
            ContentHandler handler = this.getContentHandler();
            if (this.base.isNamespaceDeclartionEnabled()) {
                SchemaLocationSupport schemaLocSup;
                AttributesImpl atts = new AttributesImpl();
                ContentHandlerFilter filter = new ContentHandlerFilter(handler, atts);
                translator = this.base.createTranslator(filter);
                atts.addAttribute(null, null, "xmlns:" + translator.getDefaultPrefix(), null, translator.getDefaultNamespace());
                NamespaceSupport ns = translator.getNamespaceSupport();
                Enumeration<String> e = ns.getPrefixes();
                while (e.hasMoreElements()) {
                    String xmlns;
                    String prefix = e.nextElement().toString();
                    if (prefix.equals("xml") || atts.getValue(xmlns = "xmlns:" + prefix) != null) continue;
                    atts.addAttribute(null, null, xmlns, null, ns.getURI(prefix));
                }
                String defaultNS = ns.getURI("");
                if (defaultNS != null && atts.getValue("xmlns:") == null) {
                    atts.addAttribute(null, null, "xmlns:", null, defaultNS);
                }
                if ((schemaLocSup = translator.getSchemaLocationSupport()) != null && !schemaLocSup.getSchemaLocation().equals("")) {
                    atts.addAttribute(null, null, "xmlns:xsi", null, "http://www.w3.org/2001/XMLSchema-instance");
                    atts.addAttribute(null, null, "xsi:schemaLocation", null, schemaLocSup.getSchemaLocation());
                }
            } else {
                translator = this.base.createTranslator(handler);
            }
            handler.startDocument();
            translator.encode(this.object);
            handler.endDocument();
        }
    }

    public static class SchemaLocationSupport {
        private Map locations = new HashMap();

        public void setLocation(String nsURI, String uri) {
            this.locations.put(nsURI, uri);
        }

        public String getSchemaLocation() {
            return this.getSchemaLocation(this.locations.keySet());
        }

        public String getSchemaLocation(String nsURI) {
            String uri = (String)this.locations.get(nsURI);
            if (uri == null) {
                return "";
            }
            return nsURI + " " + uri;
        }

        public String getSchemaLocation(Set namespaces) {
            StringBuffer location = new StringBuffer();
            Iterator it = namespaces.iterator();
            while (it.hasNext()) {
                location.append(this.getSchemaLocation((String)it.next()));
                if (!it.hasNext()) continue;
                location.append(" ");
            }
            return location.toString();
        }
    }

    protected static abstract class TranslatorSupport
    implements Translator {
        protected final ContentHandler contentHandler;
        private String prefix;
        private String namespace;
        protected final Attributes NULL_ATTS = new AttributesImpl();
        protected NamespaceSupport nsSupport = new NamespaceSupport();
        protected SchemaLocationSupport schemaLocation;

        public TranslatorSupport(ContentHandler contentHandler, String prefix, String nsURI) {
            this.contentHandler = contentHandler;
            this.prefix = prefix;
            this.namespace = nsURI;
            this.nsSupport.declarePrefix(prefix, nsURI);
        }

        public TranslatorSupport(ContentHandler contentHandler, String prefix, String nsURI, SchemaLocationSupport schemaLocation) {
            this(contentHandler, prefix, nsURI);
            this.schemaLocation = schemaLocation;
        }

        protected void element(String element, String content) {
            this.element(element, content, this.NULL_ATTS);
        }

        protected void element(String element, String content, Attributes atts) {
            this.start(element, atts);
            if (content != null) {
                this.chars(content);
            }
            this.end(element);
        }

        protected void start(String element) {
            this.start(element, this.NULL_ATTS);
        }

        protected void start(String element, Attributes atts) {
            try {
                String el = this.prefix == null ? element : this.prefix + ":" + element;
                this.contentHandler.startElement("", "", el, atts);
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        protected void chars(String text) {
            try {
                char[] ch = text.toCharArray();
                this.contentHandler.characters(ch, 0, ch.length);
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        protected void end(String element) {
            try {
                String el = this.prefix == null ? element : this.prefix + ":" + element;
                this.contentHandler.endElement("", "", el);
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        public String getDefaultNamespace() {
            return this.namespace;
        }

        public String getDefaultPrefix() {
            return this.prefix;
        }

        public NamespaceSupport getNamespaceSupport() {
            return this.nsSupport;
        }

        public SchemaLocationSupport getSchemaLocationSupport() {
            return this.schemaLocation;
        }
    }

    private static class ContentHandlerFilter
    implements ContentHandler {
        private final ContentHandler original;
        private AttributesImpl namespaceDecls;

        public ContentHandlerFilter(ContentHandler original, AttributesImpl nsDecls) {
            this.original = original;
            this.namespaceDecls = nsDecls;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.original.characters(ch, start, length);
        }

        public void endDocument() throws SAXException {
            this.original.endDocument();
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.original.endElement(namespaceURI, localName, qName);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.original.endPrefixMapping(prefix);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.original.ignorableWhitespace(ch, start, length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.original.processingInstruction(target, data);
        }

        public void setDocumentLocator(Locator locator) {
            this.original.setDocumentLocator(locator);
        }

        public void skippedEntity(String name) throws SAXException {
            this.original.skippedEntity(name);
        }

        public void startDocument() throws SAXException {
            this.original.startDocument();
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this.namespaceDecls != null) {
                int ii = atts.getLength();
                for (int i = 0; i < ii; ++i) {
                    this.namespaceDecls.addAttribute(null, null, atts.getQName(i), atts.getType(i), atts.getValue(i));
                }
                atts = this.namespaceDecls;
                this.namespaceDecls = null;
            }
            this.original.startElement(namespaceURI, localName, qName, atts);
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.original.startPrefixMapping(prefix, uri);
        }
    }
}

