/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.units;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.geotools.resources.Utilities;
import org.geotools.resources.XMath;
import org.geotools.resources.rsc.Resources;
import org.geotools.units.BaseUnit;
import org.geotools.units.DerivedUnit;
import org.geotools.units.Factor;
import org.geotools.units.OffsetUnit;
import org.geotools.units.Prefix;
import org.geotools.units.PrefixSet;
import org.geotools.units.ScaledUnit;
import org.geotools.units.SimpleUnit;
import org.geotools.units.Unit;
import org.geotools.units.UnitException;
import org.geotools.util.WeakHashSet;

final class UnitFormat {
    static final UnitFormat DEFAULT = new UnitFormat();
    private static final WeakHashSet pool = Prefix.pool;
    private static final double INV_EPS = 1.6777216E7;
    private static final Class[] PRIORITIES = new Class[]{BaseUnit.class, DerivedUnit.class, ScaledUnit.class, OffsetUnit.class};
    private static final char SCALE_SYMBOL = '\u00d7';
    private static final char DOT_SYMBOL = '\u00b7';
    private static final char SLASH_SYMBOL = '/';
    private static final char EXPONENT_SYMBOL = '^';
    private static final char OPEN_SYMBOL = '(';
    private static final char CLOSE_SYMBOL = ')';

    final StringBuffer format(Factor factor, StringBuffer buffer) {
        if (factor.power != 0) {
            buffer.append(factor.baseUnit.symbol);
            if (factor.power != 1) {
                String power = String.valueOf(factor.power);
                int length = power.length();
                int initPos = buffer.length();
                for (int i = 0; i < length; ++i) {
                    char c = power.charAt(i);
                    char s = Utilities.toSuperScript(c);
                    if (s == c) {
                        buffer.setLength(initPos);
                        buffer.append('^');
                        buffer.append(power);
                        return buffer;
                    }
                    buffer.append(s);
                }
            }
        } else {
            buffer.append('1');
        }
        return buffer;
    }

    final StringBuffer format(Factor[] factors, StringBuffer buffer) {
        Factor factor;
        int i;
        int numeratorCount = 0;
        int denominatorCount = 0;
        for (i = 0; i < factors.length; ++i) {
            factor = factors[i];
            if (factor.power > 0) {
                if (numeratorCount != 0) {
                    buffer.append('\u00b7');
                }
                buffer = this.format(factor, buffer);
                ++numeratorCount;
                continue;
            }
            if (factor.power >= 0) continue;
            ++denominatorCount;
        }
        if (denominatorCount != 0) {
            if (numeratorCount == 0) {
                buffer.append('1');
            }
            buffer.append('/');
            if (denominatorCount != 1) {
                buffer.append('(');
            }
            denominatorCount = 0;
            for (i = 0; i < factors.length; ++i) {
                factor = factors[i];
                if (factor.power >= 0) continue;
                if (denominatorCount != 0) {
                    buffer.append('\u00b7');
                }
                buffer = this.format(factor.inverse(), buffer);
                ++denominatorCount;
            }
            if (denominatorCount != 1) {
                buffer.append(')');
            }
        }
        return buffer;
    }

    final StringBuffer formatScaled(double amount, SimpleUnit unit, StringBuffer buffer) {
        double power;
        String symbol = unit.symbol;
        int length = symbol.length();
        int initPos = buffer.length();
        PrefixSet prefix = unit.prefix;
        if (prefix != null) {
            Prefix p;
            String unprefixedSymbol = unit.getUnprefixedSymbol();
            if (symbol.endsWith(unprefixedSymbol) && (p = prefix.getPrefix(symbol.substring(0, symbol.length() - unprefixedSymbol.length()))) != null) {
                symbol = unprefixedSymbol;
                amount *= p.amount;
            }
            if ((p = prefix.getPrefix(amount)) != null) {
                symbol = p.symbol + symbol;
                amount /= p.amount;
            }
        }
        if ((power = Math.rint(XMath.log10(amount) * 1.6777216E7) / 1.6777216E7) == Math.rint(power)) {
            amount = XMath.pow10(power);
        }
        if (amount != 1.0) {
            NumberFormat format = NumberFormat.getNumberInstance();
            buffer.append('\u00d7');
            format.format(amount, buffer, new FieldPosition(0));
            if (length != 0) {
                buffer.append('\u00a0');
            }
        }
        buffer.append(symbol);
        return buffer;
    }

    final StringBuffer formatOffset(double offset, Unit unit, StringBuffer buffer) {
        DecimalFormat cast;
        String symbol = unit.toString();
        int length = symbol.length();
        NumberFormat format = NumberFormat.getNumberInstance();
        if (format instanceof DecimalFormat && (cast = (DecimalFormat)format).getPositivePrefix().trim().length() == 0) {
            cast.setPositivePrefix("+");
        }
        format.format(offset, buffer, new FieldPosition(0));
        if (length != 0) {
            buffer.append('\u00a0');
            buffer.append(symbol);
        }
        return buffer;
    }

    final Object parse(String symbol) throws IllegalArgumentException {
        HashSet set = new HashSet(11);
        String unrecognized = this.parse(symbol.replace('*', '\u00b7'), set);
        Unit[] units = set.toArray(new Unit[set.size()]);
        switch (units.length) {
            case 0: {
                return unrecognized;
            }
            case 1: {
                return units[0];
            }
        }
        return this.selectUnit(units);
    }

    private String parse(String symbol, Set set) throws IllegalArgumentException {
        symbol = symbol.trim();
        int initialSize = set.size();
        int lower = 0;
        int upper = 0;
        int level = 0;
        int index = 0;
        int length = symbol.length();
        while (index < length) {
            switch (symbol.charAt(index)) {
                case '(': {
                    ++level;
                    ++index;
                    break;
                }
                case ')': {
                    --level;
                    ++index;
                    break;
                }
                default: {
                    if (upper == 0) {
                        lower = index;
                    }
                    upper = ++index;
                }
            }
            if (level != 0) continue;
        }
        if (level != 0) {
            throw new IllegalArgumentException(Resources.format(9, symbol, String.valueOf(level >= 0 ? (char)')' : '(')));
        }
        if (index == length) {
            if (lower > (upper = length - upper)) {
                lower = upper;
            }
            if (upper > lower) {
                upper = lower;
            }
            upper = length - upper;
            symbol = symbol.substring(lower, upper);
        }
        int level2 = 0;
        String unrecognized = null;
        int i = symbol.length();
        block21: while (--i >= 0 && level2 <= 0) {
            int power;
            switch (symbol.charAt(i)) {
                case '(': {
                    ++level2;
                    continue block21;
                }
                case ')': {
                    --level2;
                    continue block21;
                }
                case '\u00b7': {
                    power = 1;
                    break;
                }
                case '/': {
                    power = -1;
                    break;
                }
                default: {
                    continue block21;
                }
            }
            if (level2 != 0) continue;
            HashSet unitsA = new HashSet(11);
            HashSet unitsB = new HashSet(11);
            String tmp = this.parse(symbol.substring(0, i), unitsA);
            if (unrecognized == null) {
                unrecognized = tmp;
            }
            tmp = this.parse(symbol.substring(i + 1), unitsB);
            if (unrecognized == null) {
                unrecognized = tmp;
            }
            Iterator itA = unitsA.iterator();
            while (itA.hasNext()) {
                Unit unitA = (Unit)itA.next();
                Iterator itB = unitsB.iterator();
                while (itB.hasNext()) {
                    Unit unitB = (Unit)itB.next();
                    try {
                        Unit unit;
                        switch (power) {
                            case -1: {
                                unit = unitA.divide(unitB);
                                break;
                            }
                            case 1: {
                                unit = unitA.multiply(unitB);
                                break;
                            }
                            default: {
                                unit = unitA.multiply(unitB.pow(power));
                            }
                        }
                        set.add(unit);
                    }
                    catch (UnitException exception) {}
                }
            }
            return set.size() == initialSize ? unrecognized : null;
        }
        if (level2 != 0) {
            throw new IllegalArgumentException(Resources.format(9, symbol, String.valueOf(level2 >= 0 ? (char)')' : '(')));
        }
        int power = 1;
        boolean powerParsed = false;
        while (true) {
            int expStart;
            int length2 = symbol.length();
            for (int lower2 = 0; lower2 < length2; ++lower2) {
                Unit unit = Unit.getCached(symbol.substring(lower2));
                if (unit == null) continue;
                if (lower2 != 0) {
                    Prefix prefix;
                    if (unit.prefix == null || (prefix = unit.prefix.getPrefix(symbol.substring(0, lower2))) == null) continue;
                    unit = unit.scale(prefix.amount);
                }
                try {
                    set.add(unit.pow(power));
                    continue;
                }
                catch (UnitException exception) {
                    // empty catch block
                }
            }
            if (powerParsed) {
                return set.size() == initialSize ? symbol : null;
            }
            powerParsed = true;
            int symbolEnd = symbol.lastIndexOf(94);
            if (symbolEnd >= 0) {
                expStart = symbolEnd + 1;
            } else {
                symbolEnd = length2;
                while (--symbolEnd >= 0 && Utilities.isSuperScript(symbol.charAt(symbolEnd))) {
                }
                expStart = ++symbolEnd;
            }
            if (symbolEnd < 1 || expStart >= length2) break;
            StringBuffer tmp = new StringBuffer(symbol.substring(expStart));
            int i2 = tmp.length();
            while (--i2 >= 0) {
                tmp.setCharAt(i2, Utilities.toNormalScript(tmp.charAt(i2)));
            }
            String powerText = tmp.toString();
            symbol = symbol.substring(0, symbolEnd);
            try {
                power = Integer.parseInt(powerText);
            }
            catch (NumberFormatException exception) {
                return set.size() == initialSize ? powerText : null;
            }
        }
        return set.size() == initialSize ? symbol : null;
    }

    protected Unit selectUnit(Unit[] units) {
        for (int i = 0; i < PRIORITIES.length; ++i) {
            Class c = PRIORITIES[i];
            for (int j = 0; j < units.length; ++j) {
                Unit u = units[j];
                if (!c.isAssignableFrom(u.getClass())) continue;
                return u;
            }
        }
        return units[0];
    }
}

