/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.units;

import org.geotools.resources.units.Units;
import org.geotools.units.BaseUnit;
import org.geotools.units.DerivedUnit;
import org.geotools.units.OffsetUnit;
import org.geotools.units.Prefix;
import org.geotools.units.PrefixSet;
import org.geotools.units.ScaledUnit;
import org.geotools.units.Unit;
import org.geotools.units.UnitException;
import org.geotools.units.UnitTransform;

abstract class SimpleUnit
extends Unit {
    private static final long serialVersionUID = -1702845175242358392L;
    final String quantityName;

    SimpleUnit(String quantityName, String symbol, PrefixSet prefix) {
        super(symbol, prefix);
        this.quantityName = quantityName;
    }

    public final String getQuantityName() {
        return this.quantityName;
    }

    public String getLocalizedName() {
        Prefix p;
        String unpref = this.getUnprefixedSymbol();
        if (this.prefix != null && this.symbol.endsWith(unpref) && (p = this.prefix.getPrefix(this.symbol.substring(0, this.symbol.length() - unpref.length()))) != null) {
            return p.getLocalizedName() + Units.localize(unpref);
        }
        return super.getLocalizedName();
    }

    String getUnprefixedSymbol() {
        return this.symbol;
    }

    public abstract Unit pow(int var1);

    final Unit inverseMultiply(ScaledUnit that) throws UnitException {
        return ScaledUnit.getInstance(that.amount, (SimpleUnit)that.unit.multiply(this));
    }

    abstract Unit inverseMultiply(BaseUnit var1) throws UnitException;

    abstract Unit inverseMultiply(DerivedUnit var1) throws UnitException;

    final Unit inverseDivide(ScaledUnit that) throws UnitException {
        return ScaledUnit.getInstance(that.amount, (SimpleUnit)that.unit.divide(this));
    }

    abstract Unit inverseDivide(BaseUnit var1) throws UnitException;

    abstract Unit inverseDivide(DerivedUnit var1) throws UnitException;

    abstract UnitTransform getTransform(BaseUnit var1) throws UnitException;

    abstract UnitTransform getTransform(DerivedUnit var1) throws UnitException;

    abstract UnitTransform getInverseTransform(BaseUnit var1) throws UnitException;

    abstract UnitTransform getInverseTransform(DerivedUnit var1) throws UnitException;

    public final Unit scale(double amount) {
        return ScaledUnit.getInstance(amount, this);
    }

    public final Unit shift(double offset) {
        return OffsetUnit.getInstance(offset, this);
    }
}

