/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.units;

import org.geotools.resources.XMath;
import org.geotools.resources.rsc.Resources;
import org.geotools.resources.units.Units;
import org.geotools.units.BaseUnit;
import org.geotools.units.CompoundTransform;
import org.geotools.units.DerivedUnit;
import org.geotools.units.IdentityTransform;
import org.geotools.units.InverseTransform;
import org.geotools.units.OffsetUnit;
import org.geotools.units.Prefix;
import org.geotools.units.PrefixSet;
import org.geotools.units.ScaledTransform;
import org.geotools.units.SimpleUnit;
import org.geotools.units.Unit;
import org.geotools.units.UnitException;
import org.geotools.units.UnitFormat;
import org.geotools.units.UnitTransform;

final class ScaledUnit
extends Unit {
    private static final long serialVersionUID = -5387831470112872874L;
    private static final double INV_EPS = 1.6777216E7;
    public final double amount;
    public final SimpleUnit unit;

    private ScaledUnit(double amount, SimpleUnit unit, String symbol, PrefixSet prefix) {
        super(symbol, prefix);
        this.amount = amount;
        this.unit = unit;
        if (unit == null) {
            throw new NullPointerException(Resources.format(14));
        }
        if (Double.isNaN(amount) || Double.isInfinite(amount) || amount == 0.0) {
            throw new IllegalArgumentException(Resources.format(13, new Double(amount)));
        }
    }

    public static Unit getInstance(double amount, SimpleUnit unit) {
        return ScaledUnit.getInstance(amount, unit, null, null);
    }

    public static Unit getInstance(double amount, SimpleUnit unit, String symbol, PrefixSet prefix) {
        double power = Math.rint(XMath.log10(amount) * 1.6777216E7) / 1.6777216E7;
        if (power == Math.rint(power)) {
            amount = XMath.pow10(power);
        }
        if (amount == 1.0) {
            if (unit == null) {
                throw new NullPointerException(Resources.format(14));
            }
            if (symbol != null) {
                // empty if block
            }
            return unit;
        }
        if (symbol == null) {
            symbol = UnitFormat.DEFAULT.formatScaled(amount, unit, new StringBuffer()).toString();
            return new ScaledUnit(amount, unit, symbol, null).internIgnoreSymbol();
        }
        return new ScaledUnit(amount, unit, symbol, prefix).intern();
    }

    public Unit rename(String symbol, PrefixSet prefix) {
        return ScaledUnit.getInstance(this.amount, this.unit, symbol, prefix);
    }

    public String getLocalizedName() {
        Prefix p;
        PrefixSet prefix = this.unit.prefix;
        String unpref = this.unit.getUnprefixedSymbol();
        if (prefix != null && this.symbol.endsWith(unpref) && (p = prefix.getPrefix(this.symbol.substring(0, this.symbol.length() - unpref.length()))) != null) {
            return p.getLocalizedName() + Units.localize(unpref);
        }
        return super.getLocalizedName();
    }

    public String getQuantityName() {
        return this.unit.getQuantityName();
    }

    public Unit pow(int power) {
        switch (power) {
            case 0: {
                return DerivedUnit.DIMENSIONLESS;
            }
            case 1: {
                return this;
            }
        }
        return ScaledUnit.getInstance(Math.pow(this.amount, power), (SimpleUnit)this.unit.pow(power));
    }

    public Unit pow(double power) throws UnitException {
        int integer = (int)power;
        if ((double)integer == power) {
            return this.pow(integer);
        }
        return ScaledUnit.getInstance(Math.pow(this.amount, power), (SimpleUnit)this.unit.pow(power));
    }

    public Unit multiply(Unit that) throws UnitException {
        return that.inverseMultiply(this);
    }

    Unit inverseMultiply(BaseUnit that) throws UnitException {
        SimpleUnit unitThatThis = (SimpleUnit)this.unit.inverseMultiply(that);
        return unitThatThis != this.unit ? ScaledUnit.getInstance(this.amount, unitThatThis) : this;
    }

    Unit inverseMultiply(DerivedUnit that) throws UnitException {
        SimpleUnit unitThatThis = (SimpleUnit)this.unit.inverseMultiply(that);
        return unitThatThis != this.unit ? ScaledUnit.getInstance(this.amount, unitThatThis) : this;
    }

    Unit inverseMultiply(ScaledUnit that) throws UnitException {
        double newAmount = that.amount * this.amount;
        SimpleUnit unitThatThis = (SimpleUnit)that.unit.multiply(this.unit);
        return ScaledUnit.getInstance(newAmount, unitThatThis);
    }

    public Unit divide(Unit that) throws UnitException {
        return that.inverseDivide(this);
    }

    Unit inverseDivide(BaseUnit that) throws UnitException {
        SimpleUnit unitThatThis = (SimpleUnit)this.unit.inverseDivide(that);
        return unitThatThis != this.unit ? ScaledUnit.getInstance(this.amount, unitThatThis) : this;
    }

    Unit inverseDivide(DerivedUnit that) throws UnitException {
        SimpleUnit unitThatThis = (SimpleUnit)this.unit.inverseDivide(that);
        return unitThatThis != this.unit ? ScaledUnit.getInstance(this.amount, unitThatThis) : this;
    }

    Unit inverseDivide(ScaledUnit that) throws UnitException {
        double newAmount = that.amount / this.amount;
        SimpleUnit unitThatThis = (SimpleUnit)that.unit.divide(this.unit);
        return ScaledUnit.getInstance(newAmount, unitThatThis);
    }

    public Unit scale(double amount) {
        return amount == 1.0 ? this : ScaledUnit.getInstance(this.amount * amount, this.unit);
    }

    public Unit shift(double offset) {
        return offset == 0.0 ? this : OffsetUnit.getInstance(offset, this);
    }

    public boolean canConvert(Unit that) {
        return this.unit.canConvert(that);
    }

    public double convert(double value, Unit fromUnit) throws UnitException {
        if (fromUnit == this) {
            return value;
        }
        return this.unit.convert(value, fromUnit) / this.amount;
    }

    public void convert(double[] values, Unit fromUnit) throws UnitException {
        if (!this.equalsIgnoreSymbol(fromUnit)) {
            this.unit.convert(values, fromUnit);
            int i = 0;
            while (i < values.length) {
                int n = i++;
                values[n] = values[n] / this.amount;
            }
        }
    }

    public void convert(float[] values, Unit fromUnit) throws UnitException {
        if (!this.equalsIgnoreSymbol(fromUnit)) {
            this.unit.convert(values, fromUnit);
            for (int i = 0; i < values.length; ++i) {
                values[i] = (float)((double)values[i] / this.amount);
            }
        }
    }

    public UnitTransform getTransform(Unit fromUnit) throws UnitException {
        if (!this.equalsIgnoreSymbol(fromUnit)) {
            UnitTransform tr = this.unit.getTransform(fromUnit);
            if (tr instanceof ScaledTransform) {
                return ScaledTransform.getInstance(fromUnit, this, ((ScaledTransform)tr).amount * this.amount);
            }
            return CompoundTransform.getInstance(tr, ScaledTransform.getInstance(this.unit, this, this.amount));
        }
        return IdentityTransform.getInstance(fromUnit, this);
    }

    protected double inverseConvert(double value, Unit toUnit) throws UnitException {
        if (toUnit == this) {
            return value;
        }
        return this.unit.inverseConvert(value * this.amount, toUnit);
    }

    protected void inverseConvert(double[] values, Unit toUnit) throws UnitException {
        if (!this.equalsIgnoreSymbol(toUnit)) {
            if (this.unit.canConvert(toUnit)) {
                int i = 0;
                while (i < values.length) {
                    int n = i++;
                    values[n] = values[n] * this.amount;
                }
                this.unit.inverseConvert(values, toUnit);
            } else {
                throw toUnit.incompatibleUnitsException(this);
            }
        }
    }

    protected void inverseConvert(float[] values, Unit toUnit) throws UnitException {
        if (!this.equalsIgnoreSymbol(toUnit)) {
            if (this.unit.canConvert(toUnit)) {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = (float)((double)values[i] * this.amount);
                }
                this.unit.inverseConvert(values, toUnit);
            } else {
                throw toUnit.incompatibleUnitsException(this);
            }
        }
    }

    protected UnitTransform getInverseTransform(Unit toUnit) throws UnitException {
        if (!this.equalsIgnoreSymbol(toUnit)) {
            UnitTransform tr = InverseTransform.getInstance(this.unit, toUnit);
            if (tr instanceof ScaledTransform) {
                double amount = ((ScaledTransform)tr).amount / this.amount;
                return ScaledTransform.getInstance(this, toUnit, amount);
            }
            return CompoundTransform.getInstance(ScaledTransform.getInstance(this, this.unit, 1.0 / this.amount), tr);
        }
        return IdentityTransform.getInstance(this, toUnit);
    }

    public boolean equalsIgnoreSymbol(Unit unit) {
        if (unit instanceof ScaledUnit) {
            ScaledUnit that = (ScaledUnit)unit;
            return Double.doubleToLongBits(this.amount) == Double.doubleToLongBits(that.amount) && this.unit.equalsIgnoreSymbol(that.unit);
        }
        return false;
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.amount);
        return (int)code ^ (int)(code >>> 32) ^ this.unit.hashCode();
    }
}

