/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.units;

import org.geotools.resources.rsc.Resources;
import org.geotools.units.IdentityTransform;
import org.geotools.units.Unit;
import org.geotools.units.UnitException;
import org.geotools.units.UnitTransform;

final class ScaledTransform
extends UnitTransform {
    private static final long serialVersionUID = 4620148316930810993L;
    public final double amount;

    private ScaledTransform(Unit fromUnit, Unit toUnit, double amount) throws UnitException {
        super(fromUnit, toUnit);
        this.amount = amount;
        if (Double.isNaN(amount) || Double.isInfinite(amount) || amount == 0.0) {
            throw new UnitException(Resources.format(13, new Double(amount)));
        }
    }

    public static UnitTransform getInstance(Unit fromUnit, Unit toUnit, double amount) throws UnitException {
        if (amount == 1.0) {
            return IdentityTransform.getInstance(fromUnit, toUnit);
        }
        return new ScaledTransform(fromUnit, toUnit, amount).intern();
    }

    public boolean isIdentity() {
        return this.amount == 1.0;
    }

    public double convert(double value) {
        return value / this.amount;
    }

    public void convert(double[] values) {
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] / this.amount;
        }
    }

    public void convert(float[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = (float)((double)values[i] / this.amount);
        }
    }

    public double inverseConvert(double value) {
        return value * this.amount;
    }

    public void inverseConvert(double[] values) {
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] * this.amount;
        }
    }

    public void inverseConvert(float[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = (float)((double)values[i] * this.amount);
        }
    }

    public boolean equals(Object o) {
        return super.equals(o) && Double.doubleToLongBits(this.amount) == Double.doubleToLongBits(((ScaledTransform)o).amount);
    }
}

