/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.units;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import org.geotools.units.Prefix;
import org.geotools.util.WeakHashSet;

final class PrefixSet
implements Serializable {
    private static final long serialVersionUID = -8301096197856692402L;
    private static final WeakHashSet pool;
    private final Prefix[] prefix;
    static final /* synthetic */ boolean $assertionsDisabled;

    private PrefixSet(Prefix[] p) {
        int length;
        Object[] px = new Prefix[p.length];
        System.arraycopy(p, 0, px, 0, px.length);
        Arrays.sort(px);
        int i = length = px.length;
        while (--i >= 1) {
            if (((Prefix)px[i]).amount != ((Prefix)px[i - 1]).amount) continue;
            px[i] = null;
            --length;
        }
        i = 0;
        this.prefix = new Prefix[length];
        for (int j = 0; j < px.length; ++j) {
            if (px[j] == null) continue;
            this.prefix[i++] = px[j];
        }
        if (!$assertionsDisabled && i != length) {
            throw new AssertionError();
        }
    }

    public static PrefixSet getPrefixSet(Prefix[] p) {
        return new PrefixSet(p).intern();
    }

    public Prefix getPrefix(String symbol) {
        for (int i = 0; i < this.prefix.length; ++i) {
            Prefix p = this.prefix[i];
            if (!symbol.equals(p.symbol)) continue;
            return p;
        }
        return null;
    }

    public Prefix getPrefix(double amount) {
        int index;
        if ((index = Arrays.binarySearch(this.prefix, new Prefix(amount += 1.0E-8 * Math.abs(amount)))) < 0) {
            if ((index ^= 0xFFFFFFFF) == 0) {
                return null;
            }
            if (index > this.prefix.length) {
                index = this.prefix.length;
            }
            --index;
        }
        return this.prefix[index];
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.prefix.length; ++i) {
            Prefix p = this.prefix[i];
            String name = p.getLocalizedName();
            String symb = p.symbol;
            if (name.length() == 0 && symb.length() == 0) continue;
            if (buffer.length() != 0) {
                buffer.append(',');
            }
            buffer.append(name);
            if (symb.length() == 0) continue;
            buffer.append('(');
            buffer.append(symb);
            buffer.append(')');
        }
        return buffer.toString();
    }

    public boolean equals(Object other) {
        Prefix[] array;
        if (other == this) {
            return true;
        }
        if (other instanceof PrefixSet && this.prefix.length == (array = ((PrefixSet)other).prefix).length) {
            for (int i = 0; i < array.length; ++i) {
                if (this.prefix[i].equals(array[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int code = this.prefix.length << 1;
        for (int i = 0; i < this.prefix.length; i += 5) {
            code += this.prefix[i].hashCode();
        }
        return code;
    }

    private final PrefixSet intern() {
        return (PrefixSet)pool.canonicalize(this);
    }

    final Object readResolve() throws ObjectStreamException {
        return this.intern();
    }

    static {
        $assertionsDisabled = !PrefixSet.class.desiredAssertionStatus();
        pool = Prefix.pool;
    }
}

