/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.units;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.geotools.util.WeakHashSet;

final class Prefix
implements Comparable,
Serializable {
    private static final long serialVersionUID = 3289659964721709283L;
    static final WeakHashSet pool = new WeakHashSet();
    public final String name;
    public final String symbol;
    public final double amount;

    Prefix(double amount) {
        this.name = "";
        this.symbol = "";
        this.amount = amount;
    }

    private Prefix(String name, String symbol, double amount) {
        this.name = name.trim();
        this.symbol = symbol.trim();
        this.amount = amount;
        if (!(amount > 0.0) || Double.isInfinite(amount)) {
            throw new IllegalArgumentException();
        }
    }

    public static Prefix getPrefix(String name, String symbol, double amount) {
        return new Prefix(name, symbol, amount).intern();
    }

    public String getLocalizedName() {
        return org.geotools.resources.units.Prefix.localize(this.name);
    }

    public String toString() {
        return this.symbol;
    }

    public int compareTo(Object object) {
        Prefix that = (Prefix)object;
        if (this.amount > that.amount) {
            return 1;
        }
        if (this.amount < that.amount) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Prefix) {
            Prefix prefix = (Prefix)object;
            return Double.doubleToLongBits(this.amount) == Double.doubleToLongBits(prefix.amount) && this.symbol.equals(prefix.symbol) && this.name.equals(prefix.name);
        }
        return false;
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.amount);
        return (int)code ^ (int)(code >>> 32);
    }

    private final Prefix intern() {
        return (Prefix)pool.canonicalize(this);
    }

    final Object readResolve() throws ObjectStreamException {
        return this.intern();
    }
}

