/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.units;

import org.geotools.resources.rsc.Resources;
import org.geotools.units.IdentityTransform;
import org.geotools.units.Unit;
import org.geotools.units.UnitException;
import org.geotools.units.UnitTransform;

final class OffsetTransform
extends UnitTransform {
    private static final long serialVersionUID = -5512331418450968824L;
    public final double offset;

    private OffsetTransform(Unit fromUnit, Unit toUnit, double offset) throws UnitException {
        super(fromUnit, toUnit);
        this.offset = offset;
        if (Double.isNaN(offset) || Double.isInfinite(offset)) {
            throw new UnitException(Resources.format(11, new Double(offset)));
        }
    }

    public static UnitTransform getInstance(Unit fromUnit, Unit toUnit, double offset) throws UnitException {
        if (offset == 0.0) {
            return IdentityTransform.getInstance(fromUnit, toUnit);
        }
        return new OffsetTransform(fromUnit, toUnit, offset).intern();
    }

    public boolean isIdentity() {
        return this.offset == 0.0;
    }

    public double convert(double value) {
        return value - this.offset;
    }

    public void convert(double[] values) {
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] - this.offset;
        }
    }

    public void convert(float[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = (float)((double)values[i] - this.offset);
        }
    }

    public double inverseConvert(double value) {
        return value + this.offset;
    }

    public void inverseConvert(double[] values) {
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] + this.offset;
        }
    }

    public void inverseConvert(float[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = (float)((double)values[i] + this.offset);
        }
    }

    public boolean equals(Object o) {
        return super.equals(o) && Double.doubleToLongBits(this.offset) == Double.doubleToLongBits(((OffsetTransform)o).offset);
    }
}

