/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.units;

import org.geotools.units.Unit;
import org.geotools.units.UnitTransform;

final class InverseTransform
extends UnitTransform {
    private static final long serialVersionUID = 8539885091744917242L;

    private InverseTransform(Unit fromUnit, Unit toUnit) {
        super(fromUnit, toUnit);
    }

    public static UnitTransform getInstance(Unit fromUnit, Unit toUnit) {
        return new InverseTransform(fromUnit, toUnit).intern();
    }

    public double convert(double value) {
        return 1.0 / value;
    }

    public void convert(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = 1.0 / values[i];
        }
    }

    public void convert(float[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = 1.0f / values[i];
        }
    }

    public double inverseConvert(double value) {
        return 1.0 / value;
    }

    public void inverseConvert(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = 1.0 / values[i];
        }
    }

    public void inverseConvert(float[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = 1.0f / values[i];
        }
    }
}

