/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.units;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.geotools.units.BaseUnit;
import org.geotools.units.Prefix;
import org.geotools.units.UnitFormat;
import org.geotools.util.WeakHashSet;

final class Factor
implements Serializable {
    private static final long serialVersionUID = -7448171508684390207L;
    private static final WeakHashSet pool = Prefix.pool;
    public final BaseUnit baseUnit;
    public final int power;

    private Factor(BaseUnit baseUnit, int power) {
        if (baseUnit == null) {
            throw new NullPointerException();
        }
        this.baseUnit = baseUnit;
        this.power = power;
    }

    public static Factor getFactor(BaseUnit baseUnit, int power) {
        return new Factor(baseUnit, power).intern();
    }

    public final Factor inverse() {
        return Factor.getFactor(this.baseUnit, -this.power);
    }

    public String toString() {
        return UnitFormat.DEFAULT.format(this, new StringBuffer()).toString();
    }

    final int compareDimensionality(Factor that) {
        if (that != null && this.baseUnit.equals(that.baseUnit)) {
            if (this.power == that.power) {
                return 1;
            }
            if (this.power == -that.power) {
                return -1;
            }
        }
        return 0;
    }

    final boolean equals(Factor factor) {
        return this.power == factor.power && this.baseUnit.equals(factor.baseUnit);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Factor && this.equals((Factor)object);
    }

    public int hashCode() {
        return this.baseUnit.hashCode() + this.power;
    }

    private final Factor intern() {
        return (Factor)pool.canonicalize(this);
    }

    final Object readResolve() throws ObjectStreamException {
        return this.intern();
    }
}

