/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.units;

import org.geotools.units.UnitTransform;

final class CompoundTransform
extends UnitTransform {
    private static final long serialVersionUID = 6193871497550654092L;
    private final UnitTransform transform1;
    private final UnitTransform transform2;

    private CompoundTransform(UnitTransform transform1, UnitTransform transform2) {
        super(transform1.fromUnit, transform2.toUnit);
        this.transform1 = transform1;
        this.transform2 = transform2;
    }

    public static UnitTransform getInstance(UnitTransform transform1, UnitTransform transform2) {
        if (transform1.isIdentity()) {
            return transform2;
        }
        if (transform2.isIdentity()) {
            return transform1;
        }
        return new CompoundTransform(transform1, transform2).intern();
    }

    public double convert(double value) {
        return this.transform2.convert(this.transform1.convert(value));
    }

    public void convert(double[] values) {
        this.transform1.convert(values);
        this.transform2.convert(values);
    }

    public void convert(float[] values) {
        this.transform1.convert(values);
        this.transform2.convert(values);
    }

    public double inverseConvert(double value) {
        return this.transform1.inverseConvert(this.transform2.inverseConvert(value));
    }

    public void inverseConvert(double[] values) {
        this.transform2.inverseConvert(values);
        this.transform1.inverseConvert(values);
    }

    public void inverseConvert(float[] values) {
        this.transform2.inverseConvert(values);
        this.transform1.inverseConvert(values);
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            CompoundTransform t = (CompoundTransform)o;
            return this.transform1.equals(t.transform1) && this.transform2.equals(t.transform2);
        }
        return false;
    }
}

