/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.units;

import org.geotools.units.DerivedUnit;
import org.geotools.units.Factor;
import org.geotools.units.IdentityTransform;
import org.geotools.units.PrefixSet;
import org.geotools.units.SimpleUnit;
import org.geotools.units.Unit;
import org.geotools.units.UnitException;
import org.geotools.units.UnitTransform;

final class BaseUnit
extends SimpleUnit {
    private static final long serialVersionUID = -2736303035387288589L;

    private BaseUnit(String quantityName, String symbol, PrefixSet prefix) {
        super(quantityName, symbol, prefix);
    }

    public static BaseUnit getInstance(String quantityName, String symbol, PrefixSet prefix) {
        return (BaseUnit)new BaseUnit(quantityName, symbol, prefix).intern();
    }

    String getUnprefixedSymbol() {
        return this.symbol.equals("kg") ? "g" : super.getUnprefixedSymbol();
    }

    public Unit rename(String symbol, PrefixSet prefix) {
        return BaseUnit.getInstance(this.quantityName, symbol, prefix);
    }

    public Unit pow(int power) {
        switch (power) {
            case 0: {
                return DerivedUnit.DIMENSIONLESS;
            }
            case 1: {
                return this;
            }
        }
        return DerivedUnit.getInstance(new Factor[]{Factor.getFactor(this, power)});
    }

    public Unit multiply(Unit that) throws UnitException {
        return that.inverseMultiply(this);
    }

    Unit inverseMultiply(DerivedUnit that) {
        return that.multiply(new Factor[]{Factor.getFactor(this, 1)});
    }

    Unit inverseMultiply(BaseUnit that) throws UnitException {
        Factor[] factors = this.equalsIgnoreSymbol(that) ? new Factor[]{Factor.getFactor(that, 2)} : new Factor[]{Factor.getFactor(that, 1), Factor.getFactor(this, 1)};
        return DerivedUnit.getInstance(factors);
    }

    public Unit divide(Unit that) throws UnitException {
        return that.inverseDivide(this);
    }

    Unit inverseDivide(DerivedUnit that) {
        return that.multiply(new Factor[]{Factor.getFactor(this, -1)});
    }

    Unit inverseDivide(BaseUnit that) throws UnitException {
        if (!this.equalsIgnoreSymbol(that)) {
            return DerivedUnit.getInstance(new Factor[]{Factor.getFactor(that, 1), Factor.getFactor(this, -1)});
        }
        return DerivedUnit.DIMENSIONLESS;
    }

    public boolean canConvert(Unit that) {
        return that.canConvert(this);
    }

    boolean canConvert(DerivedUnit that) {
        return that.canConvert(this);
    }

    boolean canConvert(BaseUnit that) {
        return this.equalsIgnoreSymbol(that);
    }

    public double convert(double value, Unit fromUnit) throws UnitException {
        return fromUnit.inverseConvert(value, this);
    }

    double convert(double value, DerivedUnit fromUnit) throws UnitException {
        return fromUnit.inverseConvert(value, this);
    }

    double convert(double value, BaseUnit fromUnit) throws UnitException {
        if (!this.equalsIgnoreSymbol(fromUnit)) {
            throw this.incompatibleUnitsException(fromUnit);
        }
        return value;
    }

    public void convert(double[] values, Unit fromUnit) throws UnitException {
        fromUnit.inverseConvert(values, this);
    }

    void convert(double[] values, DerivedUnit fromUnit) throws UnitException {
        fromUnit.inverseConvert(values, this);
    }

    void convert(double[] values, BaseUnit fromUnit) throws UnitException {
        if (!this.equalsIgnoreSymbol(fromUnit)) {
            throw this.incompatibleUnitsException(fromUnit);
        }
    }

    public void convert(float[] values, Unit fromUnit) throws UnitException {
        fromUnit.inverseConvert(values, this);
    }

    void convert(float[] values, DerivedUnit fromUnit) throws UnitException {
        fromUnit.inverseConvert(values, this);
    }

    void convert(float[] values, BaseUnit fromUnit) throws UnitException {
        if (!this.equalsIgnoreSymbol(fromUnit)) {
            throw this.incompatibleUnitsException(fromUnit);
        }
    }

    public UnitTransform getTransform(Unit fromUnit) throws UnitException {
        return fromUnit.getInverseTransform(this);
    }

    UnitTransform getTransform(DerivedUnit fromUnit) throws UnitException {
        return fromUnit.getInverseTransform(this);
    }

    UnitTransform getTransform(BaseUnit fromUnit) throws UnitException {
        return IdentityTransform.getInstance(fromUnit, this);
    }

    protected double inverseConvert(double value, Unit toUnit) throws UnitException {
        return toUnit.convert(value, this);
    }

    double inverseConvert(double value, DerivedUnit toUnit) throws UnitException {
        return toUnit.convert(value, this);
    }

    double inverseConvert(double value, BaseUnit toUnit) throws UnitException {
        if (!this.equalsIgnoreSymbol(toUnit)) {
            throw toUnit.incompatibleUnitsException(this);
        }
        return value;
    }

    protected void inverseConvert(double[] values, Unit toUnit) throws UnitException {
        toUnit.convert(values, this);
    }

    void inverseConvert(double[] values, DerivedUnit toUnit) throws UnitException {
        toUnit.convert(values, this);
    }

    void inverseConvert(double[] values, BaseUnit toUnit) throws UnitException {
        if (!this.equalsIgnoreSymbol(toUnit)) {
            throw toUnit.incompatibleUnitsException(this);
        }
    }

    protected void inverseConvert(float[] values, Unit toUnit) throws UnitException {
        toUnit.convert(values, this);
    }

    void inverseConvert(float[] values, DerivedUnit toUnit) throws UnitException {
        toUnit.convert(values, this);
    }

    void inverseConvert(float[] values, BaseUnit toUnit) throws UnitException {
        if (!this.equalsIgnoreSymbol(toUnit)) {
            throw toUnit.incompatibleUnitsException(this);
        }
    }

    protected UnitTransform getInverseTransform(Unit toUnit) throws UnitException {
        return toUnit.getTransform(this);
    }

    UnitTransform getInverseTransform(DerivedUnit toUnit) throws UnitException {
        return toUnit.getTransform(this);
    }

    UnitTransform getInverseTransform(BaseUnit toUnit) throws UnitException {
        return IdentityTransform.getInstance(this, toUnit);
    }

    final boolean equalsIgnoreSymbol(BaseUnit unit) {
        return unit == this || this.quantityName.equals(unit.quantityName);
    }

    public boolean equalsIgnoreSymbol(Unit unit) {
        return unit instanceof BaseUnit && this.equalsIgnoreSymbol((BaseUnit)unit);
    }

    public int hashCode() {
        return this.quantityName.hashCode();
    }
}

