/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.lang.reflect.Array;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;

public final class XArray {
    private XArray() {
    }

    private static Object doResize(Object array, int length) {
        int current;
        int n = current = array == null ? 0 : Array.getLength(array);
        if (current != length) {
            Object newArray = Array.newInstance(array.getClass().getComponentType(), length);
            System.arraycopy(array, 0, newArray, 0, Math.min(current, length));
            return newArray;
        }
        return array;
    }

    public static Object[] resize(Object[] array, int length) {
        return (Object[])XArray.doResize(array, length);
    }

    public static double[] resize(double[] array, int length) {
        return (double[])XArray.doResize(array, length);
    }

    public static float[] resize(float[] array, int length) {
        return (float[])XArray.doResize(array, length);
    }

    public static long[] resize(long[] array, int length) {
        return (long[])XArray.doResize(array, length);
    }

    public static int[] resize(int[] array, int length) {
        return (int[])XArray.doResize(array, length);
    }

    public static short[] resize(short[] array, int length) {
        return (short[])XArray.doResize(array, length);
    }

    public static byte[] resize(byte[] array, int length) {
        return (byte[])XArray.doResize(array, length);
    }

    public static char[] resize(char[] array, int length) {
        return (char[])XArray.doResize(array, length);
    }

    public static boolean[] resize(boolean[] array, int length) {
        return (boolean[])XArray.doResize(array, length);
    }

    private static Object doRemove(Object array, int index, int length) {
        if (length == 0) {
            return array;
        }
        int array_length = Array.getLength(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), array_length -= length);
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(array, index + length, newArray, index, array_length - index);
        return newArray;
    }

    public static Object[] remove(Object[] array, int index, int length) {
        return (Object[])XArray.doRemove(array, index, length);
    }

    public static double[] remove(double[] array, int index, int length) {
        return (double[])XArray.doRemove(array, index, length);
    }

    public static float[] remove(float[] array, int index, int length) {
        return (float[])XArray.doRemove(array, index, length);
    }

    public static long[] remove(long[] array, int index, int length) {
        return (long[])XArray.doRemove(array, index, length);
    }

    public static int[] remove(int[] array, int index, int length) {
        return (int[])XArray.doRemove(array, index, length);
    }

    public static short[] remove(short[] array, int index, int length) {
        return (short[])XArray.doRemove(array, index, length);
    }

    public static byte[] remove(byte[] array, int index, int length) {
        return (byte[])XArray.doRemove(array, index, length);
    }

    public static char[] remove(char[] array, int index, int length) {
        return (char[])XArray.doRemove(array, index, length);
    }

    public static boolean[] remove(boolean[] array, int index, int length) {
        return (boolean[])XArray.doRemove(array, index, length);
    }

    private static Object doInsert(Object array, int index, int length) {
        if (length == 0) {
            return array;
        }
        int array_length = Array.getLength(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), array_length + length);
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(array, index, newArray, index + length, array_length - index);
        return newArray;
    }

    public static Object[] insert(Object[] array, int index, int length) {
        return (Object[])XArray.doInsert(array, index, length);
    }

    public static double[] insert(double[] array, int index, int length) {
        return (double[])XArray.doInsert(array, index, length);
    }

    public static float[] insert(float[] array, int index, int length) {
        return (float[])XArray.doInsert(array, index, length);
    }

    public static long[] insert(long[] array, int index, int length) {
        return (long[])XArray.doInsert(array, index, length);
    }

    public static int[] insert(int[] array, int index, int length) {
        return (int[])XArray.doInsert(array, index, length);
    }

    public static short[] insert(short[] array, int index, int length) {
        return (short[])XArray.doInsert(array, index, length);
    }

    public static byte[] insert(byte[] array, int index, int length) {
        return (byte[])XArray.doInsert(array, index, length);
    }

    public static char[] insert(char[] array, int index, int length) {
        return (char[])XArray.doInsert(array, index, length);
    }

    public static boolean[] insert(boolean[] array, int index, int length) {
        return (boolean[])XArray.doInsert(array, index, length);
    }

    private static Object doInsert(Object src, int src_pos, Object dst, int dst_pos, int length) {
        if (length == 0) {
            return dst;
        }
        int dst_length = Array.getLength(dst);
        Object newArray = Array.newInstance(dst.getClass().getComponentType(), dst_length + length);
        System.arraycopy(dst, 0, newArray, 0, dst_pos);
        System.arraycopy(src, src_pos, newArray, dst_pos, length);
        System.arraycopy(dst, dst_pos, newArray, dst_pos + length, dst_length - dst_pos);
        return newArray;
    }

    public static Object[] insert(Object[] src, int src_pos, Object[] dst, int dst_pos, int length) {
        return (Object[])XArray.doInsert(src, src_pos, dst, dst_pos, length);
    }

    public static double[] insert(double[] src, int src_pos, double[] dst, int dst_pos, int length) {
        return (double[])XArray.doInsert(src, src_pos, dst, dst_pos, length);
    }

    public static float[] insert(float[] src, int src_pos, float[] dst, int dst_pos, int length) {
        return (float[])XArray.doInsert(src, src_pos, dst, dst_pos, length);
    }

    public static long[] insert(long[] src, int src_pos, long[] dst, int dst_pos, int length) {
        return (long[])XArray.doInsert(src, src_pos, dst, dst_pos, length);
    }

    public static int[] insert(int[] src, int src_pos, int[] dst, int dst_pos, int length) {
        return (int[])XArray.doInsert(src, src_pos, dst, dst_pos, length);
    }

    public static short[] insert(short[] src, int src_pos, short[] dst, int dst_pos, int length) {
        return (short[])XArray.doInsert(src, src_pos, dst, dst_pos, length);
    }

    public static byte[] insert(byte[] src, int src_pos, byte[] dst, int dst_pos, int length) {
        return (byte[])XArray.doInsert(src, src_pos, dst, dst_pos, length);
    }

    public static char[] insert(char[] src, int src_pos, char[] dst, int dst_pos, int length) {
        return (char[])XArray.doInsert(src, src_pos, dst, dst_pos, length);
    }

    public static boolean[] insert(boolean[] src, int src_pos, boolean[] dst, int dst_pos, int length) {
        return (boolean[])XArray.doInsert(src, src_pos, dst, dst_pos, length);
    }

    public static boolean isSorted(char[] array) {
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= array[i - 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(byte[] array) {
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= array[i - 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(short[] array) {
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= array[i - 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(int[] array) {
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= array[i - 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(long[] array) {
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= array[i - 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(float[] array) {
        int previous = 0;
        for (int i = 1; i < array.length; ++i) {
            float value = array[i];
            if (value < array[previous]) {
                return false;
            }
            if (Float.isNaN(value)) continue;
            previous = i;
        }
        return true;
    }

    public static boolean isSorted(double[] array) {
        int previous = 0;
        for (int i = 1; i < array.length; ++i) {
            double value = array[i];
            if (value < array[previous]) {
                return false;
            }
            if (Double.isNaN(value)) continue;
            previous = i;
        }
        return true;
    }

    public static boolean hasNaN(double[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!Double.isNaN(array[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNaN(float[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!Float.isNaN(array[i])) continue;
            return true;
        }
        return false;
    }

    public static String toString(Object array, Locale locale) {
        StringBuffer buffer = new StringBuffer();
        NumberFormat format = NumberFormat.getNumberInstance(locale);
        FieldPosition dummy = new FieldPosition(0);
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            format.format(Array.get(array, i), buffer, dummy);
        }
        return buffer.toString();
    }
}

