/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.prefs.Preferences;
import org.geotools.io.LineWriter;
import org.geotools.resources.Utilities;

public class Log4JFormatter
extends Formatter {
    private static final String PREFIX = "[";
    private static final String SUFFIX = "] ";
    private static long startMillis;
    private final String lineSeparator;
    private String bodyLineSeparator;
    private final int margin;
    private final String base;
    private final StringBuffer buffer;
    private final LineWriter writer;
    static /* synthetic */ Class class$java$util$logging$ConsoleHandler;
    static /* synthetic */ Class class$java$util$logging$SimpleFormatter;

    public Log4JFormatter(String base) {
        this.bodyLineSeparator = this.lineSeparator = System.getProperty("line.separator", "\n");
        this.base = base.trim();
        this.margin = Log4JFormatter.getHeaderWidth();
        startMillis = System.currentTimeMillis();
        StringWriter str = new StringWriter();
        this.writer = new LineWriter(str);
        this.buffer = str.getBuffer();
    }

    public synchronized String format(LogRecord record) {
        String logger = record.getLoggerName();
        String recordLevel = record.getLevel().getLocalizedName();
        try {
            this.buffer.setLength(1);
            Long millis = new Long(record.getMillis() - startMillis);
            this.writer.write(millis.toString());
            this.writer.write(" ");
            this.writer.write(PREFIX);
            this.writer.write(recordLevel);
            this.writer.write(SUFFIX);
            this.writer.write(record.getSourceClassName());
            this.writer.write(" - ");
            this.writer.setLineSeparator(this.bodyLineSeparator);
            this.writer.write(this.formatMessage(record));
            this.writer.setLineSeparator(this.lineSeparator);
            this.writer.write(10);
            this.writer.flush();
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
        return this.buffer.toString();
    }

    public static void init(String base, Level filterLevel) {
        Logger logger;
        Log4JFormatter log4j = null;
        Logger parent = logger = Logger.getLogger(base);
        while (parent.getUseParentHandlers() && (parent = parent.getParent()) != null) {
            Handler[] handlers = parent.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                Formatter formatter;
                Handler handler = handlers[i];
                if (handler.getClass().equals(class$java$util$logging$ConsoleHandler == null ? Log4JFormatter.class$("java.util.logging.ConsoleHandler") : class$java$util$logging$ConsoleHandler) && (formatter = handler.getFormatter()).getClass().equals(class$java$util$logging$SimpleFormatter == null ? Log4JFormatter.class$("java.util.logging.SimpleFormatter") : class$java$util$logging$SimpleFormatter)) {
                    if (log4j == null) {
                        log4j = new Log4JFormatter(base);
                    }
                    try {
                        handler = new Stdout(handler, (Formatter)log4j);
                        handler.setLevel(filterLevel);
                    }
                    catch (UnsupportedEncodingException exception) {
                        Log4JFormatter.unexpectedException(exception);
                    }
                    catch (SecurityException exception) {
                        Log4JFormatter.unexpectedException(exception);
                    }
                }
                logger.addHandler(handler);
                logger.setLevel(filterLevel);
            }
        }
        logger.setUseParentHandlers(false);
    }

    private static void unexpectedException(Exception e) {
        Utilities.unexpectedException("org.geotools.resources", "GeotoolsHandler", "init", e);
    }

    private static int getHeaderWidth() {
        return Preferences.userNodeForPackage(Log4JFormatter.class).getInt("logging.header", 15);
    }

    static void setHeaderWidth(int margin) {
        Preferences.userNodeForPackage(Log4JFormatter.class).putInt("logging.header", margin);
    }

    private static final class Stdout
    extends StreamHandler {
        public Stdout(Handler handler, Formatter formatter) throws UnsupportedEncodingException {
            super(System.out, formatter);
            this.setErrorManager(handler.getErrorManager());
            this.setFilter(handler.getFilter());
            this.setLevel(handler.getLevel());
            this.setEncoding(handler.getEncoding());
        }

        public void publish(LogRecord record) {
            super.publish(record);
            this.flush();
        }

        public void close() {
            this.flush();
        }
    }
}

