/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.math;

import java.io.Serializable;
import javax.vecmath.MismatchedSizeException;
import javax.vecmath.Point3d;
import org.geotools.util.Cloneable;

public class Plane
implements Cloneable,
Serializable {
    public double c;
    public double cx;
    public double cy;

    public final double z(double x, double y) {
        return this.c + this.cx * x + this.cy * y;
    }

    public final double y(double x, double z) {
        return (z - (this.c + this.cx * x)) / this.cy;
    }

    public final double x(double y, double z) {
        return (z - (this.c + this.cy * y)) / this.cx;
    }

    public void setPlane(Point3d P1, Point3d P2, Point3d P3) throws ArithmeticException {
        double m00 = P2.x * P3.y - P3.x * P2.y;
        double m01 = P3.x * P1.y - P1.x * P3.y;
        double m02 = P1.x * P2.y - P2.x * P1.y;
        double det = m00 + m01 + m02;
        if (det == 0.0) {
            throw new ArithmeticException("Points are colinear");
        }
        this.c = (m00 * P1.z + m01 * P2.z + m02 * P3.z) / det;
        this.cx = ((P2.y - P3.y) * P1.z + (P3.y - P1.y) * P2.z + (P1.y - P2.y) * P3.z) / det;
        this.cy = ((P3.x - P2.x) * P1.z + (P1.x - P3.x) * P2.z + (P2.x - P1.x) * P3.z) / det;
    }

    public void setPlane(double[] x, double[] y, double[] z) throws MismatchedSizeException {
        int N = x.length;
        if (N != y.length || N != z.length) {
            throw new MismatchedSizeException();
        }
        double sum_x = 0.0;
        double sum_y = 0.0;
        double sum_z = 0.0;
        double sum_xx = 0.0;
        double sum_yy = 0.0;
        double sum_xy = 0.0;
        double sum_zx = 0.0;
        double sum_zy = 0.0;
        for (int i = 0; i < N; ++i) {
            double xi = x[i];
            double yi = y[i];
            double zi = z[i];
            sum_x += xi;
            sum_y += yi;
            sum_z += zi;
            sum_xx += xi * xi;
            sum_yy += yi * yi;
            sum_xy += xi * yi;
            sum_zx += zi * xi;
            sum_zy += zi * yi;
        }
        double ZX = sum_zx - sum_z * sum_x / (double)N;
        double ZY = sum_zy - sum_z * sum_y / (double)N;
        double XX = sum_xx - sum_x * sum_x / (double)N;
        double XY = sum_xy - sum_x * sum_y / (double)N;
        double YY = sum_yy - sum_y * sum_y / (double)N;
        double den = XY * XY - XX * YY;
        this.cy = (ZX * XY - ZY * XX) / den;
        this.cx = (ZY * XY - ZX * YY) / den;
        this.c = (sum_z - (this.cx * sum_x + this.cy * sum_y)) / (double)N;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("z(x,y)= ");
        if (this.c == 0.0 && this.cx == 0.0 && this.cy == 0.0) {
            buffer.append(0);
        } else {
            if (this.c != 0.0) {
                buffer.append(this.c);
                buffer.append(" + ");
            }
            if (this.cx != 0.0) {
                buffer.append(this.cx);
                buffer.append("*x");
                if (this.cy != 0.0) {
                    buffer.append(" + ");
                }
            }
            if (this.cy != 0.0) {
                buffer.append(this.cy);
                buffer.append("*y");
            }
        }
        return buffer.toString();
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass().equals(object.getClass())) {
            Plane that = (Plane)object;
            return Double.doubleToLongBits(this.c) == Double.doubleToLongBits(that.c) && Double.doubleToLongBits(this.cy) == Double.doubleToLongBits(that.cx) && Double.doubleToLongBits(this.cx) == Double.doubleToLongBits(that.cy);
        }
        return false;
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.c) + 37L * (Double.doubleToLongBits(this.cy) + 37L * Double.doubleToLongBits(this.cx));
        return (int)code ^ (int)(code >>> 32);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }
}

