/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.io;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NIOBufferUtils {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.io");

    private NIOBufferUtils() {
    }

    public static void clean(final Object buffer) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Method getCleanerMethod = buffer.getClass().getMethod("cleaner", null);
                    getCleanerMethod.setAccessible(true);
                    Object cleaner = getCleanerMethod.invoke(buffer, null);
                    Method clean = cleaner.getClass().getMethod("clean", null);
                    clean.invoke(cleaner, null);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error attempting to close a mapped byte buffer", e);
                }
                return null;
            }
        });
    }
}

