/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.IOException;
import java.util.logging.Logger;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.SQLEncoderPostgis;

public class SQLEncoderPostgisGeos
extends SQLEncoderPostgis
implements FilterVisitor {
    private static Logger log = Logger.getLogger("org.geotools.filter");
    private static WKTWriter wkt = new WKTWriter();
    private FilterCapabilities capabils = new FilterCapabilities();
    private int srid;
    private String defaultGeom;

    public SQLEncoderPostgisGeos() {
        this.capabils.addType((short)1);
        this.capabils.addType((short)2);
        this.capabils.addType((short)3);
        this.capabils.addType((short)14);
        this.capabils.addType((short)23);
        this.capabils.addType((short)15);
        this.capabils.addType((short)16);
        this.capabils.addType((short)17);
        this.capabils.addType((short)18);
        this.capabils.addType((short)21);
        this.capabils.addType((short)19);
        this.capabils.addType((short)12345);
        this.capabils.addType((short)-12345);
        this.capabils.addType((short)22);
        this.capabils.addType((short)4);
        this.capabils.addType((short)5);
        this.capabils.addType((short)6);
        this.capabils.addType((short)7);
        this.capabils.addType((short)9);
        this.capabils.addType((short)10);
        this.capabils.addType((short)11);
        this.capabils.addType((short)12);
        this.capabils.addType((short)8);
    }

    public SQLEncoderPostgisGeos(int srid) {
        this();
        this.srid = srid;
    }

    public FilterCapabilities getCapabilities() {
        return this.capabils;
    }

    public void setSRID(int srid) {
        this.srid = srid;
    }

    public void setDefaultGeometry(String name) {
        this.defaultGeom = name;
    }

    public void visit(GeometryFilter filter) throws RuntimeException {
        log.finer("exporting GeometryFilter");
        short filterType = filter.getFilterType();
        DefaultExpression left = (DefaultExpression)filter.getLeftGeometry();
        DefaultExpression right = (DefaultExpression)filter.getRightGeometry();
        int literalGeometryCount = 0;
        if (left != null && left.getType() == 104) {
            ++literalGeometryCount;
        }
        if (right != null && right.getType() == 104) {
            ++literalGeometryCount;
        }
        boolean constrainBBOX = literalGeometryCount == 1;
        try {
            this.out.write("(");
            String closingParenthesis = ")";
            if (filterType == 5) {
                this.out.write("equals");
            } else if (filterType == 6) {
                this.out.write("NOT (intersects");
                closingParenthesis = closingParenthesis + ")";
            } else if (filterType == 7) {
                this.out.write("intersects");
            } else if (filterType == 9) {
                this.out.write("crosses");
            } else if (filterType == 10) {
                this.out.write("within");
            } else if (filterType == 11) {
                this.out.write("contains");
            } else if (filterType == 12) {
                this.out.write("overlaps");
            } else if (filterType == 4) {
                this.out.write("intersects");
            } else if (filterType == 8) {
                this.out.write("touches");
            } else {
                throw new RuntimeException("does not support filter type " + filterType);
            }
            this.out.write("(");
            if (left == null) {
                this.out.write("\"" + this.defaultGeom + "\"");
            } else {
                left.accept((FilterVisitor)this);
            }
            this.out.write(", ");
            if (right == null) {
                this.out.write("\"" + this.defaultGeom + "\"");
            } else {
                right.accept((FilterVisitor)this);
            }
            this.out.write(")");
            if (constrainBBOX) {
                this.out.write(" AND ");
                if (left == null) {
                    this.out.write("\"" + this.defaultGeom + "\"");
                } else {
                    left.accept((FilterVisitor)this);
                }
                this.out.write(" && ");
                if (right == null) {
                    this.out.write("\"" + this.defaultGeom + "\"");
                } else {
                    right.accept((FilterVisitor)this);
                }
            }
            this.out.write(closingParenthesis);
        }
        catch (IOException ioe) {
            log.warning("Unable to export filter" + ioe);
            throw new RuntimeException("io error while writing", ioe);
        }
    }

    public void visit(LiteralExpression expression) throws RuntimeException {
        log.finer("exporting LiteralExpression");
        try {
            if (expression.getType() == 104) {
                Geometry bbox = (Geometry)expression.getLiteral();
                String geomText = wkt.write(bbox);
                this.out.write("GeometryFromText('" + geomText + "', " + this.srid + ")");
            } else {
                super.visit(expression);
            }
        }
        catch (IOException ioe) {
            log.warning("Unable to export expresion" + ioe);
            throw new RuntimeException("io error while writing", ioe);
        }
    }
}

