/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.SQLEncoder;

public class SQLEncoderPostgis
extends SQLEncoder
implements FilterVisitor {
    private static Logger LOGGER = Logger.getLogger("org.geotools.filter");
    private static WKTWriter wkt = new WKTWriter();
    private FilterCapabilities capabilities = new FilterCapabilities();
    private int srid;
    private String defaultGeom;
    private boolean useGeos;
    private String fidColumn;

    public SQLEncoderPostgis() {
        this.capabilities.addType((short)1);
        this.capabilities.addType((short)2);
        this.capabilities.addType((short)3);
        this.capabilities.addType((short)14);
        this.capabilities.addType((short)23);
        this.capabilities.addType((short)15);
        this.capabilities.addType((short)16);
        this.capabilities.addType((short)17);
        this.capabilities.addType((short)18);
        this.capabilities.addType((short)21);
        this.capabilities.addType((short)19);
        this.capabilities.addType((short)12345);
        this.capabilities.addType((short)-12345);
        this.capabilities.addType((short)4);
        this.capabilities.addType((short)22);
    }

    public SQLEncoderPostgis(boolean looseBbox) {
        this();
        if (!looseBbox) {
            this.useGeos = true;
        }
    }

    public SQLEncoderPostgis(int srid) {
        this(true);
        this.srid = srid;
    }

    public FilterCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void setSRID(int srid) {
        this.srid = srid;
    }

    public void setFidColumn(String fidColumnName) {
        this.fidColumn = fidColumnName;
    }

    public void setDefaultGeometry(String name) {
        this.defaultGeom = name;
    }

    public void visit(Filter filter) {
        try {
            if (filter.getFilterType() == 12345) {
                this.out.write("TRUE");
            } else if (filter.getFilterType() == -12345) {
                this.out.write("FALSE");
            } else {
                LOGGER.warning("exporting unknown filter type:" + filter.toString());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("io error while writing", ioe);
        }
    }

    public void visit(FidFilter filter) {
        String[] fids = filter.getFids();
        LOGGER.finer("Exporting FID=" + Arrays.asList(fids));
        for (int i = 0; i < fids.length; ++i) {
            try {
                this.out.write(this.fidColumn);
                this.out.write(" = '");
                int pos = fids[i].indexOf(46);
                if (pos != -1) {
                    this.out.write(fids[i].substring(pos + 1));
                } else {
                    this.out.write("-1");
                }
                this.out.write("'");
                if (i >= fids.length - 1) continue;
                this.out.write(" OR ");
                continue;
            }
            catch (IOException e) {
                LOGGER.warning("IO Error exporting FID Filter.");
            }
        }
    }

    public void visit(GeometryFilter filter) throws RuntimeException {
        LOGGER.finer("exporting GeometryFilter");
        if (filter.getFilterType() == 4) {
            DefaultExpression left = (DefaultExpression)filter.getLeftGeometry();
            DefaultExpression right = (DefaultExpression)filter.getRightGeometry();
            try {
                if (this.useGeos) {
                    this.out.write("NOT disjoint(");
                }
                if (left == null) {
                    this.out.write("\"" + this.defaultGeom + "\"");
                } else {
                    left.accept((FilterVisitor)this);
                }
                if (this.useGeos) {
                    this.out.write(", ");
                } else {
                    this.out.write(" && ");
                }
                if (right == null) {
                    this.out.write("\"" + this.defaultGeom + "\"");
                } else {
                    right.accept((FilterVisitor)this);
                }
                if (this.useGeos) {
                    this.out.write(")");
                }
            }
            catch (IOException ioe) {
                LOGGER.warning("Unable to export filter" + ioe);
            }
        } else {
            LOGGER.warning("exporting unknown filter type, only bbox supported");
            throw new RuntimeException("Only BBox is currently supported");
        }
    }

    public void visit(LiteralExpression expression) throws RuntimeException {
        LOGGER.finer("exporting LiteralExpression");
        try {
            if (expression.getType() == 104) {
                Geometry bbox = (Geometry)expression.getLiteral();
                String geomText = wkt.write(bbox);
                this.out.write("GeometryFromText('" + geomText + "', " + this.srid + ")");
            } else {
                super.visit(expression);
            }
        }
        catch (IOException ioe) {
            LOGGER.warning("Unable to export expresion" + ioe);
            throw new RuntimeException("io error while writing", ioe);
        }
    }
}

