/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import org.geotools.data.jdbc.DefaultSQLBuilder;
import org.geotools.feature.AttributeType;
import org.geotools.filter.Filter;
import org.geotools.filter.SQLEncoder;
import org.geotools.filter.SQLEncoderException;
import org.geotools.filter.SQLEncoderPostgis;

public class PostgisSQLBuilder
extends DefaultSQLBuilder {
    public PostgisSQLBuilder(int srid) {
        this(new SQLEncoderPostgis(srid));
    }

    public PostgisSQLBuilder(SQLEncoder encoder) {
        super(encoder);
    }

    public String buildSQLQuery(String typeName, String fidColumnName, AttributeType[] attrTypes, Filter filter) throws SQLEncoderException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT ");
        this.sqlColumns(sqlBuffer, fidColumnName, attrTypes);
        this.sqlFrom(sqlBuffer, typeName);
        this.sqlWhere(sqlBuffer, filter);
        String sqlStmt = sqlBuffer.toString();
        return sqlStmt;
    }

    public void sqlColumns(StringBuffer sql, String fidColumnName, AttributeType[] attributes) {
        if (fidColumnName != null) {
            sql.append(fidColumnName);
        }
        for (int i = 0; i < attributes.length; ++i) {
            String colName = attributes[i].getName();
            sql.append(", ");
            if (attributes[i].isGeometry()) {
                sql.append("AsText(force_2d(\"" + colName + "\"))");
                continue;
            }
            sql.append("\"" + colName + "\"");
        }
    }

    public void sqlFrom(StringBuffer sql, String typeName) {
        sql.append(" FROM ");
        sql.append("\"" + typeName + "\"");
    }

    public void sqlWhere(StringBuffer sql, Filter preFilter) throws SQLEncoderException {
        if (preFilter != null || preFilter == Filter.NONE) {
            String where = this.encoder.encode(preFilter);
            sql.append(" ");
            sql.append(where);
        }
    }
}

