/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.sql.SQLException;
import java.util.Map;
import org.geotools.data.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.postgis.PostgisConnectionFactory;
import org.geotools.data.postgis.PostgisDataSourceFactory;
import org.geotools.data.postgis.PostgisLockingDataSource;

public class PostgisLockingDataSourceFactory
extends PostgisDataSourceFactory {
    public boolean canProcess(Map params) {
        if (!params.containsKey("dbtype")) {
            return false;
        }
        if (!((String)params.get("dbtype")).equalsIgnoreCase("postgislock")) {
            return false;
        }
        if (!params.containsKey("host")) {
            return false;
        }
        if (!params.containsKey("user")) {
            return false;
        }
        if (!params.containsKey("passwd")) {
            return false;
        }
        if (!params.containsKey("database")) {
            return false;
        }
        return params.containsKey("table");
    }

    public DataSource createDataSource(Map params) throws DataSourceException {
        if (!this.canProcess(params)) {
            return null;
        }
        String host = (String)params.get("host");
        String user = (String)params.get("user");
        String passwd = (String)params.get("passwd");
        String port = (String)params.get("port");
        String database = (String)params.get("database");
        String table = (String)params.get("table");
        String charSet = (String)params.get("charset");
        String locking = (String)params.get("locking");
        PostgisConnectionFactory connFact = new PostgisConnectionFactory(host, port, database);
        try {
            connFact.setLogin(user, passwd);
            connFact.setCharSet(charSet);
            PostgisLockingDataSource ds = new PostgisLockingDataSource(connFact.getConnectionPool(), table);
            return ds;
        }
        catch (SQLException sqle) {
            throw new DataSourceException("Unable to connect to database", (Throwable)sqle);
        }
    }

    public String getDescription() {
        return "PostGIS spatial database that supports locking operations";
    }
}

