/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureLock;
import org.geotools.data.LockingDataSource;
import org.geotools.data.Query;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.postgis.PostgisDataSource;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.Filter;
import org.geotools.filter.SQLEncoderException;
import org.geotools.filter.SQLUnpacker;

public class PostgisLockingDataSource
extends PostgisDataSource
implements LockingDataSource {
    private static final Logger LOGGER;
    private FeatureLock featureLock = FeatureLock.TRANSACTION;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PostgisLockingDataSource(ConnectionPool pool, String tableName) throws DataSourceException {
        super(pool, tableName);
    }

    public int lockFeatures(Filter filter) throws DataSourceException {
        return this.lockFeatures(this.makeDefaultQuery(filter));
    }

    public int lockFeatures() throws DataSourceException {
        return this.lockFeatures(Query.ALL);
    }

    public void setFeatureLock(FeatureLock lock) {
        if (lock == null) {
            throw new UnsupportedOperationException("A Feature Lock is required Did you mean to use FeatureLock.TRANSACTION rather than null?");
        }
        if (lock != FeatureLock.TRANSACTION) {
            throw new UnsupportedOperationException("Long term locks not yet supported");
        }
        this.featureLock = lock;
    }

    public int lockFeatures(Query query) throws DataSourceException {
        if (this.featureLock == FeatureLock.TRANSACTION) {
            return this.rowLockFeatures(query);
        }
        return this.longtermLockFeatures(query, this.featureLock);
    }

    protected int rowLockFeatures(Query query) throws DataSourceException {
        if (this.getAutoCommit()) {
            return 0;
        }
        if (this.isAllSQL(query)) {
            return this.rowLockFeatures(query);
        }
        try {
            Set fids = this.getFidSet(this.getTransactionConnection(), query);
            return this.rowLockFeatures(fids);
        }
        catch (SQLException e) {
            throw new DataSourceException("Could not lock rows", (Throwable)e);
        }
    }

    protected int rowLockFeaturesSQL(Query query) throws DataSourceException {
        SQLUnpacker unpacker = new SQLUnpacker(this.encoder.getCapabilities());
        unpacker.unPackAND(query.getFilter());
        if (!$assertionsDisabled && unpacker.getUnSupported() != null) {
            throw new AssertionError();
        }
        Filter sqlFilter = unpacker.getSupported();
        if (!$assertionsDisabled && sqlFilter == null) {
            throw new AssertionError();
        }
        LOGGER.fine("Filter in making sql is " + sqlFilter);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append(this.tableName);
        sql.append(" ");
        if (sqlFilter != null) {
            try {
                sql.append(this.encoder.encode(sqlFilter));
            }
            catch (SQLEncoderException sqle) {}
        } else {
            throw new DataSourceException("Could not represent query as SQL for postgis (" + query.toString() + ")");
        }
        sql.append(" FOR UPDATE");
        try {
            Connection conn = this.getTransactionConnection();
            Statement statement = conn.createStatement();
            return statement.executeUpdate(sql.toString());
        }
        catch (SQLException erp) {
            throw new DataSourceException("Problem locking query", (Throwable)erp);
        }
    }

    protected int rowLockFeatures(Set fids) throws DataSourceException {
        try {
            StringBuffer sql = new StringBuffer();
            Connection conn = this.getTransactionConnection();
            sql.append("SELECT ");
            sql.append(this.tableName);
            sql.append(" WHERE ");
            String fidColumn = PostgisLockingDataSource.getFidColumn(conn, this.tableName);
            Iterator i = fids.iterator();
            while (i.hasNext()) {
                String fid = (String)i.next();
                sql.append(fidColumn);
                sql.append("=");
                sql.append(this.deFid(fid));
                if (!i.hasNext()) continue;
                sql.append(" OR ");
            }
            sql.append(" FOR UPDATE");
            Statement statement = conn.createStatement();
            return statement.executeUpdate(sql.toString());
        }
        catch (SQLException e) {
            throw new DataSourceException("Unable to lock features", (Throwable)e);
        }
    }

    protected boolean isAllSQL(Query query) {
        SQLUnpacker unpacker = new SQLUnpacker(this.encoder.getCapabilities());
        unpacker.unPackAND(query.getFilter());
        return unpacker.getUnSupported() == null;
    }

    protected Set getFidSet(Connection conn, Query query) throws DataSourceException {
        HashSet<String> fids = new HashSet<String>();
        FeatureIterator f = this.getFeatures(query).features();
        while (f.hasNext()) {
            fids.add(f.next().getID());
        }
        return fids;
    }

    protected int longtermLockFeatures(Query query, FeatureLock lock) {
        return 0;
    }

    protected String deFid(String featureId) {
        if (featureId.startsWith(this.tableName + ".")) {
            return featureId.substring(this.tableName.length());
        }
        return featureId;
    }

    public void setAuthorization(Set authIds) throws DataSourceException {
        if (this.getAutoCommit()) {
            throw new DataSourceException("Cannot accept authorization in auto commit mode");
        }
        String authId = null;
        try {
            Connection conn = this.getTransactionConnection();
            String sql = "haveAuthorization( ? )";
            PreparedStatement statement = conn.prepareStatement(sql);
            Iterator i = authIds.iterator();
            while (i.hasNext()) {
                authId = (String)i.next();
                statement.setString(0, authId);
                statement.execute();
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("Unable to use authorization " + authId, (Throwable)e);
        }
    }

    public void setAuthorization(String authID) throws DataSourceException {
        this.setAuthorization(Collections.singleton(authID));
    }

    public void releaseLock(String authID) throws DataSourceException {
        throw new UnsupportedOperationException("Relesae Lock not supported");
    }

    public void refreshLock(String authID) throws DataSourceException {
        throw new UnsupportedOperationException("Refresh Lock not supported");
    }

    public void unLockFeatures() throws DataSourceException {
        this.unLockFeatures(Query.ALL);
    }

    public void unLockFeatures(Filter filter) throws DataSourceException {
        this.unLockFeatures(this.makeDefaultQuery(filter));
    }

    public void unLockFeatures(Query query) throws DataSourceException {
        throw new UnsupportedOperationException("Unlock Features not supported");
    }

    static {
        $assertionsDisabled = !PostgisLockingDataSource.class.desiredAssertionStatus();
        LOGGER = Logger.getLogger("org.geotools.postgislock");
    }
}

