/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureResults;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.JDBCDataStore;
import org.geotools.data.jdbc.JDBCFeatureStore;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.postgis.PostgisDataStore;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.AbstractFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.SQLEncoderException;
import org.geotools.filter.SQLEncoderPostgis;
import org.geotools.filter.SQLUnpacker;

public class PostgisFeatureStore
extends JDBCFeatureStore {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.postgis");
    private static WKTWriter geometryWriter = new WKTWriter();
    private static GeometryFactory geometryFactory = new GeometryFactory();
    private static WKTReader geometryReader = new WKTReader(geometryFactory);
    protected static final String CONN_ERROR = "Some sort of database connection error: ";
    protected SQLBuilder sqlBuilder;
    protected SQLEncoderPostgis encoder;
    protected String tableName;
    protected String fidColumn;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Geometry;

    public PostgisFeatureStore(PostgisDataStore postgisDataStore, FeatureType featureType) throws IOException {
        super((JDBCDataStore)postgisDataStore, featureType);
        this.tableName = featureType.getTypeName();
        this.fidColumn = postgisDataStore.getFidColumn(this.tableName);
        this.sqlBuilder = postgisDataStore.getSqlBuilder(this.tableName);
        GeometryAttributeType geomType = featureType.getDefaultGeometry();
        this.encoder = new SQLEncoderPostgis();
        if (geomType != null) {
            int srid = this.getSRID(geomType.getName());
            this.encoder.setDefaultGeometry(geomType.getName());
            this.encoder.setSRID(srid);
            this.encoder.setFidColumn(this.fidColumn);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set addFeatures(FeatureReader reader) throws IOException {
        boolean fail = false;
        Set curFids = null;
        Set newFids = null;
        Connection conn = null;
        Statement statement = null;
        if (!reader.hasNext()) return newFids;
        try {
            try {
                conn = this.getConnection();
                curFids = this.getFidSet(conn);
                LOGGER.fine("fids before add: " + curFids);
                statement = conn.createStatement();
                while (reader.hasNext()) {
                    String sql = this.makeInsertSql(this.tableName, reader.next());
                    LOGGER.finer("this sql statement = " + sql);
                    statement.executeUpdate(sql);
                }
                newFids = this.getFidSet(conn);
                LOGGER.fine("fids after add: " + newFids);
                newFids.removeAll(curFids);
                LOGGER.fine("to return " + newFids);
            }
            catch (SQLException sqle) {
                fail = true;
                this.close(conn, this.getTransaction(), sqle);
                String message = CONN_ERROR + sqle.getMessage();
                LOGGER.warning(message);
                throw new DataSourceException(message, (Throwable)sqle);
            }
            catch (IllegalAttributeException iae) {
                throw new DataSourceException("attribute problem", (Throwable)iae);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            reader.close();
            this.close(statement);
            this.close(conn, this.getTransaction(), null);
            throw throwable;
        }
        reader.close();
        this.close(statement);
        this.close(conn, this.getTransaction(), null);
        return newFids;
    }

    private Set getFidSet(Connection conn) throws IOException {
        HashSet<String> fids = new HashSet<String>();
        Statement statement = null;
        try {
            LOGGER.finer("entering fid set");
            statement = conn.createStatement();
            DefaultQuery query = new DefaultQuery();
            query.setPropertyNames(new String[0]);
            SQLUnpacker unpacker = new SQLUnpacker(this.encoder.getCapabilities());
            unpacker.unPackAND(null);
            String sql = this.makeSql(unpacker, (Query)query);
            ResultSet result = statement.executeQuery(sql);
            while (result.next()) {
                fids.add(this.createFid(result.getString(1)));
            }
        }
        catch (SQLException sqle) {
            try {
                String message = CONN_ERROR + sqle.getMessage();
                LOGGER.warning(message);
                this.close(conn, this.getTransaction(), sqle);
                throw new DataSourceException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                this.close(statement);
                this.close(conn, this.getTransaction(), null);
                throw throwable;
            }
        }
        this.close(statement);
        this.close(conn, this.getTransaction(), null);
        LOGGER.finest("returning fids " + fids);
        return fids;
    }

    private String makeInsertSql(String tableName, Feature feature) throws IOException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO \"");
        sql.append(tableName);
        sql.append("\"(");
        FeatureType featureSchema = feature.getFeatureType();
        AttributeType[] types = featureSchema.getAttributeTypes();
        for (int i = 0; i < types.length; ++i) {
            sql.append("\"");
            sql.append(types[i].getName());
            sql.append("\"");
            sql.append(i < types.length - 1 ? ", " : ") ");
        }
        sql.append("VALUES (");
        Object[] attributes = feature.getAttributes(null);
        for (int j = 0; j < attributes.length; ++j) {
            if (types[j].isGeometry()) {
                int srid = this.getSRID(types[j].getName());
                String geoText = geometryWriter.write((Geometry)attributes[j]);
                sql.append("GeometryFromText('");
                sql.append(geoText);
                sql.append("', ");
                sql.append(srid);
                sql.append(")");
            } else {
                String attrValue = this.addQuotes(attributes[j]);
                sql.append(attrValue);
            }
            if (j >= attributes.length - 1) continue;
            sql.append(", ");
        }
        sql.append(");");
        return sql.toString();
    }

    protected int getSRID(String geomName) throws IOException {
        return this.getPostgisDataStore().getSRID(this.tableName, geomName);
    }

    private String addQuotes(Object value) {
        String retString = value != null ? "'" + value.toString() + "'" : "null";
        return retString;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeFeatures(Filter filter) throws IOException {
        String sql = "";
        String fid = null;
        String whereStmt = null;
        this.assertFilter(filter);
        boolean fail = false;
        SQLUnpacker unpacker = new SQLUnpacker(this.encoder.getCapabilities());
        unpacker.unPackOR(filter);
        Filter encodableFilter = unpacker.getSupported();
        Filter unEncodableFilter = unpacker.getUnSupported();
        Statement statement = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            statement = conn.createStatement();
            if (encodableFilter != null) {
                whereStmt = this.encoder.encode((Filter)((AbstractFilter)encodableFilter));
                sql = "DELETE from \"" + this.tableName + "\" " + whereStmt + ";";
                LOGGER.fine("sql statment is " + sql);
                statement.executeUpdate(sql);
            }
            if (unEncodableFilter != null) {
                DefaultQuery query = new DefaultQuery();
                query.setPropertyNames(new String[0]);
                query.setFilter(unEncodableFilter);
                FeatureResults features = this.getFeatures(unEncodableFilter);
                FeatureReader iter = features.reader();
                if (iter.hasNext()) {
                    sql = "DELETE FROM \"" + this.tableName + "\" WHERE ";
                    int i = 0;
                    while (iter.hasNext()) {
                        fid = this.formatFid(iter.next());
                        sql = sql + this.fidColumn + " = " + fid;
                        sql = iter.hasNext() ? sql + " OR " : sql + ";";
                        ++i;
                    }
                    LOGGER.fine("our delete says : " + sql);
                    statement.executeUpdate(sql);
                }
            }
            this.close(statement);
        }
        catch (SQLException sqle) {
            try {
                fail = true;
                this.close(conn, this.getTransaction(), sqle);
                String message = CONN_ERROR + sqle.getMessage();
                LOGGER.warning(message);
                throw new DataSourceException(message, (Throwable)sqle);
                catch (SQLEncoderException ence) {
                    fail = true;
                    message = "error encoding sql from filter " + ence.getMessage();
                    LOGGER.warning(message);
                    throw new DataSourceException(message, (Throwable)ence);
                }
                catch (IllegalAttributeException iae) {
                    throw new DataSourceException("attribute problem", (Throwable)iae);
                }
            }
            catch (Throwable throwable) {
                this.close(statement);
                this.close(conn, this.getTransaction(), null);
                throw throwable;
            }
        }
        this.close(statement);
        this.close(conn, this.getTransaction(), null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifyFeatures(AttributeType[] type, Object[] value, Filter filter) throws IOException {
        LOGGER.info("asserting filter " + filter);
        this.assertFilter(filter);
        boolean fail = false;
        Connection conn = null;
        Statement statement = null;
        String sql = "";
        String fid = null;
        SQLUnpacker unpacker = new SQLUnpacker(this.encoder.getCapabilities());
        unpacker.unPackOR(filter);
        String whereStmt = null;
        Filter encodableFilter = unpacker.getSupported();
        Filter unEncodableFilter = unpacker.getUnSupported();
        try {
            FeatureResults features;
            FeatureReader iter;
            conn = this.getConnection();
            statement = conn.createStatement();
            if (encodableFilter != null) {
                whereStmt = this.encoder.encode((Filter)((AbstractFilter)encodableFilter));
                sql = this.makeModifySql(type, value, whereStmt);
                LOGGER.finer("encoded modify is " + sql);
                statement.executeUpdate(sql);
            }
            if (unEncodableFilter != null && (iter = (features = this.getFeatures(unEncodableFilter)).reader()).hasNext()) {
                whereStmt = " WHERE ";
                while (iter.hasNext()) {
                    fid = this.formatFid(iter.next());
                    whereStmt = whereStmt + this.fidColumn + " = " + fid;
                    if (!iter.hasNext()) continue;
                    whereStmt = whereStmt + " OR ";
                }
                sql = this.makeModifySql(type, value, whereStmt);
                LOGGER.fine("unencoded modify is " + sql);
                statement.executeUpdate(sql);
            }
        }
        catch (SQLException sqle) {
            try {
                fail = true;
                this.close(conn, this.getTransaction(), sqle);
                String message = CONN_ERROR + sqle.getMessage();
                LOGGER.warning(message);
                throw new DataSourceException(message, (Throwable)sqle);
                catch (SQLEncoderException ence) {
                    fail = true;
                    message = "error encoding sql from filter " + ence.getMessage();
                    LOGGER.warning(message);
                    throw new DataSourceException(message, (Throwable)ence);
                }
                catch (IllegalAttributeException iae) {
                    throw new DataSourceException("attribute problem", (Throwable)iae);
                }
            }
            catch (Throwable throwable) {
                this.close(statement);
                this.close(conn, this.getTransaction(), null);
                throw throwable;
            }
        }
        this.close(statement);
        this.close(conn, this.getTransaction(), null);
    }

    private String formatFid(Feature feature) {
        String fid = feature.getID();
        if (fid.startsWith(this.tableName)) {
            fid = fid.substring(this.tableName.length() + 1);
        }
        return this.addQuotes(fid);
    }

    public void modifyFeatures(AttributeType type, Object value, Filter filter) throws IOException {
        AttributeType[] singleType = new AttributeType[]{type};
        Object[] singleVal = new Object[]{value};
        this.modifyFeatures(singleType, singleVal, filter);
    }

    private String makeModifySql(AttributeType[] types, Object[] values, String whereStmt) throws IOException {
        int arrLength = types.length;
        if (arrLength == values.length) {
            StringBuffer sqlStatement = new StringBuffer("UPDATE ");
            sqlStatement.append("\"" + this.tableName + "\" SET ");
            for (int i = 0; i < arrLength; ++i) {
                String newValue;
                AttributeType curType = types[i];
                Object curValue = values[i];
                if (curType.isGeometry()) {
                    int srid = this.getSRID(curType.getName());
                    String geoText = geometryWriter.write((Geometry)curValue);
                    newValue = "GeometryFromText('" + geoText + "', " + srid + ")";
                } else {
                    newValue = this.addQuotes(curValue);
                }
                sqlStatement.append("\"" + curType.getName() + "\" = " + newValue);
                sqlStatement.append(i < arrLength - 1 ? ", " : " ");
            }
            sqlStatement.append(whereStmt + ";");
            return sqlStatement.toString();
        }
        throw new IOException("length of value array is not same length as type array");
    }

    protected PostgisDataStore getPostgisDataStore() {
        return (PostgisDataStore)super.getJDBCDataStore();
    }

    public String makeSql(SQLUnpacker unpacker, Query query) throws IOException {
        this.tableName = this.tableName;
        boolean useLimit = unpacker.getUnSupported() == null;
        Filter filter = unpacker.getSupported();
        LOGGER.fine("Filter in making sql is " + filter);
        StringBuffer sqlStatement = new StringBuffer("SELECT ");
        sqlStatement.append(this.fidColumn);
        AttributeType[] attributeTypes = this.getAttTypes(query);
        int numAttributes = attributeTypes.length;
        LOGGER.finer("making sql for " + numAttributes + " attributes");
        for (int i = 0; i < numAttributes; ++i) {
            String curAttName = attributeTypes[i].getName();
            if ((class$com$vividsolutions$jts$geom$Geometry == null ? PostgisFeatureStore.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(attributeTypes[i].getType())) {
                sqlStatement.append(", AsText(force_2d(\"" + curAttName + "\"))");
                continue;
            }
            if (this.fidColumn.equals(curAttName)) continue;
            sqlStatement.append(", \"" + curAttName + "\"");
        }
        String where = "";
        if (filter != null) {
            try {
                where = this.encoder.encode(filter);
            }
            catch (SQLEncoderException sqle) {
                String message = "Encoder error" + sqle.getMessage();
                LOGGER.warning(message);
                throw new DataSourceException(message, (Throwable)sqle);
            }
        }
        String limit = "";
        if (useLimit) {
            limit = " LIMIT " + query.getMaxFeatures();
        }
        sqlStatement.append(" FROM \"" + this.tableName + "\" " + where + limit + ";").toString();
        LOGGER.fine("sql statement is " + sqlStatement);
        return sqlStatement.toString();
    }

    protected String createFid(String featureId) {
        String newFid = Character.isDigit(featureId.charAt(0)) ? this.tableName + "." + featureId : featureId;
        return newFid;
    }

    private AttributeType[] getAttTypes(Query query) throws IOException {
        AttributeType[] schemaTypes = this.getSchema().getAttributeTypes();
        if (query.retrieveAllProperties()) {
            return schemaTypes;
        }
        List<String> attNames = Arrays.asList(query.getPropertyNames());
        AttributeType[] retAttTypes = new AttributeType[attNames.size()];
        int retPos = 0;
        int n = schemaTypes.length;
        for (int i = 0; i < n; ++i) {
            String schemaTypeName = schemaTypes[i].getName();
            if (!attNames.contains(schemaTypeName)) continue;
            retAttTypes[retPos++] = schemaTypes[i];
        }
        if (attNames.size() != retPos) {
            String msg = "attempted to request a property, " + attNames.get(0) + " that is not part of the schema ";
            throw new IOException(msg);
        }
        return retAttTypes;
    }

    public Envelope getBounds() throws IOException {
        return this.getBounds(Query.ALL);
    }

    public Envelope getBounds(Query query) throws IOException {
        return this.bounds(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Envelope bounds(Query query) throws IOException {
        Filter preFilter;
        Filter filter = query.getFilter();
        if (filter == Filter.ALL) {
            return new Envelope();
        }
        FeatureType schema = this.getSchema();
        JDBCDataStore jdbc = this.getJDBCDataStore();
        SQLBuilder sqlBuilder = jdbc.getSqlBuilder(schema.getTypeName());
        if (sqlBuilder.getPostQueryFilter(query.getFilter()) != null) {
            return null;
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            Envelope retEnv = new Envelope();
            preFilter = sqlBuilder.getPreQueryFilter(query.getFilter());
            AttributeType[] attributeTypes = schema.getAttributeTypes();
            int n = schema.getAttributeCount();
            for (int j = 0; j < n; ++j) {
                if (!attributeTypes[j].isGeometry()) continue;
                String attName = attributeTypes[j].getName();
                Envelope curEnv = this.getEnvelope(conn, attName, sqlBuilder, filter);
                if (curEnv == null) {
                    Envelope envelope = null;
                    return envelope;
                }
                retEnv.expandToInclude(curEnv);
            }
            LOGGER.finer("returning bounds " + retEnv);
            Envelope envelope = retEnv;
            return envelope;
        }
        catch (SQLException sqlException) {
            JDBCUtils.close((Connection)conn, (Transaction)this.transaction, (SQLException)sqlException);
            conn = null;
            throw new DataSourceException("Could not count " + query.getHandle(), (Throwable)sqlException);
        }
        catch (SQLEncoderException e) {
            preFilter = null;
            return preFilter;
        }
        catch (ParseException parseE) {
            String message = "Could not read geometry: " + parseE.getMessage();
            Envelope envelope = null;
            return envelope;
        }
        finally {
            JDBCUtils.close((Connection)conn, (Transaction)this.transaction, null);
        }
    }

    protected Envelope getEnvelope(Connection conn, String geomName, SQLBuilder sqlBuilder, Filter filter) throws SQLException, SQLEncoderException, IOException, ParseException {
        String typeName = this.getSchema().getTypeName();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT AsText(force_2d(Envelope(Extent(\"" + geomName + "\")))) ");
        sqlBuilder.sqlFrom(sql, typeName);
        sqlBuilder.sqlWhere(sql, filter);
        LOGGER.fine("SQL: " + sql);
        Statement statement = conn.createStatement();
        ResultSet results = statement.executeQuery(sql.toString());
        results.next();
        String wkt = results.getString(1);
        Envelope retEnv = null;
        if (wkt == null) {
            return null;
        }
        retEnv = geometryReader.read(wkt).getEnvelopeInternal();
        results.close();
        statement.close();
        return retEnv;
    }
}

