/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Map;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.postgis.PostgisConnectionFactory;
import org.geotools.data.postgis.PostgisDataStore;

public class PostgisDataStoreFactory
implements DataStoreFactorySpi {
    private static final String DRIVER_CLASS = "org.postgresql.Driver";
    static final DataStoreFactorySpi.Param DBTYPE = new DataStoreFactorySpi.Param("dbtype", String.class, "must be 'postgis'", true, (Object)"postgis");
    static final DataStoreFactorySpi.Param HOST = new DataStoreFactorySpi.Param("host", String.class, "postgis host machine", true, (Object)"localhost");
    static final DataStoreFactorySpi.Param PORT = new DataStoreFactorySpi.Param("port", Integer.class, "postgis connection port", true, (Object)new Integer(5432));
    static final DataStoreFactorySpi.Param DATABASE = new DataStoreFactorySpi.Param("database", String.class, "postgis database");
    static final DataStoreFactorySpi.Param USER = new DataStoreFactorySpi.Param("user", String.class, "user name to login as");
    static final DataStoreFactorySpi.Param PASSWD = new DataStoreFactorySpi.Param("passwd", String.class, "password used to login", false);
    static final DataStoreFactorySpi.Param CHARSET = new DataStoreFactorySpi.Param("charset", Charset.class, "character set", false, "ISO-8859-1"){

        public Object parse(String text) throws IOException {
            return Charset.forName(text);
        }

        public String text(Object value) {
            return ((Charset)value).name();
        }
    };
    static final DataStoreFactorySpi.Param NAMESPACE = new DataStoreFactorySpi.Param("namespace", String.class, "namespace prefix used", false);

    public boolean canProcess(Map params) {
        if (!params.containsKey("dbtype")) {
            return false;
        }
        if (!((String)params.get("dbtype")).equalsIgnoreCase("postgis")) {
            return false;
        }
        if (!params.containsKey("host")) {
            return false;
        }
        if (!params.containsKey("user")) {
            return false;
        }
        return params.containsKey("database");
    }

    public DataStore createDataStore(Map params) throws IOException {
        ConnectionPool pool;
        String host = (String)HOST.lookUp(params);
        String user = (String)USER.lookUp(params);
        String passwd = (String)PASSWD.lookUp(params);
        Integer port = (Integer)PORT.lookUp(params);
        String database = (String)DATABASE.lookUp(params);
        Charset charSet = (Charset)CHARSET.lookUp(params);
        String namespace = (String)NAMESPACE.lookUp(params);
        if (!this.canProcess(params)) {
            return null;
        }
        PostgisConnectionFactory connFact = new PostgisConnectionFactory(host, port.toString(), database);
        connFact.setLogin(user, passwd);
        if (charSet != null) {
            connFact.setCharSet(charSet.name());
        }
        try {
            pool = connFact.getConnectionPool();
        }
        catch (SQLException e) {
            throw new DataSourceException("Could not create connection", (Throwable)e);
        }
        if (namespace != null) {
            return new PostgisDataStore(pool, namespace);
        }
        return new PostgisDataStore(pool);
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException("Postgis cannot create a new Database");
    }

    public String getDescription() {
        return "PostGIS spatial database";
    }

    public DataStoreFactorySpi.Param[] getParametersInfo() {
        return new DataStoreFactorySpi.Param[]{DBTYPE, HOST, PORT, DATABASE, USER, PASSWD, CHARSET, NAMESPACE};
    }
}

