/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.AttributeReader;
import org.geotools.data.AttributeWriter;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.jdbc.JDBCDataStore;
import org.geotools.data.jdbc.JDBCFeatureLocking;
import org.geotools.data.jdbc.JDBCFeatureStore;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.QueryDataObserver;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.jdbc.WKTAttributeIO;
import org.geotools.data.postgis.PostgisFeatureLocking;
import org.geotools.data.postgis.PostgisSQLBuilder;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.filter.SQLEncoder;
import org.geotools.filter.SQLEncoderPostgis;
import org.geotools.filter.SQLEncoderPostgisGeos;

public class PostgisDataStore
extends JDBCDataStore
implements DataStore {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.postgis");
    private static final int TABLE_NAME_COL = 3;
    public static final String DEFAULT_FID_COLUMN = "oid";
    protected static final String CONN_ERROR = "Some sort of database connection error: ";
    private static Map GEOM_TYPE_MAP = new HashMap();
    private static WKTWriter geometryWriter = new WKTWriter();
    public static final int OPTIMIZE_SAFE = 0;
    public static final int OPTIMIZE_SQL = 1;
    public final int OPTIMIZE_MODE;
    protected SQLEncoder encoder = new SQLEncoderPostgis();
    protected boolean useGeos = this.getUseGeos();

    public PostgisDataStore(ConnectionPool connPool) throws IOException {
        this(connPool, null);
    }

    public PostgisDataStore(ConnectionPool connPool, String namespace) throws IOException {
        this(connPool, null, namespace);
    }

    public PostgisDataStore(ConnectionPool connPool, String schema, String namespace) throws IOException {
        this(connPool, schema, namespace, 1);
    }

    public PostgisDataStore(ConnectionPool connPool, String schema, String namespace, int optimizeMode) throws IOException {
        super(connPool, schema, new HashMap(), namespace);
        this.OPTIMIZE_MODE = optimizeMode;
    }

    protected AttributeType buildAttributeType(ResultSet rs) throws SQLException, DataSourceException {
        int TABLE_NAME = 3;
        int COLUMN_NAME = 4;
        int TYPE_NAME = 6;
        String typeName = rs.getString(6);
        if (typeName.equals("geometry")) {
            String tableName = rs.getString(3);
            String columnName = rs.getString(4);
            return this.getGeometryAttribute(tableName, columnName);
        }
        return super.buildAttributeType(rs);
    }

    AttributeType getGeometryAttribute(String tableName, String columnName) throws SQLException, DataSourceException {
        Connection dbConnection = null;
        try {
            dbConnection = this.getConnection(Transaction.AUTO_COMMIT);
            String sqlStatement = "SELECT type FROM GEOMETRY_COLUMNS WHERE f_table_name='" + tableName + "' AND f_geometry_column='" + columnName + "';";
            LOGGER.fine("geometry sql statement is " + sqlStatement);
            String geometryType = null;
            Statement statement = dbConnection.createStatement();
            ResultSet result = statement.executeQuery(sqlStatement);
            if (result.next()) {
                geometryType = result.getString("type");
                LOGGER.fine("geometry type is: " + geometryType);
            }
            if (geometryType == null) {
                String msg = " no geometry found in the GEOMETRY_COLUMNS table  for " + tableName + " of the postgis install.  A row " + "for " + columnName + " is required  " + " for geotools to work correctly";
                throw new DataSourceException(msg);
            }
            statement.close();
            Class type = (Class)GEOM_TYPE_MAP.get(geometryType);
            AttributeType attributeType = AttributeTypeFactory.newAttributeType((String)columnName, (Class)type);
            return attributeType;
        }
        catch (IOException ioe) {
            throw new DataSourceException("getting connection", (Throwable)ioe);
        }
        finally {
            JDBCUtils.close((Connection)dbConnection, (Transaction)Transaction.AUTO_COMMIT, null);
        }
    }

    public SQLBuilder getSqlBuilder(String typeName) throws IOException {
        SQLEncoderPostgis encoder;
        JDBCDataStore.FeatureTypeInfo info = this.getFeatureTypeInfo(typeName);
        int srid = -1;
        SQLEncoderPostgis sQLEncoderPostgis = encoder = this.useGeos ? new SQLEncoderPostgisGeos() : new SQLEncoderPostgis();
        if (info.getSchema().getDefaultGeometry() != null) {
            String geom = info.getSchema().getDefaultGeometry().getName();
            srid = info.getSRID(geom);
            encoder.setDefaultGeometry(geom);
        }
        encoder.setFidColumn(info.getFidColumnName());
        encoder.setSRID(srid);
        return new PostgisSQLBuilder(encoder);
    }

    protected AttributeReader createGeometryReader(AttributeType attrType, QueryData queryData, int index) throws DataSourceException {
        return new WKTAttributeIO(queryData, attrType, index);
    }

    protected AttributeWriter createGeometryWriter(AttributeType attrType, QueryData queryData, int index) throws DataSourceException {
        return new WKTAttributeIO(queryData, attrType, index);
    }

    protected String determineFidColumnName(String typeName) throws IOException {
        String fidColumn = super.determineFidColumnName(typeName);
        if (fidColumn == null) {
            fidColumn = DEFAULT_FID_COLUMN;
        }
        return fidColumn;
    }

    protected int determineSRID(String tableName, String geometryColumnName) throws IOException {
        Connection dbConnection;
        block5: {
            dbConnection = null;
            String sqlStatement = "SELECT srid FROM GEOMETRY_COLUMNS WHERE f_table_name='" + tableName + "' AND f_geometry_column='" + geometryColumnName + "';";
            dbConnection = this.getConnection(Transaction.AUTO_COMMIT);
            Statement statement = dbConnection.createStatement();
            ResultSet result = statement.executeQuery(sqlStatement);
            if (!result.next()) break block5;
            int retSrid = result.getInt("srid");
            JDBCUtils.close((Statement)statement);
            int n = retSrid;
            JDBCUtils.close((Connection)dbConnection, (Transaction)Transaction.AUTO_COMMIT, null);
            return n;
        }
        try {
            try {
                String mesg = "No geometry column row for srid in table: " + tableName + ", geometry column " + geometryColumnName;
                throw new DataSourceException(mesg);
            }
            catch (SQLException sqle) {
                String message = CONN_ERROR + sqle.getMessage();
                LOGGER.warning(message);
                throw new DataSourceException(message, (Throwable)sqle);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(dbConnection, (Transaction)Transaction.AUTO_COMMIT, null);
            throw throwable;
        }
    }

    protected boolean getUseGeos() throws IOException {
        Connection dbConnection = null;
        try {
            String sqlStatement = "SELECT  postgis_version();";
            dbConnection = this.getConnection(Transaction.AUTO_COMMIT);
            Statement statement = dbConnection.createStatement();
            ResultSet result = statement.executeQuery(sqlStatement);
            boolean retValue = false;
            if (result.next()) {
                String version = result.getString(1);
                LOGGER.fine("version is " + version);
                if (version.indexOf("USE_GEOS=1") != -1) {
                    retValue = true;
                }
            }
            LOGGER.fine("returning " + retValue + " for useGeos");
            boolean bl = retValue;
            return bl;
        }
        catch (SQLException sqle) {
            String message = CONN_ERROR + sqle.getMessage();
            LOGGER.warning(message);
            throw new DataSourceException(message, (Throwable)sqle);
        }
        finally {
            JDBCUtils.close((Connection)dbConnection, (Transaction)Transaction.AUTO_COMMIT, null);
        }
    }

    protected boolean allowTable(String tablename) {
        if (tablename.equals("geometry_columns")) {
            return false;
        }
        return !tablename.startsWith("spatial_ref_sys");
    }

    private String getGeometryText(Geometry geom, int srid) {
        String geoText = geometryWriter.write(geom);
        String sql = "GeometryFromText('" + geoText + "', " + srid + ")";
        return sql;
    }

    protected JDBCDataStore.JDBCFeatureWriter createFeatureWriter(FeatureReader fReader, AttributeWriter writer, QueryData queryData) throws IOException {
        LOGGER.fine("returning postgis feature writer");
        return new PostgisFeatureWriter(fReader, writer, queryData);
    }

    public FeatureSource getFeatureSource(String typeName) throws IOException {
        LOGGER.fine("get Feature source called on " + typeName);
        if (this.OPTIMIZE_MODE == 1) {
            LOGGER.fine("returning pg feature locking");
            return new PostgisFeatureLocking(this, this.getSchema(typeName));
        }
        if (this.getLockingManager() != null) {
            LOGGER.fine("returning jdbc feature locking");
            return new JDBCFeatureLocking((JDBCDataStore)this, this.getSchema(typeName));
        }
        LOGGER.fine("returning jdbc feature store (lock manager is null)");
        return new JDBCFeatureStore((JDBCDataStore)this, this.getSchema(typeName));
    }

    private String makeInsertSql(Feature feature, JDBCDataStore.FeatureTypeInfo ftInfo) {
        String tableName = ftInfo.getFeatureTypeName();
        StringBuffer sql = new StringBuffer("INSERT INTO \"" + tableName + "\"(");
        FeatureType featureSchema = feature.getFeatureType();
        AttributeType[] types = featureSchema.getAttributeTypes();
        if (ftInfo.getFidColumnName() != DEFAULT_FID_COLUMN) {
            sql.append('\"');
            sql.append(ftInfo.getFidColumnName());
            sql.append('\"');
            sql.append(", ");
        }
        for (int i = 0; i < types.length; ++i) {
            sql.append('\"');
            sql.append(types[i].getName());
            sql.append('\"');
            sql.append(i < types.length - 1 ? ", " : ") ");
        }
        sql.append("VALUES (");
        Object[] attributes = feature.getAttributes(null);
        if (ftInfo.getFidColumnName() != DEFAULT_FID_COLUMN) {
            char ch;
            String fid = feature.getID();
            int split = fid.indexOf(46);
            if (split != -1 && fid.substring(0, split).equals(tableName)) {
                fid = fid.substring(split + 1);
            }
            if (Character.isLetter(ch = fid.charAt(0)) || ch == '_') {
                sql.append("'");
                sql.append(fid);
                sql.append("'");
            } else if (Character.isDigit(ch)) {
                try {
                    long number = Long.parseLong(fid);
                    sql.append(number);
                }
                catch (NumberFormatException badNumber) {
                    sql.append(fid);
                }
            } else {
                sql.append(fid);
            }
            sql.append(", ");
        }
        for (int j = 0; j < attributes.length; ++j) {
            if (types[j].isGeometry()) {
                String geomName = types[j].getName();
                int srid = ftInfo.getSRID(geomName);
                String geoText = this.getGeometryText((Geometry)attributes[j], srid);
                sql.append(geoText);
            } else {
                String attrValue = this.addQuotes(attributes[j]);
                sql.append(attrValue);
            }
            if (j >= attributes.length - 1) continue;
            sql.append(", ");
        }
        sql.append(");");
        return sql.toString();
    }

    private String addQuotes(Object value) {
        String retString = value != null ? "'" + value.toString() + "'" : "null";
        return retString;
    }

    String getFidColumn(String typeName) throws IOException {
        return this.getFeatureTypeInfo(typeName).getFidColumnName();
    }

    int getSRID(String typeName, String geomColName) throws IOException {
        return this.getFeatureTypeInfo(typeName).getSRID(geomColName);
    }

    static {
        GEOM_TYPE_MAP.put("GEOMETRY", Geometry.class);
        GEOM_TYPE_MAP.put("POINT", Point.class);
        GEOM_TYPE_MAP.put("LINESTRING", LineString.class);
        GEOM_TYPE_MAP.put("POLYGON", Polygon.class);
        GEOM_TYPE_MAP.put("MULTIPOINT", MultiPoint.class);
        GEOM_TYPE_MAP.put("MULTILINESTRING", MultiLineString.class);
        GEOM_TYPE_MAP.put("MULTIPOLYGON", MultiPolygon.class);
        GEOM_TYPE_MAP.put("GEOMETRYCOLLECTION", GeometryCollection.class);
    }

    protected class PostgisFeatureWriter
    extends JDBCDataStore.JDBCFeatureWriter {
        public PostgisFeatureWriter(FeatureReader fReader, AttributeWriter writer, QueryData queryData) throws IOException {
            super((JDBCDataStore)PostgisDataStore.this, fReader, writer, queryData);
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void doInsert(Feature current) throws IOException, SQLException {
            LOGGER.fine("inserting into postgis feature " + current);
            Statement statement = null;
            Connection conn = this.queryData.getConnection();
            statement = conn.createStatement();
            String sql = PostgisDataStore.this.makeInsertSql(current, this.queryData.getFeatureTypeInfo());
            LOGGER.info(sql);
            statement.executeUpdate(sql);
            Object var6_7 = null;
            if (statement == null) return;
            try {
                statement.close();
                return;
            }
            catch (SQLException e) {
                String msg = "Error closing JDBC Statement";
                LOGGER.log(Level.WARNING, msg, e);
            }
            return;
            {
                catch (SQLException sqle) {
                    String msg = "SQL Exception writing geometry column";
                    LOGGER.log(Level.SEVERE, msg, sqle);
                    this.queryData.close(sqle, (QueryDataObserver)this);
                    throw new DataSourceException(msg, (Throwable)sqle);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (statement == null) throw throwable;
                try {
                    statement.close();
                    throw throwable;
                }
                catch (SQLException e) {
                    String msg = "Error closing JDBC Statement";
                    LOGGER.log(Level.WARNING, msg, e);
                }
                throw throwable;
            }
        }

        public void close() throws IOException {
            super.close();
        }
    }
}

