/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.sql.SQLException;
import java.util.Map;
import org.geotools.data.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceFactorySpi;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.postgis.PostgisConnectionFactory;
import org.geotools.data.postgis.PostgisDataSource;

public class PostgisDataSourceFactory
implements DataSourceFactorySpi {
    private static final String DRIVER_CLASS = "org.postgresql.Driver";

    public boolean canProcess(Map params) {
        if (!params.containsKey("dbtype")) {
            return false;
        }
        if (!((String)params.get("dbtype")).equalsIgnoreCase("postgis")) {
            return false;
        }
        if (!params.containsKey("host")) {
            return false;
        }
        if (!params.containsKey("user")) {
            return false;
        }
        if (!params.containsKey("database")) {
            return false;
        }
        if (!params.containsKey("table")) {
            return false;
        }
        return params.containsKey("port");
    }

    public DataSource createDataSource(Map params) throws DataSourceException {
        if (!this.canProcess(params)) {
            return null;
        }
        String host = (String)params.get("host");
        String user = (String)params.get("user");
        String passwd = (String)params.get("passwd");
        String port = (String)params.get("port");
        String database = (String)params.get("database");
        String table = (String)params.get("table");
        String charSet = (String)params.get("charset");
        String useStrict = (String)params.get("strictbbox");
        String useGeos = (String)params.get("usegeos");
        if (passwd == null) {
            passwd = "";
        }
        PostgisConnectionFactory connFact = new PostgisConnectionFactory(host, port, database);
        try {
            connFact.setLogin(user, passwd);
            connFact.setCharSet(charSet);
            ConnectionPool pool = connFact.getConnectionPool();
            PostgisDataSource pgds = new PostgisDataSource(pool, table);
            if (useStrict != null && useStrict.equals("true")) {
                pgds.setEncodeBbox(false);
            }
            if (useGeos != null && useGeos.equals("true")) {
                pgds.setUseGeosEncoder(true);
            }
            return pgds;
        }
        catch (SQLException sqle) {
            throw new DataSourceException("Unable to connect to database", (Throwable)sqle);
        }
    }

    public String getDescription() {
        return "PostGIS spatial database";
    }
}

