/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.AbstractDataSource;
import org.geotools.data.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceMetaData;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.filter.AbstractFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.SQLEncoderException;
import org.geotools.filter.SQLEncoderPostgis;
import org.geotools.filter.SQLEncoderPostgisGeos;
import org.geotools.filter.SQLUnpacker;

public class PostgisDataSource
extends AbstractDataSource
implements DataSource {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.postgis");
    private static GeometryFactory geometryFactory = new GeometryFactory();
    private static WKTReader geometryReader = new WKTReader(geometryFactory);
    private static WKTWriter geometryWriter = new WKTWriter();
    private static final int HARD_MAX_FEATURES = 1000000;
    public static final String DEFAULT_FID_COLUMN = "oid";
    protected static final String CONN_ERROR = "Some sort of database connection error: ";
    static Map sqlTypeMap = new HashMap();
    private static Map geometryTypeMap = new HashMap();
    private int srid;
    protected SQLEncoderPostgis encoder = new SQLEncoderPostgis();
    private String fidColumn;
    private FeatureType schema = null;
    private ConnectionPool connectionPool;
    private Connection transConn;
    protected String tableName;
    static /* synthetic */ Class class$java$lang$Object;

    public PostgisDataSource(ConnectionPool connPool, String tableName) throws DataSourceException {
        this.connectionPool = connPool;
        LOGGER.finer("new postgis!");
        Connection conn = this.getConnection();
        this.tableName = tableName;
        this.fidColumn = PostgisDataSource.getFidColumn(conn, tableName);
        try {
            this.schema = PostgisDataSource.makeSchema(tableName, conn, this.fidColumn);
            if (this.schema.getDefaultGeometry() != null) {
                this.srid = PostgisDataSource.querySRID(conn, tableName);
                this.encoder.setDefaultGeometry(this.schema.getDefaultGeometry().getName());
                this.encoder.setSRID(this.srid);
            }
        }
        catch (DataSourceException e) {
            throw new DataSourceException("Couldn't make schema: " + (Object)((Object)e), (Throwable)e);
        }
        finally {
            PostgisDataSource.close(conn);
        }
    }

    private static void initMaps() {
        sqlTypeMap.put("varchar", String.class);
        sqlTypeMap.put("int2", Short.class);
        sqlTypeMap.put("int4", Integer.class);
        sqlTypeMap.put("int8", Long.class);
        sqlTypeMap.put("float4", Float.class);
        sqlTypeMap.put("float8", Double.class);
        sqlTypeMap.put("geometry", Geometry.class);
        sqlTypeMap.put("date", Date.class);
        geometryTypeMap.put("GEOMETRY", Geometry.class);
        geometryTypeMap.put("GEOMETRYCOLLECTION", GeometryCollection.class);
        geometryTypeMap.put("POINT", Point.class);
        geometryTypeMap.put("LINESTRING", LineString.class);
        geometryTypeMap.put("POLYGON", Polygon.class);
        geometryTypeMap.put("MULTIPOINT", MultiPoint.class);
        geometryTypeMap.put("MULTILINESTRING", MultiLineString.class);
        geometryTypeMap.put("MULTIPOLYGON", MultiPolygon.class);
    }

    public static FeatureType makeSchema(String tableName, Connection dbConnection) throws DataSourceException {
        return PostgisDataSource.makeSchema(tableName, dbConnection, PostgisDataSource.getFidColumn(dbConnection, tableName));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FeatureType makeSchema(String tableName, Connection dbConnection, String fidColumnName) throws DataSourceException {
        FeatureType featureType;
        Statement statement = null;
        try {
            FeatureType retSchema;
            LOGGER.finer("type map is " + dbConnection.getTypeMap());
            statement = dbConnection.createStatement();
            ResultSet result = statement.executeQuery("SELECT * FROM \"" + tableName + "\" LIMIT 1;");
            ResultSetMetaData metaData = result.getMetaData();
            int attributeCount = metaData.getColumnCount();
            if (!fidColumnName.equals(DEFAULT_FID_COLUMN)) {
                --attributeCount;
            }
            AttributeType[] attributes = new AttributeType[attributeCount];
            int offset = 1;
            int n = metaData.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                LOGGER.finer("reading col: " + i);
                LOGGER.finest("reading col: " + metaData.getColumnTypeName(i));
                LOGGER.finest("reading col: " + metaData.getColumnName(i));
                String columnTypeName = metaData.getColumnTypeName(i);
                String columnName = metaData.getColumnName(i);
                if (columnTypeName.equals("geometry")) {
                    attributes[i - offset] = PostgisDataSource.getGeometryAttribute(dbConnection, tableName, columnName);
                    continue;
                }
                if (columnName.equals(fidColumnName)) {
                    ++offset;
                    continue;
                }
                LOGGER.finer("setting attribute to " + columnName);
                LOGGER.finer("with class " + (Class)sqlTypeMap.get(columnTypeName));
                Class type = (Class)sqlTypeMap.get(columnTypeName);
                if (type == null) {
                    type = class$java$lang$Object == null ? PostgisDataSource.class$("java.lang.Object") : class$java$lang$Object;
                }
                attributes[i - offset] = AttributeTypeFactory.newAttributeType((String)columnName, (Class)type);
                LOGGER.finer("new att-type is " + attributes[i - offset]);
            }
            featureType = retSchema = FeatureTypeFactory.newFeatureType((AttributeType[])attributes, (String)tableName);
        }
        catch (SQLException sqle) {
            try {
                String message = CONN_ERROR + sqle.getMessage();
                LOGGER.warning(message);
                throw new DataSourceException(message, (Throwable)sqle);
                catch (SchemaException sche) {
                    message = "Had problems creating the feature type: ";
                    LOGGER.warning(message);
                    throw new DataSourceException(message, (Throwable)sche);
                }
            }
            catch (Throwable throwable) {
                PostgisDataSource.close(statement);
                throw throwable;
            }
        }
        PostgisDataSource.close(statement);
        return featureType;
    }

    public void setEncodeBbox(boolean looseBbox) {
        this.encoder = new SQLEncoderPostgis(looseBbox);
        if (this.schema.getDefaultGeometry() != null) {
            this.encoder.setDefaultGeometry(this.schema.getDefaultGeometry().getName());
            this.encoder.setSRID(this.srid);
        }
    }

    public void setUseGeosEncoder(boolean useGeos) {
        this.encoder = useGeos ? new SQLEncoderPostgisGeos(this.srid) : new SQLEncoderPostgis(this.srid);
        if (this.schema.getDefaultGeometry() != null) {
            this.encoder.setDefaultGeometry(this.schema.getDefaultGeometry().getName());
        }
    }

    public static int querySRID(Connection dbConnection, String tableName) throws DataSourceException {
        try {
            String sqlStatement = "SELECT srid FROM GEOMETRY_COLUMNS WHERE f_table_name='" + tableName + "';";
            Statement statement = dbConnection.createStatement();
            ResultSet result = statement.executeQuery(sqlStatement);
            if (result.next()) {
                int retSrid = result.getInt("srid");
                PostgisDataSource.close(statement);
                return retSrid;
            }
            throw new DataSourceException("problem querying the db for srid of " + tableName);
        }
        catch (SQLException sqle) {
            String message = CONN_ERROR + sqle.getMessage();
            LOGGER.warning(message);
            throw new DataSourceException(message, (Throwable)sqle);
        }
    }

    public static String getFidColumn(Connection dbConnection, String tableName) {
        String retString = DEFAULT_FID_COLUMN;
        try {
            DatabaseMetaData dbMeta = dbConnection.getMetaData();
            ResultSet pkeys = dbMeta.getPrimaryKeys(null, null, tableName);
            if (pkeys.next()) {
                retString = pkeys.getString(4);
            }
        }
        catch (SQLException sqle) {
            retString = DEFAULT_FID_COLUMN;
        }
        return retString;
    }

    static AttributeType getGeometryAttribute(Connection dbConnection, String tableName, String columnName) throws DataSourceException {
        try {
            String sqlStatement = "SELECT type FROM GEOMETRY_COLUMNS WHERE f_table_name='" + tableName + "' AND f_geometry_column='" + columnName + "';";
            String geometryType = null;
            Statement statement = dbConnection.createStatement();
            ResultSet result = statement.executeQuery(sqlStatement);
            if (result.next()) {
                geometryType = result.getString("type");
                LOGGER.fine("geometry type is: " + geometryType);
            }
            PostgisDataSource.close(statement);
            if (geometryType == null) {
                String msg = " no geometry found in the GEOMETRY_COLUMNS table  for " + tableName + " of the postgis install.  A row " + "for " + columnName + " is required  " + " for geotools to work correctly";
                throw new DataSourceException(msg);
            }
            Class type = (Class)geometryTypeMap.get(geometryType);
            return AttributeTypeFactory.newAttributeType((String)columnName, (Class)type);
        }
        catch (SQLException sqle) {
            String message = CONN_ERROR + sqle.getMessage();
            LOGGER.warning(message);
            throw new DataSourceException(message, (Throwable)sqle);
        }
    }

    public String makeSql(SQLUnpacker unpacker, Query query) throws DataSourceException {
        this.tableName = this.tableName;
        boolean useLimit = unpacker.getUnSupported() == null;
        Filter filter = unpacker.getSupported();
        LOGGER.fine("Filter in making sql is " + filter);
        StringBuffer sqlStatement = new StringBuffer("SELECT ");
        sqlStatement.append(this.fidColumn);
        AttributeType[] attributeTypes = this.getAttTypes(query);
        int numAttributes = attributeTypes.length;
        LOGGER.finer("making sql for " + numAttributes + " attributes");
        for (int i = 0; i < numAttributes; ++i) {
            String curAttName = attributeTypes[i].getName();
            if ((class$com$vividsolutions$jts$geom$Geometry == null ? PostgisDataSource.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(attributeTypes[i].getType())) {
                sqlStatement.append(", AsText(force_2d(\"" + curAttName + "\"))");
                continue;
            }
            if (this.fidColumn.equals(curAttName)) continue;
            sqlStatement.append(", \"" + curAttName + "\"");
        }
        String where = "";
        if (filter != null) {
            try {
                where = this.encoder.encode(filter);
            }
            catch (SQLEncoderException sqle) {
                String message = "Encoder error" + sqle.getMessage();
                LOGGER.warning(message);
                throw new DataSourceException(message, (Throwable)sqle);
            }
        }
        int limit = 1000000;
        if (useLimit) {
            limit = query.getMaxFeatures();
        }
        sqlStatement.append(" FROM \"" + this.tableName + "\" " + where + " LIMIT " + limit + ";").toString();
        LOGGER.fine("sql statement is " + sqlStatement);
        return sqlStatement.toString();
    }

    private AttributeType[] getAttTypes(Query query) throws DataSourceException {
        AttributeType[] schemaTypes = this.schema.getAttributeTypes();
        if (query.retrieveAllProperties()) {
            return schemaTypes;
        }
        List<String> attNames = Arrays.asList(query.getPropertyNames());
        AttributeType[] retAttTypes = new AttributeType[attNames.size()];
        int retPos = 0;
        int n = schemaTypes.length;
        for (int i = 0; i < n; ++i) {
            String schemaTypeName = schemaTypes[i].getName();
            if (!attNames.contains(schemaTypeName)) continue;
            retAttTypes[retPos++] = schemaTypes[i];
        }
        if (attNames.size() != retPos) {
            String msg = "attempted to request a property, " + attNames.get(0) + " that is not part of the schema ";
            throw new DataSourceException(msg);
        }
        return retAttTypes;
    }

    private static void close(Connection conn) throws DataSourceException {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sqle) {
            LOGGER.warning("Error closing connection");
            throw new DataSourceException("could not close connection", (Throwable)sqle);
        }
    }

    protected static void close(Statement statement) throws DataSourceException {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sqle) {
            LOGGER.warning("Error closing statement");
            throw new DataSourceException("could not close statement", (Throwable)sqle);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getFeatures(FeatureCollection collection, Query query) throws DataSourceException {
        Filter filter = query.getFilter();
        int maxFeatures = query.getMaxFeatures();
        LOGGER.finer("query is " + query);
        AttributeType[] attTypes = this.getAttTypes(query);
        Connection conn = null;
        Statement statement = null;
        try {
            FeatureType schema = FeatureTypeFactory.newFeatureType((AttributeType[])attTypes, (String)this.tableName);
            LOGGER.finer("using schema " + schema);
            conn = this.getConnection();
            statement = conn.createStatement();
            LOGGER.finer("made statement");
            SQLUnpacker unpacker = new SQLUnpacker(this.encoder.getCapabilities());
            unpacker.unPackAND(filter);
            String sql = this.makeSql(unpacker, query);
            ResultSet result = statement.executeQuery(sql);
            Object[] attributes = new Object[schema.getAttributeCount()];
            int resultCounter = 0;
            int totalAttributes = schema.getAttributeCount();
            Filter featureFilter = unpacker.getUnSupported();
            while (result.next() && resultCounter < maxFeatures) {
                String featureId = result.getString(1);
                featureId = this.createFid(featureId);
                for (int col = 0; col < totalAttributes; ++col) {
                    if (attTypes[col].isGeometry()) {
                        String wkt = result.getString(col + 2);
                        if (wkt == null) {
                            attributes[col] = null;
                            continue;
                        }
                        attributes[col] = geometryReader.read(wkt);
                        continue;
                    }
                    attributes[col] = result.getObject(col + 2);
                }
                Feature curFeature = schema.create(attributes, featureId);
                if (featureFilter != null && !featureFilter.contains(curFeature)) continue;
                LOGGER.finest("adding feature: " + curFeature);
                collection.add((Object)curFeature);
                ++resultCounter;
            }
            PostgisDataSource.close(statement);
        }
        catch (SQLException sqle) {
            try {
                String message = CONN_ERROR + sqle.getMessage();
                LOGGER.warning(message);
                throw new DataSourceException(message, (Throwable)sqle);
                catch (SchemaException sche) {
                    message = "Problem creating FeatureType: " + sche.getMessage();
                    throw new DataSourceException(message, (Throwable)sche);
                }
                catch (ParseException parseE) {
                    message = "Could not read geometry: " + parseE.getMessage();
                    throw new DataSourceException(message, (Throwable)parseE);
                }
                catch (IllegalAttributeException ilae) {
                    message = "Problem creating Feature: " + ilae.getMessage();
                    throw new DataSourceException(message, (Throwable)ilae);
                }
            }
            catch (Throwable throwable) {
                PostgisDataSource.close(statement);
                PostgisDataSource.close(conn);
                throw throwable;
            }
        }
        PostgisDataSource.close(statement);
        PostgisDataSource.close(conn);
    }

    protected String createFid(String featureId) {
        String newFid = Character.isDigit(featureId.charAt(0)) ? this.tableName + "." + featureId : featureId;
        return newFid;
    }

    public Set addFeatures(FeatureCollection collection) throws DataSourceException {
        boolean previousAutoCommit = this.getAutoCommit();
        this.setAutoCommit(false);
        boolean fail = false;
        Set curFids = null;
        Set newFids = null;
        Connection conn = null;
        Statement statement = null;
        if (collection.size() > 0) {
            try {
                conn = this.getTransactionConnection();
                curFids = this.getFidSet(conn);
                LOGGER.fine("fids before add: " + curFids);
                statement = conn.createStatement();
                FeatureIterator i = collection.features();
                while (i.hasNext()) {
                    String sql = this.makeInsertSql(this.tableName, i.next());
                    LOGGER.finer("this sql statement = " + sql);
                    statement.executeUpdate(sql);
                }
                newFids = this.getFidSet(conn);
                LOGGER.fine("fids after add: " + newFids);
                newFids.removeAll(curFids);
                LOGGER.fine("to return " + newFids);
            }
            catch (SQLException sqle) {
                try {
                    fail = true;
                    String message = CONN_ERROR + sqle.getMessage();
                    LOGGER.warning(message);
                    throw new DataSourceException(message, (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    PostgisDataSource.close(statement);
                    this.finalizeTransactionMethod(previousAutoCommit, fail);
                    throw throwable;
                }
            }
            PostgisDataSource.close(statement);
            this.finalizeTransactionMethod(previousAutoCommit, fail);
        }
        return newFids;
    }

    private Set getFidSet(Connection conn) throws DataSourceException {
        HashSet<String> fids = new HashSet<String>();
        Statement statement = null;
        try {
            LOGGER.finer("entering fid set");
            statement = conn.createStatement();
            DefaultQuery query = new DefaultQuery();
            query.setPropertyNames(new String[0]);
            SQLUnpacker unpacker = new SQLUnpacker(this.encoder.getCapabilities());
            unpacker.unPackAND(null);
            String sql = this.makeSql(unpacker, (Query)query);
            ResultSet result = statement.executeQuery(sql);
            while (result.next()) {
                fids.add(this.createFid(result.getString(1)));
            }
        }
        catch (SQLException sqle) {
            try {
                String message = CONN_ERROR + sqle.getMessage();
                LOGGER.warning(message);
                throw new DataSourceException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                PostgisDataSource.close(statement);
                throw throwable;
            }
        }
        PostgisDataSource.close(statement);
        LOGGER.finest("returning fids " + fids);
        return fids;
    }

    private String makeInsertSql(String tableName, Feature feature) {
        StringBuffer sql = new StringBuffer("INSERT INTO \"" + tableName + "\"(");
        FeatureType featureSchema = feature.getFeatureType();
        AttributeType[] types = featureSchema.getAttributeTypes();
        for (int i = 0; i < types.length; ++i) {
            sql.append("\"" + types[i].getName() + "\"");
            sql.append(i < types.length - 1 ? ", " : ") ");
        }
        sql.append("VALUES (");
        Object[] attributes = feature.getAttributes(null);
        for (int j = 0; j < attributes.length; ++j) {
            if (types[j].isGeometry()) {
                String geoText = geometryWriter.write((Geometry)attributes[j]);
                sql.append("GeometryFromText('" + geoText + "', " + this.srid + ")");
            } else {
                String attrValue = this.addQuotes(attributes[j]);
                sql.append(attrValue);
            }
            if (j >= attributes.length - 1) continue;
            sql.append(", ");
        }
        sql.append(");");
        return sql.toString();
    }

    private String addQuotes(Object value) {
        String retString = value != null ? "'" + value.toString() + "'" : "null";
        return retString;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeFeatures(Filter filter) throws DataSourceException {
        String sql = "";
        String fid = null;
        String whereStmt = null;
        boolean previousAutoCommit = this.getAutoCommit();
        this.setAutoCommit(false);
        boolean fail = false;
        SQLUnpacker unpacker = new SQLUnpacker(this.encoder.getCapabilities());
        unpacker.unPackOR(filter);
        Filter encodableFilter = unpacker.getSupported();
        Filter unEncodableFilter = unpacker.getUnSupported();
        Statement statement = null;
        try {
            Connection conn = this.getTransactionConnection();
            statement = conn.createStatement();
            if (encodableFilter != null) {
                whereStmt = this.encoder.encode((Filter)((AbstractFilter)encodableFilter));
                sql = "DELETE from " + this.tableName + " " + whereStmt + ";";
                LOGGER.fine("sql statment is " + sql);
                statement.executeUpdate(sql);
            }
            if (unEncodableFilter != null) {
                DefaultQuery query = new DefaultQuery();
                query.setPropertyNames(new String[0]);
                query.setFilter(unEncodableFilter);
                FeatureCollection features = this.getFeatures(unEncodableFilter);
                FeatureIterator iter = features.features();
                if (iter.hasNext()) {
                    sql = "DELETE FROM \"" + this.tableName + "\" WHERE ";
                    int i = 0;
                    while (iter.hasNext()) {
                        fid = this.formatFid(iter.next());
                        sql = sql + this.fidColumn + " = " + fid;
                        sql = iter.hasNext() ? sql + " OR " : sql + ";";
                        ++i;
                    }
                    LOGGER.fine("our delete says : " + sql);
                    statement.executeUpdate(sql);
                }
            }
            PostgisDataSource.close(statement);
        }
        catch (SQLException sqle) {
            try {
                fail = true;
                String message = CONN_ERROR + sqle.getMessage();
                LOGGER.warning(message);
                throw new DataSourceException(message, (Throwable)sqle);
                catch (SQLEncoderException ence) {
                    fail = true;
                    message = "error encoding sql from filter " + ence.getMessage();
                    LOGGER.warning(message);
                    throw new DataSourceException(message, (Throwable)ence);
                }
            }
            catch (Throwable throwable) {
                PostgisDataSource.close(statement);
                this.finalizeTransactionMethod(previousAutoCommit, fail);
                throw throwable;
            }
        }
        PostgisDataSource.close(statement);
        this.finalizeTransactionMethod(previousAutoCommit, fail);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifyFeatures(AttributeType[] type, Object[] value, Filter filter) throws DataSourceException {
        boolean previousAutoCommit = this.getAutoCommit();
        this.setAutoCommit(false);
        boolean fail = false;
        Connection conn = null;
        Statement statement = null;
        String sql = "";
        String fid = null;
        SQLUnpacker unpacker = new SQLUnpacker(this.encoder.getCapabilities());
        unpacker.unPackOR(filter);
        String whereStmt = null;
        Filter encodableFilter = unpacker.getSupported();
        Filter unEncodableFilter = unpacker.getUnSupported();
        try {
            FeatureCollection coll;
            conn = this.getTransactionConnection();
            statement = conn.createStatement();
            if (encodableFilter != null) {
                whereStmt = this.encoder.encode((Filter)((AbstractFilter)encodableFilter));
                sql = this.makeModifySql(type, value, whereStmt);
                LOGGER.finer("encoded modify is " + sql);
                statement.executeUpdate(sql);
            }
            if (unEncodableFilter != null && (coll = this.getFeatures(unEncodableFilter)).size() > 0) {
                whereStmt = " WHERE ";
                FeatureIterator iter = coll.features();
                while (iter.hasNext()) {
                    fid = this.formatFid(iter.next());
                    whereStmt = whereStmt + this.fidColumn + " = " + fid;
                    if (!iter.hasNext()) continue;
                    whereStmt = whereStmt + " OR ";
                }
                sql = this.makeModifySql(type, value, whereStmt);
                LOGGER.fine("unencoded modify is " + sql);
                statement.executeUpdate(sql);
            }
        }
        catch (SQLException sqle) {
            try {
                fail = true;
                String message = CONN_ERROR + sqle.getMessage();
                LOGGER.warning(message);
                throw new DataSourceException(message, (Throwable)sqle);
                catch (SQLEncoderException ence) {
                    fail = true;
                    message = "error encoding sql from filter " + ence.getMessage();
                    LOGGER.warning(message);
                    throw new DataSourceException(message, (Throwable)ence);
                }
                catch (DataSourceException dse) {
                    fail = true;
                    throw new DataSourceException("from sql contstruction" + (Object)((Object)dse));
                }
            }
            catch (Throwable throwable) {
                PostgisDataSource.close(statement);
                this.finalizeTransactionMethod(previousAutoCommit, fail);
                throw throwable;
            }
        }
        PostgisDataSource.close(statement);
        this.finalizeTransactionMethod(previousAutoCommit, fail);
    }

    private String formatFid(Feature feature) {
        String fid = feature.getID();
        if (fid.startsWith(this.tableName)) {
            fid = fid.substring(this.tableName.length() + 1);
        }
        return this.addQuotes(fid);
    }

    public void modifyFeatures(AttributeType type, Object value, Filter filter) throws DataSourceException {
        AttributeType[] singleType = new AttributeType[]{type};
        Object[] singleVal = new Object[]{value};
        this.modifyFeatures(singleType, singleVal, filter);
    }

    private String makeModifySql(AttributeType[] types, Object[] values, String whereStmt) throws DataSourceException {
        int arrLength = types.length;
        if (arrLength == values.length) {
            StringBuffer sqlStatement = new StringBuffer("UPDATE ");
            sqlStatement.append("\"" + this.tableName + "\" SET ");
            for (int i = 0; i < arrLength; ++i) {
                String newValue;
                AttributeType curType = types[i];
                Object curValue = values[i];
                if (curType.isGeometry()) {
                    String geoText = geometryWriter.write((Geometry)curValue);
                    newValue = "GeometryFromText('" + geoText + "', " + this.srid + ")";
                } else {
                    newValue = this.addQuotes(curValue);
                }
                sqlStatement.append("\"" + curType.getName() + "\" = " + newValue);
                sqlStatement.append(i < arrLength - 1 ? ", " : " ");
            }
            sqlStatement.append(whereStmt + ";");
            return sqlStatement.toString();
        }
        throw new DataSourceException("length of value array is not same length as type array");
    }

    public FeatureType getSchema() throws DataSourceException {
        return this.schema;
    }

    public void setFeatures(FeatureCollection features) throws DataSourceException {
        boolean originalAutoCommit = this.getAutoCommit();
        this.setAutoCommit(false);
        this.removeFeatures(null);
        this.addFeatures(features);
        this.commit();
        this.setAutoCommit(originalAutoCommit);
    }

    public void commit() throws DataSourceException {
        try {
            LOGGER.fine("commit called");
            this.getTransactionConnection().commit();
            this.closeTransactionConnection();
        }
        catch (SQLException sqle) {
            String message = "problem committing";
            LOGGER.info(message + ": " + sqle.getMessage());
            throw new DataSourceException(message, (Throwable)sqle);
        }
    }

    public void rollback() throws DataSourceException {
        try {
            this.getTransactionConnection().rollback();
            this.closeTransactionConnection();
        }
        catch (SQLException sqle) {
            String message = "problem with rollbacks";
            LOGGER.info(message + ": " + sqle.getMessage());
            throw new DataSourceException(message, (Throwable)sqle);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws DataSourceException {
        try {
            Connection conn = this.getTransactionConnection();
            LOGGER.finer("setting autocommit to " + autoCommit);
            conn.setAutoCommit(autoCommit);
            this.closeTransactionConnection();
        }
        catch (SQLException sqle) {
            String message = "problem setting auto commit";
            LOGGER.info(message + ": " + sqle.getMessage());
            throw new DataSourceException(message, (Throwable)sqle);
        }
    }

    public boolean getAutoCommit() throws DataSourceException {
        try {
            if (this.transConn == null) {
                return true;
            }
            return this.getTransactionConnection().getAutoCommit();
        }
        catch (SQLException sqle) {
            String message = "problem setting auto commit";
            LOGGER.info(message + ": " + sqle.getMessage());
            throw new DataSourceException(message, (Throwable)sqle);
        }
    }

    protected DataSourceMetaData createMetaData() {
        AbstractDataSource.MetaDataSupport pgMeta = new AbstractDataSource.MetaDataSupport();
        pgMeta.setSupportsAdd(true);
        pgMeta.setSupportsRemove(true);
        pgMeta.setSupportsModify(true);
        pgMeta.setSupportsRollbacks(true);
        return pgMeta;
    }

    private Connection getConnection() throws DataSourceException {
        try {
            return this.connectionPool.getConnection();
        }
        catch (SQLException sqle) {
            throw new DataSourceException("could not get connection", (Throwable)sqle);
        }
    }

    private void finalizeTransactionMethod(boolean previousAutoCommit, boolean fail) throws DataSourceException {
        LOGGER.finer("finalizing transaction, prevac: " + previousAutoCommit + ", fail is " + fail);
        if (fail) {
            this.rollback();
        } else if (previousAutoCommit) {
            LOGGER.finer("committing in finalize");
            this.commit();
        }
        this.setAutoCommit(previousAutoCommit);
        this.closeTransactionConnection();
    }

    protected Connection getTransactionConnection() throws DataSourceException, SQLException {
        if (this.transConn == null) {
            this.transConn = this.getConnection();
        }
        return this.transConn;
    }

    private void closeTransactionConnection() {
        try {
            if (this.transConn != null && this.transConn.getAutoCommit()) {
                LOGGER.finer("Closing Transaction Connection");
                this.transConn.close();
                this.transConn = null;
            } else {
                LOGGER.finer("Transaction connection not open or set to manual commit");
            }
        }
        catch (SQLException e) {
            LOGGER.warning("Error closing transaction connection: " + e);
        }
    }

    static {
        PostgisDataSource.initMaps();
    }
}

