/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.arcgrid;

import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.media.jai.RasterFactory;
import org.geotools.data.DataSourceException;
import org.geotools.io.NIOBufferUtils;

public class ArcGridRaster {
    public static final String NCOLS = "NCOLS";
    public static final String NROWS = "NROWS";
    public static final String XLLCORNER = "XLLCORNER";
    public static final String YLLCORNER = "YLLCORNER";
    public static final String CELLSIZE = "CELLSIZE";
    public static final String NODATA_VALUE = "NODATA_VALUE";
    private URL srcURL;
    private float maxValue = Float.MIN_VALUE;
    private float minValue = Float.MAX_VALUE;
    private Map propertyMap;
    static /* synthetic */ Class class$java$lang$String;

    public ArcGridRaster(URL srcURL) throws FileNotFoundException, IOException, DataSourceException {
        this.srcURL = srcURL;
        this.propertyMap = this.initMap();
        File srcFile = new File(URLDecoder.decode(srcURL.getFile(), "UTF-8"));
        BufferedReader reader = new BufferedReader(new FileReader(srcFile));
        this.parseHeader(this.propertyMap, reader);
        if (!this.fullPropertySet(this.propertyMap)) {
            throw new DataSourceException("Needed properties missing in ArcGrid header file");
        }
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public Object getProperty(String property) {
        return this.propertyMap.get(property);
    }

    public int getNRows() {
        return (Integer)this.propertyMap.get(NROWS);
    }

    public int getNCols() {
        return (Integer)this.propertyMap.get(NCOLS);
    }

    public double getXlCorner() {
        return ((Double)this.propertyMap.get(XLLCORNER)).intValue();
    }

    public double getYlCorner() {
        return (Double)this.propertyMap.get(YLLCORNER);
    }

    public double getCellSize() {
        return (Double)this.propertyMap.get(CELLSIZE);
    }

    public double getNoData() {
        return (Double)this.propertyMap.get(NODATA_VALUE);
    }

    private Map initMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(NCOLS, null);
        map.put(NROWS, null);
        map.put(XLLCORNER, null);
        map.put(YLLCORNER, null);
        map.put(CELLSIZE, null);
        map.put(NODATA_VALUE, null);
        return map;
    }

    private void parseHeader(Map properties, BufferedReader reader) throws IOException, DataSourceException {
        String currLine = reader.readLine();
        while (currLine != null) {
            int firstSpaceIndex = (currLine = currLine.trim()).indexOf(32);
            if (firstSpaceIndex == -1) {
                throw new DataSourceException("Illegal line in ArcGrid header file");
            }
            String key = currLine.substring(0, firstSpaceIndex).toUpperCase();
            String value = currLine.substring(firstSpaceIndex).trim();
            if (properties.containsKey(key)) {
                Class propClass = this.getPropertyClass(key);
                try {
                    if (propClass == (class$java$lang$String == null ? ArcGridRaster.class$("java.lang.String") : class$java$lang$String)) {
                        properties.put(key, value);
                    } else if (propClass == (class$java$lang$Integer == null ? ArcGridRaster.class$("java.lang.Integer") : class$java$lang$Integer)) {
                        properties.put(key, Integer.valueOf(value));
                    } else if (propClass == (class$java$lang$Double == null ? ArcGridRaster.class$("java.lang.Double") : class$java$lang$Double)) {
                        properties.put(key, Double.valueOf(value));
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new DataSourceException("Invalid property value in ArcGrid header file", (Throwable)nfe);
                }
            }
            currLine = reader.readLine();
            if (!key.equals(NODATA_VALUE)) continue;
            break;
        }
    }

    private boolean fullPropertySet(Map properties) {
        boolean full = true;
        Collection values = properties.values();
        Iterator it = values.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            full = false;
            break;
        }
        return full;
    }

    private Class getPropertyClass(String key) {
        Class propClass = null;
        propClass = key.equals(XLLCORNER) || key.equals(YLLCORNER) || key.equals(CELLSIZE) || key.equals(NODATA_VALUE) ? Double.class : Integer.class;
        return propClass;
    }

    private Reader openReader() throws IOException {
        if (this.srcURL.getProtocol().equals("file")) {
            return new MemoryMappedReader(new File(this.srcURL.getFile()));
        }
        InputStream in = this.srcURL.openStream();
        BufferedReader r = new BufferedReader(new InputStreamReader(this.srcURL.openStream()));
        return r;
    }

    public WritableRaster getRaster() throws IOException {
        WritableRaster raster = RasterFactory.createBandedRaster((int)4, (int)this.getNCols(), (int)this.getNRows(), (int)1, null);
        int type = 0;
        Reader reader = this.openReader();
        StreamTokenizer st = new StreamTokenizer(reader);
        st.parseNumbers();
        st.wordChars(95, 95);
        st.eolIsSignificant(false);
        st.lowerCaseMode(true);
        for (int i = 0; i < 12; ++i) {
            type = st.nextToken();
        }
        st.ordinaryChars(69, 69);
        type = st.nextToken();
        boolean idx = false;
        float d = 0.0f;
        for (int y = 0; y < this.getNRows(); ++y) {
            for (int x = 0; x < this.getNCols(); ++x) {
                switch (type) {
                    case -2: {
                        d = (float)st.nval;
                        break;
                    }
                    case -1: {
                        throw new IOException("Unexpected EOF at " + x + "," + y);
                    }
                }
                type = st.nextToken();
                switch (type) {
                    case -3: {
                        if (!st.sval.equalsIgnoreCase("E")) {
                            throw new IOException("Malformed floating number at " + x + "," + y + ":" + st.sval);
                        }
                        type = st.nextToken();
                        if (type != -2) {
                            throw new IOException("Expected exponent at " + x + "," + y);
                        }
                        d *= (float)Math.pow(10.0, st.nval);
                        type = st.nextToken();
                    }
                }
                if ((double)d == this.getNoData()) {
                    d = Float.NaN;
                } else {
                    this.minValue = Math.min(this.minValue, d);
                    this.maxValue = Math.max(this.maxValue, d);
                }
                raster.setSample(x, y, 0, d);
            }
        }
        reader.close();
        return raster;
    }

    static class MemoryMappedReader
    extends Reader {
        ByteBuffer map;
        CharBuffer chars;
        CharsetDecoder decoder = Charset.forName("US-ASCII").newDecoder();
        FileChannel channel;

        public MemoryMappedReader(File f) throws IOException {
            this.channel = new FileInputStream(f).getChannel();
            this.map = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.channel.size());
            this.chars = CharBuffer.allocate(16448);
            this.fill();
        }

        public void close() throws IOException {
            if (this.channel != null) {
                this.channel.close();
            }
            NIOBufferUtils.clean((Object)this.map);
            this.channel = null;
            this.map = null;
        }

        void fill() throws IOException {
            this.decoder.decode(this.map, this.chars, false);
            this.chars.flip();
        }

        public int read() throws IOException {
            if (this.chars.remaining() == 0) {
                this.chars.flip();
                this.fill();
                if (this.chars.remaining() == 0) {
                    return -1;
                }
            }
            return this.chars.get();
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            throw new RuntimeException("Expected single character read");
        }
    }
}

