/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.arcgrid;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.DefaultCoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.GeographicCoordinateSystem;
import org.geotools.data.AbstractDataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.Query;
import org.geotools.data.arcgrid.ArcGridRaster;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Filter;
import org.geotools.gc.GridCoverage;

public class ArcGridDataSource
extends AbstractDataSource {
    private URL srcURL;
    private ArcGridRaster arcGridRaster = null;
    private CoordinateSystem coordinateSystem = GeographicCoordinateSystem.WGS84;
    private Color[] demColors = new Color[]{Color.BLUE, Color.WHITE, Color.RED};
    private GridCoverage gridCoverage = null;
    private String name = null;

    public ArcGridDataSource(URL url) throws MalformedURLException, DataSourceException {
        String filename = null;
        try {
            filename = URLDecoder.decode(url.getFile(), "US-ASCII");
        }
        catch (UnsupportedEncodingException use) {
            throw new MalformedURLException("Unable to decode " + url + " cause " + use.getMessage());
        }
        this.name = filename.substring(0, filename.length() - 4);
        this.srcURL = new URL(url, filename);
        try {
            this.arcGridRaster = new ArcGridRaster(this.srcURL);
        }
        catch (Exception e) {
            throw new DataSourceException("Unexpected exception", (Throwable)e);
        }
    }

    public ArcGridRaster getArcGridRaster() {
        return this.arcGridRaster;
    }

    public GridCoverage getGridCoverage() {
        return this.gridCoverage;
    }

    public void setCoordinateSystem(CoordinateSystem coordinateSystem) {
        this.coordinateSystem = coordinateSystem;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public Envelope getBounds() {
        Envelope env = null;
        double xmin = this.arcGridRaster.getXlCorner();
        double ymin = this.arcGridRaster.getYlCorner();
        double xmax = xmin + (double)this.arcGridRaster.getNCols() * this.arcGridRaster.getCellSize();
        double ymax = ymin + (double)this.arcGridRaster.getNRows() * this.arcGridRaster.getCellSize();
        env = new Envelope(xmin, xmax, ymin, ymax);
        return env;
    }

    public FeatureCollection getFeatures(Filter filter) throws DataSourceException {
        FeatureCollection fc = FeatureCollections.newCollection();
        this.getFeatures(fc, filter);
        return fc;
    }

    public void getFeatures(FeatureCollection collection, Query query) throws DataSourceException {
        WritableRaster raster = null;
        try {
            raster = this.arcGridRaster.getRaster();
        }
        catch (IOException ioe) {
            throw new DataSourceException("Error loading data", (Throwable)ioe);
        }
        double[] min = new double[]{this.arcGridRaster.getMinValue()};
        double[] max = new double[]{this.arcGridRaster.getMaxValue()};
        CoordinateSystem coordinateSystem = this.getCoordinateSystem();
        if (coordinateSystem == null) {
            coordinateSystem = GeographicCoordinateSystem.WGS84;
        }
        this.gridCoverage = new GridCoverage(this.name, raster, coordinateSystem, this.convertEnvelope(this.getBounds()), min, max, null, (Color[][])new Color[][]{this.getColors()}, null);
        try {
            collection.add((Object)this.wrapGcInFeature(this.gridCoverage));
        }
        catch (Exception e) {
            throw new DataSourceException("Unexpected error", (Throwable)e);
        }
    }

    private Feature wrapGcInFeature(GridCoverage gc) throws IllegalAttributeException, SchemaException {
        PrecisionModel pm = new PrecisionModel();
        DefaultCoordinateSequenceFactory csf = DefaultCoordinateSequenceFactory.instance();
        GeometryFactory gf = new GeometryFactory(pm, 0);
        Coordinate[] coord = new Coordinate[5];
        Rectangle2D rect = gc.getEnvelope().toRectangle2D();
        coord[0] = new Coordinate(rect.getMinX(), rect.getMinY());
        coord[1] = new Coordinate(rect.getMaxX(), rect.getMinY());
        coord[2] = new Coordinate(rect.getMaxX(), rect.getMaxY());
        coord[3] = new Coordinate(rect.getMinX(), rect.getMaxY());
        coord[4] = new Coordinate(rect.getMinX(), rect.getMinY());
        LinearRing ring = new LinearRing(csf.create(coord), gf);
        Polygon bounds = new Polygon(ring, null, gf);
        AttributeType geom = AttributeTypeFactory.newAttributeType((String)"geom", (Class)Polygon.class);
        AttributeType grid = AttributeTypeFactory.newAttributeType((String)"grid", (Class)GridCoverage.class);
        FeatureType schema = null;
        AttributeType[] attTypes = new AttributeType[]{geom, grid};
        schema = FeatureTypeFactory.newFeatureType((AttributeType[])attTypes, (String)this.name);
        Feature feature = schema.create(new Object[]{bounds, gc});
        return feature;
    }

    private org.geotools.pt.Envelope convertEnvelope(Envelope source) {
        double[] min = new double[]{source.getMinX(), source.getMinY()};
        double[] max = new double[]{source.getMaxX(), source.getMaxY()};
        return new org.geotools.pt.Envelope(min, max);
    }

    public FeatureType getSchema() {
        try {
            AttributeType geom = AttributeTypeFactory.newAttributeType((String)"geom", (Class)Polygon.class);
            AttributeType grid = AttributeTypeFactory.newAttributeType((String)"grid", (Class)GridCoverage.class);
            Object schema = null;
            AttributeType[] attTypes = new AttributeType[]{geom, grid};
            return FeatureTypeFactory.newFeatureType((AttributeType[])attTypes, (String)this.name);
        }
        catch (SchemaException e) {
            throw new RuntimeException("Hey, someone broke the ArcGridDataSource.getSchema() code!");
        }
    }

    public Color[] getColors() {
        return this.demColors;
    }

    public void setColors(Color[] colors) {
        if (colors != null) {
            this.demColors = colors;
        }
    }

    public static final void main(String[] args) throws Exception {
        ArcGridDataSource grid = new ArcGridDataSource(new File(args[0]).toURL());
        Feature g = grid.getFeatures().features().next();
        GridCoverage gc = (GridCoverage)g.getAttribute("grid");
        final RenderedImage i = gc.getRenderedImage();
        final AffineTransform a = new AffineTransform();
        JPanel p = new JPanel(){

            public void paint(Graphics g) {
                ((Graphics2D)g).drawRenderedImage(i, a);
            }
        };
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(p);
        f.setSize(i.getWidth(), i.getHeight());
        f.setLocationRelativeTo(null);
        f.show();
    }
}

