/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.geotools.cs.AxisInfo;
import org.geotools.cs.AxisOrientation;
import org.geotools.cs.CompoundCoordinateSystem;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.Ellipsoid;
import org.geotools.cs.FittedCoordinateSystem;
import org.geotools.cs.GeographicCoordinateSystem;
import org.geotools.cs.HorizontalCoordinateSystem;
import org.geotools.cs.HorizontalDatum;
import org.geotools.cs.ProjectedCoordinateSystem;
import org.geotools.cs.Projection;
import org.geotools.cs.TemporalCoordinateSystem;
import org.geotools.cs.VerticalCoordinateSystem;
import org.geotools.ct.CoordinateTransformation;
import org.geotools.ct.CoordinateTransformationFactory;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MathTransform2D;
import org.geotools.ct.TransformException;
import org.geotools.pt.AngleFormat;
import org.geotools.pt.CoordinatePoint;
import org.geotools.pt.Envelope;
import org.geotools.pt.Latitude;
import org.geotools.pt.Longitude;
import org.geotools.pt.MismatchedDimensionException;
import org.geotools.resources.Utilities;
import org.geotools.resources.XRectangle2D;
import org.geotools.resources.cts.Resources;

public final class CTSUtilities {
    private CTSUtilities() {
    }

    public static int getDimensionOf(CoordinateSystem cs, AxisInfo axis) {
        int dimension = cs.getDimension();
        AxisOrientation orientation = axis.orientation.absolute();
        for (int i = 0; i < dimension; ++i) {
            if (!orientation.equals(cs.getAxis((int)i).orientation.absolute())) continue;
            return i;
        }
        return -1;
    }

    public static int getDimensionOf(CoordinateSystem cs, Class type) {
        if (!CoordinateSystem.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(type.getName());
        }
        if (type.isAssignableFrom(cs.getClass())) {
            return 0;
        }
        if (cs instanceof CompoundCoordinateSystem) {
            CompoundCoordinateSystem comp = (CompoundCoordinateSystem)cs;
            CoordinateSystem headCS = comp.getHeadCS();
            int index = CTSUtilities.getDimensionOf(headCS, type);
            if (index >= 0) {
                return index;
            }
            index = CTSUtilities.getDimensionOf(comp.getTailCS(), type);
            if (index >= 0) {
                return index + headCS.getDimension();
            }
        }
        return -1;
    }

    public static CoordinateSystem getSubCoordinateSystem(CoordinateSystem cs, int lower, int upper) {
        if (lower < 0 || lower > upper || upper > cs.getDimension()) {
            throw new IndexOutOfBoundsException(Resources.format(56, new Integer(lower < 0 ? lower : upper)));
        }
        while (lower != 0 || upper != cs.getDimension()) {
            if (!(cs instanceof CompoundCoordinateSystem)) {
                return null;
            }
            CompoundCoordinateSystem ccs = (CompoundCoordinateSystem)cs;
            int headDim = (cs = ccs.getHeadCS()).getDimension();
            if (lower < headDim) continue;
            cs = ccs.getTailCS();
            lower -= headDim;
            upper -= headDim;
        }
        return cs;
    }

    public static CoordinateSystem getCoordinateSystem2D(CoordinateSystem cs) throws TransformException {
        if (cs != null) {
            while (cs.getDimension() != 2) {
                if (!(cs instanceof CompoundCoordinateSystem)) {
                    throw new TransformException(Resources.format(46, cs.getName(null)));
                }
                cs = ((CompoundCoordinateSystem)cs).getHeadCS();
            }
        }
        return cs;
    }

    public static HorizontalCoordinateSystem getHorizontalCS(CoordinateSystem cs) {
        if (cs instanceof HorizontalCoordinateSystem) {
            return (HorizontalCoordinateSystem)cs;
        }
        if (cs instanceof CompoundCoordinateSystem) {
            CompoundCoordinateSystem comp = (CompoundCoordinateSystem)cs;
            HorizontalCoordinateSystem hcs = CTSUtilities.getHorizontalCS(comp.getHeadCS());
            if (hcs != null) {
                return hcs;
            }
            hcs = CTSUtilities.getHorizontalCS(comp.getTailCS());
            if (hcs != null) {
                return hcs;
            }
        }
        return null;
    }

    public static VerticalCoordinateSystem getVerticalCS(CoordinateSystem cs) {
        if (cs instanceof VerticalCoordinateSystem) {
            return (VerticalCoordinateSystem)cs;
        }
        if (cs instanceof CompoundCoordinateSystem) {
            CompoundCoordinateSystem comp = (CompoundCoordinateSystem)cs;
            VerticalCoordinateSystem vcs = CTSUtilities.getVerticalCS(comp.getHeadCS());
            if (vcs != null) {
                return vcs;
            }
            vcs = CTSUtilities.getVerticalCS(comp.getTailCS());
            if (vcs != null) {
                return vcs;
            }
        }
        return null;
    }

    public static TemporalCoordinateSystem getTemporalCS(CoordinateSystem cs) {
        if (cs instanceof TemporalCoordinateSystem) {
            return (TemporalCoordinateSystem)cs;
        }
        if (cs instanceof CompoundCoordinateSystem) {
            CompoundCoordinateSystem comp = (CompoundCoordinateSystem)cs;
            TemporalCoordinateSystem cts = CTSUtilities.getTemporalCS(comp.getHeadCS());
            if (cts != null) {
                return cts;
            }
            cts = CTSUtilities.getTemporalCS(comp.getTailCS());
            if (cts != null) {
                return cts;
            }
        }
        return null;
    }

    public static Projection getProjection(CoordinateSystem cs) {
        Projection projection;
        if (cs instanceof ProjectedCoordinateSystem && (projection = ((ProjectedCoordinateSystem)cs).getProjection()) != null) {
            return projection;
        }
        if (cs instanceof CompoundCoordinateSystem) {
            CompoundCoordinateSystem comp = (CompoundCoordinateSystem)cs;
            projection = CTSUtilities.getProjection(comp.getHeadCS());
            if (projection != null) {
                return projection;
            }
            projection = CTSUtilities.getProjection(comp.getTailCS());
            if (projection != null) {
                return projection;
            }
        }
        return null;
    }

    public static Ellipsoid getEllipsoid(CoordinateSystem cs) {
        HorizontalDatum datum;
        while (cs instanceof FittedCoordinateSystem) {
            cs = ((FittedCoordinateSystem)cs).getBaseCoordinateSystem();
        }
        if (cs instanceof HorizontalCoordinateSystem && (datum = ((HorizontalCoordinateSystem)cs).getHorizontalDatum()) != null) {
            return datum.getEllipsoid();
        }
        if (cs instanceof CompoundCoordinateSystem) {
            CompoundCoordinateSystem comp = (CompoundCoordinateSystem)cs;
            Ellipsoid ell = CTSUtilities.getEllipsoid(comp.getHeadCS());
            if (ell != null) {
                return ell;
            }
            ell = CTSUtilities.getEllipsoid(comp.getTailCS());
            if (ell != null) {
                return ell;
            }
        }
        return null;
    }

    public static Ellipsoid getHeadGeoEllipsoid(CoordinateSystem coordinateSystem) {
        while (coordinateSystem instanceof FittedCoordinateSystem) {
            coordinateSystem = ((FittedCoordinateSystem)coordinateSystem).getBaseCoordinateSystem();
        }
        if (coordinateSystem instanceof GeographicCoordinateSystem) {
            Ellipsoid ellipsoid;
            HorizontalDatum datum = ((GeographicCoordinateSystem)coordinateSystem).getHorizontalDatum();
            if (datum != null && (ellipsoid = datum.getEllipsoid()) != null) {
                return ellipsoid;
            }
            return Ellipsoid.WGS84;
        }
        if (coordinateSystem instanceof CompoundCoordinateSystem) {
            return CTSUtilities.getHeadGeoEllipsoid(((CompoundCoordinateSystem)coordinateSystem).getHeadCS());
        }
        return null;
    }

    public static Envelope transform(MathTransform transform, Envelope envelope) throws TransformException {
        int sourceDim = transform.getDimSource();
        if (envelope.getDimension() != sourceDim) {
            throw new MismatchedDimensionException(sourceDim, envelope.getDimension());
        }
        int coordinateNumber = 0;
        Envelope transformed = null;
        CoordinatePoint targetPt = null;
        CoordinatePoint sourcePt = new CoordinatePoint(sourceDim);
        int i = sourceDim;
        while (--i >= 0) {
            sourcePt.ord[i] = envelope.getMinimum(i);
        }
        block6: while (true) {
            targetPt = transform.transform(sourcePt, targetPt);
            if (transformed != null) {
                transformed.add(targetPt);
            } else {
                transformed = new Envelope(targetPt, targetPt);
            }
            int n = ++coordinateNumber;
            int i2 = sourceDim;
            while (--i2 >= 0) {
                switch (n % 3) {
                    case 0: {
                        sourcePt.ord[i2] = envelope.getMinimum(i2);
                        n /= 3;
                        break;
                    }
                    case 1: {
                        sourcePt.ord[i2] = envelope.getCenter(i2);
                        continue block6;
                    }
                    case 2: {
                        sourcePt.ord[i2] = envelope.getMaximum(i2);
                        continue block6;
                    }
                }
            }
            break;
        }
        return transformed;
    }

    public static Rectangle2D transform(MathTransform2D transform, Rectangle2D source, Rectangle2D dest) throws TransformException {
        if (source == null) {
            return null;
        }
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        Point2D.Double point = new Point2D.Double();
        for (int i = 0; i < 8; ++i) {
            point.x = (i & 1) == 0 ? source.getMinX() : source.getMaxX();
            point.y = (i & 2) == 0 ? source.getMinY() : source.getMaxY();
            switch (i) {
                case 5: 
                case 6: {
                    point.x = source.getCenterX();
                    break;
                }
                case 4: 
                case 7: {
                    point.y = source.getCenterY();
                }
            }
            transform.transform(point, point);
            if (point.x < xmin) {
                xmin = point.x;
            }
            if (point.x > xmax) {
                xmax = point.x;
            }
            if (point.y < ymin) {
                ymin = point.y;
            }
            if (!(point.y > ymax)) continue;
            ymax = point.y;
        }
        if (dest != null) {
            dest.setRect(xmin, ymin, xmax - xmin, ymax - ymin);
            return dest;
        }
        return XRectangle2D.createFromExtremums((double)xmin, (double)ymin, (double)xmax, (double)ymax);
    }

    public static Point2D deltaTransform(MathTransform2D transform, Point2D origin, Point2D source, Point2D dest) throws TransformException {
        if (transform instanceof AffineTransform) {
            return ((AffineTransform)((Object)transform)).deltaTransform(source, dest);
        }
        double ox = origin.getX();
        double oy = origin.getY();
        double dx = source.getX() * 0.5;
        double dy = source.getY() * 0.5;
        Point2D P1 = new Point2D.Double(ox - dx, oy - dy);
        Point2D P2 = new Point2D.Double(ox + dx, oy + dy);
        P1 = transform.transform(P1, P1);
        P2 = transform.transform(P2, P2);
        if (dest == null) {
            dest = P2;
        }
        dest.setLocation(P2.getX() - P1.getX(), P2.getY() - P1.getY());
        return dest;
    }

    public static String toWGS84String(CoordinateSystem cs, Rectangle2D bounds) {
        StringBuffer buffer;
        block3: {
            buffer = new StringBuffer();
            try {
                cs = CTSUtilities.getCoordinateSystem2D(cs);
                if (!GeographicCoordinateSystem.WGS84.equals(cs, false)) {
                    CoordinateTransformation tr = CoordinateTransformationFactory.getDefault().createFromCoordinateSystems(cs, GeographicCoordinateSystem.WGS84);
                    bounds = CTSUtilities.transform((MathTransform2D)tr.getMathTransform(), bounds, null);
                }
                AngleFormat fmt = new AngleFormat("DD\u00b0MM.m'");
                buffer = fmt.format(new Latitude(bounds.getMinY()), buffer, null);
                buffer.append('-');
                buffer = fmt.format(new Latitude(bounds.getMaxY()), buffer, null);
                buffer.append(' ');
                buffer = fmt.format(new Longitude(bounds.getMinX()), buffer, null);
                buffer.append('-');
                buffer = fmt.format(new Longitude(bounds.getMaxX()), buffer, null);
            }
            catch (TransformException exception) {
                buffer.append(Utilities.getShortClassName((Object)exception));
                String message = exception.getLocalizedMessage();
                if (message == null) break block3;
                buffer.append(": ");
                buffer.append(message);
            }
        }
        return buffer.toString();
    }
}

