/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.pt;

import java.awt.geom.AffineTransform;
import java.text.FieldPosition;
import java.text.NumberFormat;
import javax.vecmath.GMatrix;
import org.geotools.cs.AxisOrientation;
import org.geotools.pt.Envelope;
import org.geotools.pt.MismatchedDimensionException;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;

public class Matrix
extends GMatrix {
    private static final long serialVersionUID = 3126899762163038129L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Matrix(int size) {
        super(size, size);
    }

    public Matrix(int numRow, int numCol) {
        super(numRow, numCol);
    }

    public Matrix(int numRow, int numCol, double[] matrix) {
        super(numRow, numCol, matrix);
        if (numRow * numCol != matrix.length) {
            throw new IllegalArgumentException(String.valueOf(matrix.length));
        }
    }

    public Matrix(double[][] matrix) throws IllegalArgumentException {
        super(matrix.length, matrix.length != 0 ? matrix[0].length : 0);
        int numRow = this.getNumRow();
        int numCol = this.getNumCol();
        for (int j = 0; j < numRow; ++j) {
            if (matrix[j].length != numCol) {
                throw new IllegalArgumentException(Resources.format(59));
            }
            this.setRow(j, matrix[j]);
        }
    }

    public Matrix(GMatrix matrix) {
        super(matrix);
    }

    public Matrix(AffineTransform transform) {
        super(3, 3, new double[]{transform.getScaleX(), transform.getShearX(), transform.getTranslateX(), transform.getShearY(), transform.getScaleY(), transform.getTranslateY(), 0.0, 0.0, 1.0});
        if (!$assertionsDisabled && !this.isAffine()) {
            throw new AssertionError();
        }
    }

    private Matrix(Envelope srcRegion, AxisOrientation[] srcAxis, Envelope dstRegion, AxisOrientation[] dstAxis, boolean validRegions) {
        this(srcAxis.length + 1);
        int dimension = srcAxis.length;
        if (dstAxis.length != dimension) {
            throw new MismatchedDimensionException(dimension, dstAxis.length);
        }
        if (validRegions) {
            srcRegion.ensureDimensionMatch(dimension);
            dstRegion.ensureDimensionMatch(dimension);
        }
        this.setZero();
        for (int srcIndex = 0; srcIndex < dimension; ++srcIndex) {
            boolean hasFound = false;
            AxisOrientation srcAxe = srcAxis[srcIndex];
            AxisOrientation search = srcAxe.absolute();
            for (int dstIndex = 0; dstIndex < dimension; ++dstIndex) {
                AxisOrientation dstAxe = dstAxis[dstIndex];
                if (!search.equals(dstAxe.absolute())) continue;
                if (hasFound) {
                    throw new IllegalArgumentException(Resources.format(47, srcAxe.getName(null), dstAxe.getName(null)));
                }
                hasFound = true;
                boolean normal = srcAxe.equals(dstAxe);
                double scale = normal ? 1.0 : -1.0;
                double translate = 0.0;
                if (validRegions) {
                    translate = normal ? dstRegion.getMinimum(dstIndex) : dstRegion.getMaximum(dstIndex);
                    translate -= srcRegion.getMinimum(srcIndex) * (scale *= dstRegion.getLength(dstIndex) / srcRegion.getLength(srcIndex));
                }
                this.setElement(dstIndex, srcIndex, scale);
                this.setElement(dstIndex, dimension, translate);
            }
            if (hasFound) continue;
            throw new IllegalArgumentException(Resources.format(70, srcAxis[srcIndex].getName(null)));
        }
        this.setElement(dimension, dimension, 1.0);
        if (!$assertionsDisabled && !this.isAffine()) {
            throw new AssertionError();
        }
    }

    public static Matrix createAffineTransform(AxisOrientation[] srcAxis, AxisOrientation[] dstAxis) {
        return new Matrix(null, srcAxis, null, dstAxis, false);
    }

    public static Matrix createAffineTransform(Envelope srcRegion, Envelope dstRegion) {
        int dimension = srcRegion.getDimension();
        dstRegion.ensureDimensionMatch(dimension);
        Matrix matrix = new Matrix(dimension + 1);
        for (int i = 0; i < dimension; ++i) {
            double scale = dstRegion.getLength(i) / srcRegion.getLength(i);
            double translate = dstRegion.getMinimum(i) - srcRegion.getMinimum(i) * scale;
            matrix.setElement(i, i, scale);
            matrix.setElement(i, dimension, translate);
        }
        matrix.setElement(dimension, dimension, 1.0);
        if (!$assertionsDisabled && !matrix.isAffine()) {
            throw new AssertionError();
        }
        return matrix;
    }

    public static Matrix createAffineTransform(Envelope srcRegion, AxisOrientation[] srcAxis, Envelope dstRegion, AxisOrientation[] dstAxis) {
        return new Matrix(srcRegion, srcAxis, dstRegion, dstAxis, true);
    }

    public final double[][] getElements() {
        int numCol = this.getNumCol();
        double[][] matrix = new double[this.getNumRow()][];
        for (int j = 0; j < matrix.length; ++j) {
            matrix[j] = new double[numCol];
            this.getRow(j, matrix[j]);
        }
        return matrix;
    }

    public final boolean isAffine() {
        int dimension = this.getNumRow();
        if (dimension != this.getNumCol()) {
            return false;
        }
        --dimension;
        for (int i = 0; i <= dimension; ++i) {
            if (this.getElement(dimension, i) == (double)(i == dimension ? 1 : 0)) continue;
            return false;
        }
        return true;
    }

    public final boolean isIdentity() {
        int numCol;
        int numRow = this.getNumRow();
        if (numRow != (numCol = this.getNumCol())) {
            return false;
        }
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                if (this.getElement(j, i) == (double)(i == j ? 1 : 0)) continue;
                return false;
            }
        }
        if (!$assertionsDisabled && !this.isAffine()) {
            throw new AssertionError();
        }
        return true;
    }

    public final AffineTransform toAffineTransform2D() throws IllegalStateException {
        int check = this.getNumRow();
        if (check != 3 || (check = this.getNumCol()) != 3) {
            throw new IllegalStateException(Resources.format(68, new Integer(check - 1)));
        }
        if (this.isAffine()) {
            return new AffineTransform(this.getElement(0, 0), this.getElement(1, 0), this.getElement(0, 1), this.getElement(1, 1), this.getElement(0, 2), this.getElement(1, 2));
        }
        throw new IllegalStateException(Resources.format(66));
    }

    public String toString() {
        int numRow = this.getNumRow();
        int numCol = this.getNumCol();
        StringBuffer buffer = new StringBuffer();
        int columnWidth = 12;
        String lineSeparator = System.getProperty("line.separator", "\n");
        FieldPosition dummy = new FieldPosition(0);
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMinimumFractionDigits(6);
        format.setMaximumFractionDigits(6);
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                int position = buffer.length();
                buffer = format.format(this.getElement(j, i), buffer, dummy);
                buffer.insert(position, Utilities.spaces((int)(12 - (buffer.length() - position))));
            }
            buffer.append(lineSeparator);
        }
        return buffer.toString();
    }

    static {
        $assertionsDisabled = !Matrix.class.desiredAssertionStatus();
    }
}

