/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.pt;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Arrays;
import org.geotools.pt.CoordinatePoint;
import org.geotools.pt.Dimensioned;
import org.geotools.pt.MismatchedDimensionException;
import org.geotools.resources.XRectangle2D;
import org.geotools.resources.cts.Resources;
import org.geotools.util.Cloneable;

public class Envelope
implements Dimensioned,
Cloneable,
Serializable {
    private static final long serialVersionUID = -3228667532994790309L;
    private final double[] ord;

    private void checkCoherence() throws IllegalArgumentException {
        int dimension = this.ord.length / 2;
        for (int i = 0; i < dimension; ++i) {
            if (this.ord[i] <= this.ord[dimension + i]) continue;
            throw new IllegalArgumentException(Resources.format(54, new Integer(i)));
        }
    }

    private Envelope(Envelope envelope) {
        this.ord = (double[])envelope.ord.clone();
    }

    public Envelope(int dimension) {
        this.ord = new double[dimension * 2];
    }

    public Envelope(double min, double max) {
        this.ord = new double[]{min, max};
        this.checkCoherence();
    }

    public Envelope(double[] minCP, double[] maxCP) throws MismatchedDimensionException {
        if (minCP.length != maxCP.length) {
            throw new MismatchedDimensionException(minCP.length, maxCP.length);
        }
        this.ord = new double[minCP.length + maxCP.length];
        System.arraycopy(minCP, 0, this.ord, 0, minCP.length);
        System.arraycopy(maxCP, 0, this.ord, minCP.length, maxCP.length);
        this.checkCoherence();
    }

    public Envelope(CoordinatePoint minCP, CoordinatePoint maxCP) throws MismatchedDimensionException {
        this(minCP.ord, maxCP.ord);
    }

    public Envelope(Rectangle2D rect) {
        this.ord = new double[]{rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY()};
        this.checkCoherence();
    }

    void ensureDimensionMatch(int expectedDimension) throws MismatchedDimensionException {
        int dimension = this.getDimension();
        if (dimension != expectedDimension) {
            throw new MismatchedDimensionException(dimension, expectedDimension);
        }
    }

    public boolean isEmpty() {
        int dimension = this.ord.length / 2;
        for (int i = 0; i < dimension; ++i) {
            if (this.ord[i] < this.ord[i + dimension]) continue;
            return true;
        }
        return false;
    }

    public int getDimension() {
        return this.ord.length / 2;
    }

    public double getMinimum(int dimension) {
        if (dimension < this.ord.length / 2) {
            return this.ord[dimension];
        }
        throw new ArrayIndexOutOfBoundsException(dimension);
    }

    public double getMaximum(int dimension) {
        if (dimension >= 0) {
            return this.ord[dimension + this.ord.length / 2];
        }
        throw new ArrayIndexOutOfBoundsException(dimension);
    }

    public double getCenter(int dimension) {
        return 0.5 * (this.ord[dimension] + this.ord[dimension + this.ord.length / 2]);
    }

    public double getLength(int dimension) {
        return this.ord[dimension + this.ord.length / 2] - this.ord[dimension];
    }

    public void setRange(int dimension, double minimum, double maximum) {
        if (minimum > maximum) {
            minimum = maximum = 0.5 * (minimum + maximum);
        }
        if (dimension < 0) {
            throw new ArrayIndexOutOfBoundsException(dimension);
        }
        this.ord[dimension + this.ord.length / 2] = maximum;
        this.ord[dimension] = minimum;
    }

    public void add(CoordinatePoint point) throws MismatchedDimensionException {
        int dim = this.ord.length / 2;
        point.ensureDimensionMatch(dim);
        for (int i = 0; i < dim; ++i) {
            double value = point.ord[i];
            if (value < this.ord[i]) {
                this.ord[i] = value;
            }
            if (!(value > this.ord[i + dim])) continue;
            this.ord[i + dim] = value;
        }
    }

    public void add(Envelope envelope) throws MismatchedDimensionException {
        int dim = this.ord.length / 2;
        envelope.ensureDimensionMatch(dim);
        for (int i = 0; i < dim; ++i) {
            double min = envelope.ord[i];
            double max = envelope.ord[i + dim];
            if (min < this.ord[i]) {
                this.ord[i] = min;
            }
            if (!(max > this.ord[i + dim])) continue;
            this.ord[i + dim] = max;
        }
    }

    public boolean contains(CoordinatePoint point) throws MismatchedDimensionException {
        int dimension = this.ord.length / 2;
        point.ensureDimensionMatch(dimension);
        for (int i = 0; i < dimension; ++i) {
            double value = point.ord[i];
            if (!(value >= this.ord[i])) {
                return false;
            }
            if (value <= this.ord[i + dimension]) continue;
            return false;
        }
        return true;
    }

    public void intersect(Envelope envelope) throws MismatchedDimensionException {
        int dim = this.ord.length / 2;
        envelope.ensureDimensionMatch(dim);
        for (int i = 0; i < dim; ++i) {
            double max;
            double min = Math.max(this.ord[i], envelope.ord[i]);
            if (min > (max = Math.min(this.ord[i + dim], envelope.ord[i + dim]))) {
                min = max = 0.5 * (min + max);
            }
            this.ord[i] = min;
            this.ord[i + dim] = max;
        }
    }

    public Envelope createIntersection(Envelope envelope) throws MismatchedDimensionException {
        int dim = this.ord.length / 2;
        envelope.ensureDimensionMatch(dim);
        Envelope dest = new Envelope(dim);
        for (int i = 0; i < dim; ++i) {
            double max;
            double min = Math.max(this.ord[i], envelope.ord[i]);
            if (min > (max = Math.min(this.ord[i + dim], envelope.ord[i + dim]))) {
                min = max = 0.5 * (min + max);
            }
            dest.ord[i] = min;
            dest.ord[i + dim] = max;
        }
        return dest;
    }

    public Envelope getSubEnvelope(int lower, int upper) {
        int curDim = this.ord.length / 2;
        int newDim = upper - lower;
        if (lower < 0 || lower > curDim) {
            throw new IndexOutOfBoundsException(Resources.format(50, "lower", new Integer(lower)));
        }
        if (newDim < 0 || upper > curDim) {
            throw new IndexOutOfBoundsException(Resources.format(50, "upper", new Integer(upper)));
        }
        Envelope envelope = new Envelope(newDim);
        System.arraycopy(this.ord, lower, envelope.ord, 0, newDim);
        System.arraycopy(this.ord, lower + curDim, envelope.ord, newDim, newDim);
        return envelope;
    }

    public Envelope getReducedEnvelope(int lower, int upper) {
        int curDim = this.ord.length / 2;
        int rmvDim = upper - lower;
        if (lower < 0 || lower > curDim) {
            throw new IndexOutOfBoundsException(Resources.format(50, "lower", new Integer(lower)));
        }
        if (rmvDim < 0 || upper > curDim) {
            throw new IndexOutOfBoundsException(Resources.format(50, "upper", new Integer(upper)));
        }
        Envelope envelope = new Envelope(curDim - rmvDim);
        System.arraycopy(this.ord, 0, envelope.ord, 0, lower);
        System.arraycopy(this.ord, lower, envelope.ord, upper, curDim - upper);
        return envelope;
    }

    public Rectangle2D toRectangle2D() throws IllegalStateException {
        if (this.ord.length == 4) {
            return XRectangle2D.createFromExtremums((double)this.ord[0], (double)this.ord[1], (double)this.ord[2], (double)this.ord[3]);
        }
        throw new IllegalStateException(Resources.format(68, new Integer(this.getDimension())));
    }

    public int hashCode() {
        return CoordinatePoint.hashCode(this.ord);
    }

    public boolean equals(Object object) {
        if (object instanceof Envelope) {
            Envelope that = (Envelope)object;
            return Arrays.equals(this.ord, that.ord);
        }
        return false;
    }

    public Object clone() {
        return new Envelope(this);
    }

    public String toString() {
        return CoordinatePoint.toString(this, this.ord);
    }
}

