/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.pt;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Arrays;
import org.geotools.pt.Dimensioned;
import org.geotools.pt.MismatchedDimensionException;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.geotools.util.Cloneable;

public class CoordinatePoint
implements Dimensioned,
Cloneable,
Serializable {
    private static final long serialVersionUID = -6975990652038126533L;
    public final double[] ord;

    public CoordinatePoint(int numDim) throws NegativeArraySizeException {
        this.ord = new double[numDim];
    }

    public CoordinatePoint(double[] ord) {
        this.ord = (double[])ord.clone();
    }

    public CoordinatePoint(double x, double y) {
        this.ord = new double[]{x, y};
    }

    public CoordinatePoint(double x, double y, double z) {
        this.ord = new double[]{x, y, z};
    }

    public CoordinatePoint(Point2D point) {
        this(point.getX(), point.getY());
    }

    public CoordinatePoint(CoordinatePoint point) {
        this.ord = (double[])point.ord.clone();
    }

    public void setLocation(Point2D point) throws MismatchedDimensionException {
        if (this.ord.length != 2) {
            throw new MismatchedDimensionException(Resources.format(68, new Integer(this.ord.length)));
        }
        this.ord[0] = point.getX();
        this.ord[1] = point.getY();
    }

    public void setLocation(CoordinatePoint point) throws MismatchedDimensionException {
        this.ensureDimensionMatch(point.ord.length);
        System.arraycopy(point.ord, 0, this.ord, 0, this.ord.length);
    }

    public final double getOrdinate(int dimension) {
        return this.ord[dimension];
    }

    public final int getDimension() {
        return this.ord.length;
    }

    final void ensureDimensionMatch(int expectedDimension) throws MismatchedDimensionException {
        int dimension = this.getDimension();
        if (dimension != expectedDimension) {
            throw new MismatchedDimensionException(dimension, expectedDimension);
        }
    }

    public Point2D toPoint2D() throws IllegalStateException {
        if (this.ord.length == 2) {
            return new Point2D.Double(this.ord[0], this.ord[1]);
        }
        throw new IllegalStateException(Resources.format(68, new Integer(this.ord.length)));
    }

    public int hashCode() {
        return CoordinatePoint.hashCode(this.ord);
    }

    static int hashCode(double[] ord) {
        long code = 78516481L;
        if (ord != null) {
            int i = ord.length;
            while (--i >= 0) {
                code = code * 31L + Double.doubleToLongBits(ord[i]);
            }
        }
        return (int)(code >>> 32) ^ (int)code;
    }

    public boolean equals(Object object) {
        if (object instanceof CoordinatePoint) {
            CoordinatePoint that = (CoordinatePoint)object;
            return Arrays.equals(this.ord, that.ord);
        }
        return false;
    }

    public Object clone() {
        return new CoordinatePoint(this.ord);
    }

    public String toString() {
        return CoordinatePoint.toString(this, this.ord);
    }

    static String toString(Object owner, double[] ord) {
        StringBuffer buffer = new StringBuffer(Utilities.getShortClassName((Object)owner));
        buffer.append('[');
        for (int i = 0; i < ord.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(ord[i]);
        }
        buffer.append(']');
        return buffer.toString();
    }
}

