/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.pt;

import org.geotools.pt.CoordinatePoint;
import org.geotools.pt.Envelope;
import org.geotools.pt.Matrix;
import org.opengis.pt.PT_CoordinatePoint;
import org.opengis.pt.PT_Envelope;
import org.opengis.pt.PT_Matrix;

public class Adapters {
    protected Adapters() {
    }

    public PT_CoordinatePoint export(CoordinatePoint point) {
        if (point == null) {
            return null;
        }
        PT_CoordinatePoint pt = new PT_CoordinatePoint();
        pt.ord = (double[])point.ord.clone();
        return pt;
    }

    public PT_Envelope export(Envelope envelope) {
        if (envelope == null) {
            return null;
        }
        int dimension = envelope.getDimension();
        PT_Envelope ep = new PT_Envelope();
        ep.minCP = new PT_CoordinatePoint();
        ep.maxCP = new PT_CoordinatePoint();
        ep.minCP.ord = new double[dimension];
        ep.maxCP.ord = new double[dimension];
        for (int i = 0; i < dimension; ++i) {
            ep.minCP.ord[i] = envelope.getMinimum(i);
            ep.maxCP.ord[i] = envelope.getMaximum(i);
        }
        return ep;
    }

    public PT_Matrix export(Matrix matrix) {
        PT_Matrix m = new PT_Matrix();
        m.elt = matrix.getElements();
        return m;
    }

    public CoordinatePoint wrap(PT_CoordinatePoint point) {
        return point != null ? new CoordinatePoint(point.ord) : null;
    }

    public Envelope wrap(PT_Envelope envelope) {
        return envelope != null ? new Envelope(envelope.minCP.ord, envelope.maxCP.ord) : null;
    }

    public Matrix wrap(PT_Matrix matrix) {
        return matrix != null ? new Matrix(matrix.elt) : null;
    }
}

