/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct.proj;

import java.util.Locale;
import org.geotools.cs.Projection;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MissingParameterException;
import org.geotools.ct.proj.EquatorialStereographic;
import org.geotools.ct.proj.MapProjection;
import org.geotools.ct.proj.ObliqueStereographic;
import org.geotools.ct.proj.PlanarProjection;
import org.geotools.ct.proj.PolarStereographic;
import org.geotools.resources.cts.Resources;

public abstract class Stereographic
extends PlanarProjection {
    static final int MAX_ITER = 10;

    protected Stereographic(Projection parameters) throws MissingParameterException {
        super(parameters);
    }

    public String getName(Locale locale) {
        return Resources.getResources(locale).getString(33);
    }

    static final class Provider
    extends org.geotools.ct.proj.Provider {
        private final boolean polar;
        private final boolean EPSG;

        public Provider(boolean polar) {
            this(polar, false);
        }

        public Provider(boolean polar, boolean EPSG2) {
            super(EPSG2 ? (polar ? "Polar_Stereographic_EPSG" : "Oblique_Stereographic_EPSG") : (polar ? "Polar_Stereographic" : "Oblique_Stereographic"), 33);
            if (polar && !EPSG2) {
                this.put("latitude_true_scale", polar ? 90.0 : 0.0, LATITUDE_RANGE);
            }
            this.polar = polar;
            this.EPSG = EPSG2;
        }

        public MathTransform create(Projection parameters) throws MissingParameterException {
            double latitudeOfOrigin = Math.abs(MapProjection.latitudeToRadians(parameters.getValue("latitude_of_origin", this.polar ? 90.0 : 0.0), true));
            boolean isSpherical = Provider.isSpherical(parameters);
            if (Math.abs(latitudeOfOrigin - 1.5707963267948966) < 1.0E-6) {
                if (isSpherical) {
                    return new PolarStereographic.Spherical(parameters);
                }
                if (this.EPSG) {
                    return new PolarStereographic.EPSG(parameters);
                }
                return new PolarStereographic(parameters);
            }
            if (latitudeOfOrigin < 1.0E-6) {
                if (isSpherical) {
                    return new EquatorialStereographic.Spherical(parameters);
                }
                if (!this.EPSG) {
                    return new EquatorialStereographic(parameters);
                }
            }
            if (isSpherical) {
                return new ObliqueStereographic.Spherical(parameters);
            }
            if (this.EPSG) {
                return new ObliqueStereographic.EPSG(parameters);
            }
            return new ObliqueStereographic(parameters);
        }
    }
}

