/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct.proj;

import java.util.Locale;
import javax.media.jai.ParameterList;
import org.geotools.cs.Projection;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MathTransformProvider;
import org.geotools.ct.MissingParameterException;
import org.geotools.ct.proj.AlbersEqualArea;
import org.geotools.ct.proj.LambertConformal;
import org.geotools.ct.proj.Mercator;
import org.geotools.ct.proj.Orthographic;
import org.geotools.ct.proj.Stereographic;
import org.geotools.ct.proj.TransverseMercator;
import org.geotools.resources.DescriptorNaming;
import org.geotools.resources.cts.Resources;

public abstract class Provider
extends MathTransformProvider {
    private static Provider[] DEFAULT;
    private final int nameKey;

    public static synchronized Provider[] getDefaults() {
        if (DEFAULT == null) {
            DEFAULT = new Provider[]{new LambertConformal.Provider(false, false, true), new LambertConformal.Provider(true, false, true), new LambertConformal.Provider(true, true, true), new LambertConformal.Provider(false, false, false), new LambertConformal.Provider(true, false, false), new LambertConformal.Provider(true, true, false), new Mercator.Provider(false), new Mercator.Provider(true), new TransverseMercator.Provider(), new Stereographic.Provider(false, false), new Stereographic.Provider(true, false), new Stereographic.Provider(false, true), new Stereographic.Provider(true, true), new Orthographic.Provider(), new AlbersEqualArea.Provider()};
            for (int i = 0; i < DEFAULT.length; ++i) {
                Provider provider = DEFAULT[i];
                DescriptorNaming.PROJECTIONS.bind(provider.getClassName(), provider.getParameterListDescriptor());
            }
        }
        return (Provider[])DEFAULT.clone();
    }

    Provider(String classname, int nameKey) {
        super(classname, DEFAULT_PROJECTION_DESCRIPTOR);
        this.nameKey = nameKey;
    }

    public String getName(Locale locale) {
        return this.nameKey >= 0 ? Resources.getResources(locale).getString(this.nameKey) : super.getName(locale);
    }

    public final MathTransform create(ParameterList parameters) throws MissingParameterException {
        return this.create(new Projection("Generated", this.getClassName(), parameters));
    }

    public abstract MathTransform create(Projection var1) throws MissingParameterException;

    static boolean isSpherical(Projection parameters) throws MissingParameterException {
        return parameters.getValue("semi_major") == parameters.getValue("semi_minor");
    }
}

