/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct.proj;

import java.awt.geom.Point2D;
import org.geotools.cs.Projection;
import org.geotools.ct.MissingParameterException;
import org.geotools.ct.proj.ProjectionException;
import org.geotools.ct.proj.Stereographic;
import org.geotools.resources.cts.Resources;

public class PolarStereographic
extends Stereographic {
    private final double k0;
    final double latitudeTrueScale;
    final boolean southPole;
    static /* synthetic */ Class class$org$geotools$ct$proj$PolarStereographic;

    protected PolarStereographic(Projection parameters) throws MissingParameterException {
        super(parameters);
        this.latitudeTrueScale = Math.abs(PolarStereographic.latitudeToRadians(parameters.getValue("latitude_true_scale", parameters.getValue("latitude_of_origin", 90.0)), true));
        this.southPole = this.latitudeOfOrigin < 0.0;
        this.latitudeOfOrigin = this.southPole ? -1.5707963267948966 : 1.5707963267948966;
        if (Math.abs(this.latitudeTrueScale - 1.5707963267948966) >= 1.0E-6) {
            double t = Math.sin(this.latitudeTrueScale);
            this.k0 = this.msfn(t, Math.cos(this.latitudeTrueScale)) / this.tsfn(this.latitudeTrueScale, t);
        } else {
            this.k0 = 2.0 / Math.sqrt(Math.pow(1.0 + this.e, 1.0 + this.e) * Math.pow(1.0 - this.e, 1.0 - this.e));
        }
    }

    boolean isEPSG() {
        return false;
    }

    final void toString(StringBuffer buffer) {
        super.toString(buffer);
        if (!this.isEPSG()) {
            PolarStereographic.addParameter(buffer, "latitude_true_scale", Math.toDegrees(this.latitudeTrueScale));
        }
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double sinlat = Math.sin(y);
        double coslon = Math.cos(x);
        double sinlon = Math.sin(x);
        if (this.southPole) {
            double rho = this.k0 * this.tsfn(-y, -sinlat);
            x = rho * sinlon;
            y = rho * coslon;
        } else {
            double rho = this.k0 * this.tsfn(y, sinlat);
            x = rho * sinlon;
            y = -rho * coslon;
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double phi;
        double rho;
        block3: {
            rho = Math.sqrt(x * x + y * y);
            if (this.southPole) {
                y = -y;
            }
            double t = rho / this.k0;
            double halfe = this.e / 2.0;
            double phi0 = 0.0;
            int i = 10;
            do {
                double esinphi;
                if (Math.abs((phi = 1.5707963267948966 - 2.0 * Math.atan(t * Math.pow((1.0 - (esinphi = this.e * Math.sin(phi0))) / (1.0 + esinphi), halfe))) - phi0) < 1.0E-10) break block3;
                phi0 = phi;
            } while (--i >= 0);
            throw new ProjectionException(Resources.format(69));
        }
        x = Math.abs(rho) < 1.0E-10 ? 0.0 : Math.atan2(x, -y);
        y = this.southPole ? -phi : phi;
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.k0);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            PolarStereographic that = (PolarStereographic)object;
            return this.southPole == that.southPole && PolarStereographic.equals(this.k0, that.k0) && PolarStereographic.equals(this.latitudeTrueScale, that.latitudeTrueScale);
        }
        return false;
    }

    static final class EPSG
    extends PolarStereographic {
        private final double A;
        private final double B;
        private double C;
        private double D;
        private final double k0;
        static final /* synthetic */ boolean $assertionsDisabled;

        protected EPSG(Projection parameters) throws MissingParameterException {
            super(parameters);
            double e6 = this.es * this.es * this.es;
            double e8 = this.es * this.es * this.es * this.es;
            this.C = 7.0 * e6 / 120.0 + 81.0 * e8 / 1120.0;
            this.D = 4279.0 * e8 / 161280.0;
            this.A = this.es / 2.0 + 5.0 * this.es * this.es / 24.0 + e6 / 12.0 + 13.0 * e8 / 360.0 - this.C;
            this.B = 2.0 * (7.0 * this.es * this.es / 48.0 + 29.0 * e6 / 240.0 + 811.0 * e8 / 11520.0) - 4.0 * this.D;
            this.C *= 4.0;
            this.D *= 8.0;
            if (Math.abs(this.latitudeTrueScale - 1.5707963267948966) >= 1.0E-6) {
                double t = Math.sin(this.latitudeTrueScale);
                this.k0 = this.msfn(t, Math.cos(this.latitudeTrueScale)) * Math.sqrt(Math.pow(1.0 + this.e, 1.0 + this.e) * Math.pow(1.0 - this.e, 1.0 - this.e)) / (2.0 * this.tsfn(this.latitudeTrueScale, t));
            } else {
                this.k0 = 1.0;
            }
        }

        boolean isEPSG() {
            return true;
        }

        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (!$assertionsDisabled && (ptDst = super.inverseTransformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            double rho = Math.sqrt(x * x + y * y);
            if (this.southPole) {
                y = -y;
            }
            double t = rho / this.k0 * Math.sqrt(Math.pow(1.0 + this.e, 1.0 + this.e) * Math.pow(1.0 - this.e, 1.0 - this.e)) / 2.0;
            double chi = 1.5707963267948966 - 2.0 * Math.atan(t);
            x = Math.abs(rho) < 1.0E-10 ? 0.0 : Math.atan2(x, -y);
            double sin2chi = Math.sin(2.0 * chi);
            double cos2chi = Math.cos(2.0 * chi);
            y = chi + sin2chi * (this.A + cos2chi * (this.B + cos2chi * (this.C + this.D * cos2chi)));
            double d = y = this.southPole ? -y : y;
            if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6)) {
                throw new AssertionError(x);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6)) {
                throw new AssertionError(y);
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        static {
            $assertionsDisabled = !(class$org$geotools$ct$proj$PolarStereographic == null ? (class$org$geotools$ct$proj$PolarStereographic = PolarStereographic.class$("org.geotools.ct.proj.PolarStereographic")) : class$org$geotools$ct$proj$PolarStereographic).desiredAssertionStatus();
        }
    }

    static final class Spherical
    extends PolarStereographic {
        private final double k0;
        static final /* synthetic */ boolean $assertionsDisabled;

        protected Spherical(Projection parameters) throws MissingParameterException {
            super(parameters);
            if (!$assertionsDisabled && !this.isSpherical) {
                throw new AssertionError();
            }
            this.k0 = Math.abs(this.latitudeTrueScale - 1.5707963267948966) >= 1.0E-6 ? 1.0 + Math.sin(this.latitudeTrueScale) : 2.0;
        }

        protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (!$assertionsDisabled && (ptDst = super.transformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            double coslat = Math.cos(y);
            double sinlat = Math.sin(y);
            double coslon = Math.cos(x);
            double sinlon = Math.sin(x);
            if (this.southPole) {
                if (!(Math.abs(1.0 - sinlat) >= 1.0E-10)) {
                    throw new ProjectionException(Resources.format(79));
                }
                double f = this.k0 * coslat / (1.0 - sinlat);
                x = f * sinlon;
                y = f * coslon;
            } else {
                if (!(Math.abs(1.0 + sinlat) >= 1.0E-10)) {
                    throw new ProjectionException(Resources.format(79));
                }
                double f = this.k0 * coslat / (1.0 + sinlat);
                x = f * sinlon;
                y = -f * coslon;
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6 * this.globalScale)) {
                throw new AssertionError(x);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6 * this.globalScale)) {
                throw new AssertionError(y);
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (!$assertionsDisabled && (ptDst = super.inverseTransformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            double rho = Math.sqrt(x * x + y * y);
            if (!this.southPole) {
                y = -y;
            }
            double d = x = Math.abs(x) < 1.0E-10 && Math.abs(y) < 1.0E-10 ? 0.0 : Math.atan2(x, y);
            if (Math.abs(rho) < 1.0E-10) {
                y = this.latitudeOfOrigin;
            } else {
                double c = 2.0 * Math.atan(rho / this.k0);
                double cosc = Math.cos(c);
                double d2 = y = this.southPole ? Math.asin(-cosc) : Math.asin(cosc);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6)) {
                throw new AssertionError(x);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6)) {
                throw new AssertionError(y);
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        static {
            $assertionsDisabled = !(class$org$geotools$ct$proj$PolarStereographic == null ? (class$org$geotools$ct$proj$PolarStereographic = PolarStereographic.class$("org.geotools.ct.proj.PolarStereographic")) : class$org$geotools$ct$proj$PolarStereographic).desiredAssertionStatus();
        }
    }
}

