/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct.proj;

import java.awt.geom.Point2D;
import org.geotools.cs.Projection;
import org.geotools.ct.MissingParameterException;
import org.geotools.ct.proj.Orthographic;
import org.geotools.ct.proj.ProjectionException;
import org.geotools.resources.cts.Resources;

public class PolarOrthographic
extends Orthographic {
    private final boolean northPole;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected PolarOrthographic(Projection parameters) throws MissingParameterException {
        super(parameters);
        if (!$assertionsDisabled && !(Math.abs(Math.abs(this.latitudeOfOrigin) - 1.5707963267948966) < 1.0E-6)) {
            throw new AssertionError(this.latitudeOfOrigin);
        }
        this.northPole = this.latitudeOfOrigin > 0.0;
        double d = this.latitudeOfOrigin = this.northPole ? 1.5707963267948966 : -1.5707963267948966;
        if (!$assertionsDisabled && !this.isSpherical) {
            throw new AssertionError();
        }
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        if (Math.abs(y - this.latitudeOfOrigin) - 1.0E-10 > 1.5707963267948966) {
            throw new ProjectionException(Resources.format(98));
        }
        double cosphi = Math.cos(y);
        double coslam = Math.cos(x);
        if (this.northPole) {
            coslam = -coslam;
        }
        y = cosphi * coslam;
        x = cosphi * Math.sin(x);
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double rho = Math.sqrt(x * x + y * y);
        double sinc = rho;
        if (sinc > 1.0) {
            if (sinc - 1.0 > 1.0E-10) {
                throw new ProjectionException(Resources.format(98));
            }
            sinc = 1.0;
        }
        if (Math.abs(rho) <= 1.0E-10) {
            y = this.latitudeOfOrigin;
            x = 0.0;
        } else {
            double phi;
            if (this.northPole) {
                y = -y;
                phi = Math.acos(sinc);
            } else {
                phi = -Math.acos(sinc);
            }
            x = Math.atan2(x, y);
            y = phi;
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    static {
        $assertionsDisabled = !PolarOrthographic.class.desiredAssertionStatus();
    }
}

