/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct.proj;

import java.util.Locale;
import org.geotools.cs.Projection;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MissingParameterException;
import org.geotools.ct.proj.EquatorialOrthographic;
import org.geotools.ct.proj.MapProjection;
import org.geotools.ct.proj.ObliqueOrthographic;
import org.geotools.ct.proj.PlanarProjection;
import org.geotools.ct.proj.PolarOrthographic;
import org.geotools.resources.cts.Resources;

public abstract class Orthographic
extends PlanarProjection {
    protected Orthographic(Projection parameters) throws MissingParameterException {
        super(parameters);
    }

    public String getName(Locale locale) {
        return Resources.getResources(locale).getString(96);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return super.equals(object);
    }

    static final class Provider
    extends org.geotools.ct.proj.Provider {
        public Provider() {
            super("Orthographic", 96);
        }

        public MathTransform create(Projection parameters) throws MissingParameterException {
            double latitudeOfOrigin = Math.abs(MapProjection.latitudeToRadians(parameters.getValue("latitude_of_origin", 0.0), true));
            if (Provider.isSpherical(parameters)) {
                if (Math.abs(latitudeOfOrigin - 1.5707963267948966) < 1.0E-6) {
                    return new PolarOrthographic(parameters);
                }
                if (latitudeOfOrigin < 1.0E-6) {
                    return new EquatorialOrthographic(parameters);
                }
                return new ObliqueOrthographic(parameters);
            }
            throw new UnsupportedOperationException(Resources.format(97));
        }
    }
}

