/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct.proj;

import java.awt.geom.Point2D;
import org.geotools.cs.Projection;
import org.geotools.ct.MissingParameterException;
import org.geotools.ct.proj.ProjectionException;
import org.geotools.ct.proj.Stereographic;
import org.geotools.resources.cts.Resources;

public class ObliqueStereographic
extends Stereographic {
    final double k0;
    final double sinphi0;
    final double cosphi0;
    final double chi1;
    final double sinChi1;
    final double cosChi1;
    static /* synthetic */ Class class$org$geotools$ct$proj$ObliqueStereographic;

    protected ObliqueStereographic(Projection parameters) throws MissingParameterException {
        super(parameters);
        if (Math.abs(this.latitudeOfOrigin) < 1.0E-6) {
            this.cosphi0 = 1.0;
            this.sinphi0 = 0.0;
            this.chi1 = 0.0;
            this.cosChi1 = 1.0;
            this.sinChi1 = 0.0;
            this.latitudeOfOrigin = 0.0;
        } else {
            this.cosphi0 = Math.cos(this.latitudeOfOrigin);
            this.sinphi0 = Math.sin(this.latitudeOfOrigin);
            this.chi1 = 2.0 * Math.atan(this.ssfn(this.latitudeOfOrigin, this.sinphi0)) - 1.5707963267948966;
            this.cosChi1 = Math.cos(this.chi1);
            this.sinChi1 = Math.sin(this.chi1);
        }
        this.k0 = 2.0 * this.msfn(this.sinphi0, this.cosphi0);
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double chi = 2.0 * Math.atan(this.ssfn(y, Math.sin(y))) - 1.5707963267948966;
        double sinChi = Math.sin(chi);
        double cosChi = Math.cos(chi);
        double cosChi_coslon = cosChi * Math.cos(x);
        double A = this.k0 / this.cosChi1 / (1.0 + this.sinChi1 * sinChi + this.cosChi1 * cosChi_coslon);
        x = A * cosChi * Math.sin(x);
        y = A * (this.cosChi1 * sinChi - this.sinChi1 * cosChi_coslon);
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double phi;
        double since;
        double cosce;
        double rho;
        block2: {
            rho = Math.sqrt(x * x + y * y);
            double ce = 2.0 * Math.atan2(rho * this.cosChi1, this.k0);
            cosce = Math.cos(ce);
            since = Math.sin(ce);
            double chi = Math.abs(rho) >= 1.0E-10 ? Math.asin(cosce * this.sinChi1 + y * since * this.cosChi1 / rho) : this.chi1;
            double t = Math.tan(0.7853981633974483 + chi / 2.0);
            double halfe = this.e / 2.0;
            double phi0 = chi;
            int i = 10;
            do {
                double esinphi;
                if (Math.abs((phi = 2.0 * Math.atan(t * Math.pow((1.0 + (esinphi = this.e * Math.sin(phi0))) / (1.0 - esinphi), halfe)) - 1.5707963267948966) - phi0) < 1.0E-10) break block2;
                phi0 = phi;
            } while (--i >= 0);
            throw new ProjectionException(Resources.format(69));
        }
        x = Math.abs(rho) < 1.0E-10 ? 0.0 : Math.atan2(x * since, rho * this.cosChi1 * cosce - y * this.sinChi1 * since);
        y = phi;
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    final double ssfn(double phi, double sinphi) {
        return Math.tan(0.7853981633974483 + phi / 2.0) * Math.pow((1.0 - (sinphi *= this.e)) / (1.0 + sinphi), this.e / 2.0);
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.k0);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ObliqueStereographic that = (ObliqueStereographic)object;
            return ObliqueStereographic.equals(this.k0, that.k0) && ObliqueStereographic.equals(this.sinphi0, that.sinphi0) && ObliqueStereographic.equals(this.cosphi0, that.cosphi0) && ObliqueStereographic.equals(this.chi1, that.chi1) && ObliqueStereographic.equals(this.sinChi1, that.sinChi1) && ObliqueStereographic.equals(this.cosChi1, that.cosChi1);
        }
        return false;
    }

    static final class EPSG
    extends ObliqueStereographic {
        private final double C;
        private final double K;
        private final double ratexp;
        private final double phic0;
        private final double cosc0;
        private final double sinc0;
        private final double R2;
        private static final double TOL = 1.0E-14;

        protected EPSG(Projection parameters) throws MissingParameterException {
            super(parameters);
            double sphi = Math.sin(this.latitudeOfOrigin);
            double cphi = Math.cos(this.latitudeOfOrigin);
            cphi *= cphi;
            this.R2 = 2.0 * Math.sqrt(1.0 - this.es) / (1.0 - this.es * sphi * sphi);
            this.C = Math.sqrt(1.0 + this.es * cphi * cphi / (1.0 - this.es));
            this.phic0 = Math.asin(sphi / this.C);
            this.sinc0 = Math.sin(this.phic0);
            this.cosc0 = Math.cos(this.phic0);
            this.ratexp = 0.5 * this.C * this.e;
            this.K = Math.tan(0.5 * this.phic0 + 0.7853981633974483) / (Math.pow(Math.tan(0.5 * this.latitudeOfOrigin + 0.7853981633974483), this.C) * EPSG.srat(this.e * sphi, this.ratexp));
        }

        protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            y = 2.0 * Math.atan(this.K * Math.pow(Math.tan(0.5 * y + 0.7853981633974483), this.C) * EPSG.srat(this.e * Math.sin(y), this.ratexp)) - 1.5707963267948966;
            double sinc = Math.sin(y);
            double cosc = Math.cos(y);
            double cosl = Math.cos(x *= this.C);
            double k = this.R2 / (1.0 + this.sinc0 * sinc + this.cosc0 * cosc * cosl);
            x = k * cosc * Math.sin(x);
            y = k * (this.cosc0 * sinc - this.sinc0 * cosc * cosl);
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            double phi;
            double rho = Math.sqrt(x * x + y * y);
            double c = 2.0 * Math.atan2(rho, this.R2);
            double sinc = Math.sin(c);
            double cosc = Math.cos(c);
            x = Math.atan2(x * sinc, rho * this.cosc0 * cosc - y * this.sinc0 * sinc);
            y = Math.abs(rho) >= 1.0E-14 ? Math.asin(cosc * this.sinc0 + y * sinc * this.cosc0 / rho) : this.phic0;
            x /= this.C;
            double num = Math.pow(Math.tan(0.5 * y + 0.7853981633974483) / this.K, 1.0 / this.C);
            int i = 10;
            while (!(Math.abs((phi = 2.0 * Math.atan(num * EPSG.srat(this.e * Math.sin(y), -0.5 * this.e)) - 1.5707963267948966) - y) < 1.0E-14)) {
                y = phi;
                if (--i >= 0) continue;
                throw new ProjectionException(Resources.format(69));
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        private static double srat(double esinp, double exp) {
            return Math.pow((1.0 - esinp) / (1.0 + esinp), exp);
        }
    }

    static final class Spherical
    extends ObliqueStereographic {
        private static final double k0 = 2.0;
        static final /* synthetic */ boolean $assertionsDisabled;

        protected Spherical(Projection parameters) throws MissingParameterException {
            super(parameters);
            if (!$assertionsDisabled && !this.isSpherical) {
                throw new AssertionError();
            }
        }

        protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            double coslon;
            if (!$assertionsDisabled && (ptDst = super.transformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            double coslat = Math.cos(y);
            double sinlat = Math.sin(y);
            double f = 1.0 + this.sinphi0 * sinlat + this.cosphi0 * coslat * (coslon = Math.cos(x));
            if (!(f >= 1.0E-10)) {
                throw new ProjectionException(Resources.format(79));
            }
            f = 2.0 / f;
            x = f * coslat * Math.sin(x);
            y = f * (this.cosphi0 * sinlat - this.sinphi0 * coslat * coslon);
            if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6 * this.globalScale)) {
                throw new AssertionError(x);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6 * this.globalScale)) {
                throw new AssertionError(y);
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (!$assertionsDisabled && (ptDst = super.inverseTransformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            double rho = Math.sqrt(x * x + y * y);
            if (Math.abs(rho) < 1.0E-10) {
                y = this.latitudeOfOrigin;
                x = 0.0;
            } else {
                double c = 2.0 * Math.atan(rho / 2.0);
                double cosc = Math.cos(c);
                double sinc = Math.sin(c);
                double ct = rho * this.cosphi0 * cosc - y * this.sinphi0 * sinc;
                double t = x * sinc;
                y = Math.asin(cosc * this.sinphi0 + y * sinc * this.cosphi0 / rho);
                double d = x = Math.abs(ct) < 1.0E-10 && Math.abs(t) < 1.0E-10 ? 0.0 : Math.atan2(t, ct);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6)) {
                throw new AssertionError(x);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6)) {
                throw new AssertionError(y);
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        static {
            $assertionsDisabled = !(class$org$geotools$ct$proj$ObliqueStereographic == null ? (class$org$geotools$ct$proj$ObliqueStereographic = ObliqueStereographic.class$("org.geotools.ct.proj.ObliqueStereographic")) : class$org$geotools$ct$proj$ObliqueStereographic).desiredAssertionStatus();
        }
    }
}

