/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct.proj;

import java.awt.geom.Point2D;
import org.geotools.cs.Projection;
import org.geotools.ct.MissingParameterException;
import org.geotools.ct.proj.Orthographic;
import org.geotools.ct.proj.ProjectionException;
import org.geotools.resources.cts.Resources;

public class ObliqueOrthographic
extends Orthographic {
    private final double sinphi0;
    private final double cosphi0;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ObliqueOrthographic(Projection parameters) throws MissingParameterException {
        super(parameters);
        this.sinphi0 = Math.sin(this.latitudeOfOrigin);
        this.cosphi0 = Math.cos(this.latitudeOfOrigin);
        if (!$assertionsDisabled && !this.isSpherical) {
            throw new AssertionError();
        }
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double cosphi = Math.cos(y);
        double coslam = Math.cos(x);
        double sinphi = Math.sin(y);
        if (this.sinphi0 * sinphi + this.cosphi0 * cosphi * coslam < -1.0E-10) {
            throw new ProjectionException(Resources.format(98));
        }
        y = this.cosphi0 * sinphi - this.sinphi0 * cosphi * coslam;
        x = cosphi * Math.sin(x);
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double rho = Math.sqrt(x * x + y * y);
        double sinc = rho;
        if (sinc > 1.0) {
            if (sinc - 1.0 > 1.0E-10) {
                throw new ProjectionException(Resources.format(98));
            }
            sinc = 1.0;
        }
        double cosc = Math.sqrt(1.0 - sinc * sinc);
        if (Math.abs(rho) <= 1.0E-10) {
            y = this.latitudeOfOrigin;
            x = 0.0;
        } else {
            double phi = cosc * this.sinphi0 + y * sinc * this.cosphi0 / rho;
            y = (cosc - this.sinphi0 * phi) * rho;
            x *= sinc * this.cosphi0;
            phi = Math.abs(phi) >= 1.0 ? (phi < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : Math.asin(phi);
            x = y == 0.0 ? (x == 0.0 ? 0.0 : (x < 0.0 ? -1.5707963267948966 : 1.5707963267948966)) : Math.atan2(x, y);
            y = phi;
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    static {
        $assertionsDisabled = !ObliqueOrthographic.class.desiredAssertionStatus();
    }
}

