/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct.proj;

import java.awt.geom.Point2D;
import java.util.Locale;
import org.geotools.cs.Projection;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MissingParameterException;
import org.geotools.ct.proj.CylindricalProjection;
import org.geotools.ct.proj.ProjectionException;
import org.geotools.pt.Latitude;
import org.geotools.resources.cts.Resources;

public class Mercator
extends CylindricalProjection {
    protected final double standardParallel;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Mercator(Projection parameters) throws MissingParameterException {
        this(parameters, Mercator.contains(parameters, "2SP"));
    }

    Mercator(Projection parameters, boolean sp2) throws MissingParameterException {
        super(parameters);
        if (sp2) {
            this.standardParallel = Mercator.latitudeToRadians(Math.abs(parameters.getValue("standard_parallel_1", 0.0)), false);
            this.scaleFactor = this.isSpherical ? (this.scaleFactor *= Math.cos(this.standardParallel)) : (this.scaleFactor *= this.msfn(Math.sin(this.standardParallel), Math.cos(this.standardParallel)));
            this.globalScale = this.scaleFactor * this.semiMajor;
        } else {
            this.standardParallel = Double.NaN;
        }
        if (!$assertionsDisabled && this.latitudeOfOrigin != 0.0) {
            throw new AssertionError(this.latitudeOfOrigin);
        }
    }

    public String getName(Locale locale) {
        return Resources.getResources(locale).getString(8);
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        if (Math.abs(y) > 1.5707953267948966) {
            throw new ProjectionException(Resources.format(76, new Latitude(Math.toDegrees(y))));
        }
        y = -Math.log(this.tsfn(y, Math.sin(y)));
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        y = Math.exp(-y);
        y = this.cphi2(y);
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.standardParallel);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            Mercator that = (Mercator)object;
            return Mercator.equals(this.standardParallel, that.standardParallel);
        }
        return false;
    }

    void toString(StringBuffer buffer) {
        super.toString(buffer);
        if (!Double.isNaN(this.standardParallel)) {
            Mercator.addParameter(buffer, "standard_parallel_1", Math.toDegrees(this.standardParallel));
        }
    }

    static {
        $assertionsDisabled = !Mercator.class.desiredAssertionStatus();
    }

    private static final class Spherical
    extends Mercator {
        static final /* synthetic */ boolean $assertionsDisabled;

        protected Spherical(Projection parameters, boolean sp2) throws MissingParameterException {
            super(parameters, sp2);
            if (!$assertionsDisabled && !this.isSpherical) {
                throw new AssertionError();
            }
        }

        protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (Math.abs(y) > 1.5707953267948966) {
                throw new ProjectionException(Resources.format(76, new Latitude(Math.toDegrees(y))));
            }
            if (!$assertionsDisabled && (ptDst = super.transformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            y = Math.log(Math.tan(0.7853981633974483 + 0.5 * y));
            if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6 * this.globalScale)) {
                throw new AssertionError(x);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6 * this.globalScale)) {
                throw new AssertionError(y);
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (!$assertionsDisabled && (ptDst = super.inverseTransformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            y = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-y));
            if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6)) {
                throw new AssertionError(x);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6)) {
                throw new AssertionError(y);
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        static {
            $assertionsDisabled = !(class$org$geotools$ct$proj$Mercator == null ? (class$org$geotools$ct$proj$Mercator = Mercator.class$("org.geotools.ct.proj.Mercator")) : class$org$geotools$ct$proj$Mercator).desiredAssertionStatus();
        }
    }

    static final class Provider
    extends org.geotools.ct.proj.Provider {
        private final boolean sp2;

        public Provider(boolean sp2) {
            super(sp2 ? "Mercator_2SP" : "Mercator_1SP", 8);
            this.remove("latitude_of_origin");
            if (sp2) {
                this.remove("scale_factor");
                this.put("standard_parallel_1", 0.0, LATITUDE_RANGE);
            }
            this.sp2 = sp2;
        }

        public MathTransform create(Projection parameters) throws MissingParameterException {
            if (Provider.isSpherical(parameters)) {
                return new Spherical(parameters, this.sp2);
            }
            return new Mercator(parameters, this.sp2);
        }
    }
}

