/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct.proj;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.media.jai.ParameterListDescriptor;
import org.geotools.cs.Projection;
import org.geotools.ct.AbstractMathTransform;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MathTransform2D;
import org.geotools.ct.MissingParameterException;
import org.geotools.ct.TransformException;
import org.geotools.ct.proj.PointOutsideEnvelopeException;
import org.geotools.ct.proj.ProjectionException;
import org.geotools.pt.Latitude;
import org.geotools.pt.Longitude;
import org.geotools.resources.cts.Resources;

public abstract class MapProjection
extends AbstractMathTransform
implements MathTransform2D,
Serializable {
    private static final double MAX_ERROR = 1.0;
    static final double EPS = 1.0E-6;
    static final double TOL = 1.0E-10;
    private final String classification;
    private final ParameterListDescriptor descriptor;
    protected final double e;
    protected final double es;
    protected final boolean isSpherical;
    protected final double semiMajor;
    protected final double semiMinor;
    protected final double centralMeridian;
    protected double latitudeOfOrigin;
    protected double scaleFactor;
    protected final double falseEasting;
    protected final double falseNorthing;
    protected double globalScale;
    private transient MathTransform inverse;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected MapProjection(Projection parameters) throws MissingParameterException {
        this.descriptor = parameters.getParameters().getParameterListDescriptor();
        this.classification = parameters.getClassName();
        this.semiMajor = parameters.getValue("semi_major");
        this.semiMinor = parameters.getValue("semi_minor");
        this.centralMeridian = MapProjection.longitudeToRadians(parameters.getValue("central_meridian", 0.0), true);
        this.latitudeOfOrigin = MapProjection.latitudeToRadians(parameters.getValue("latitude_of_origin", 0.0), true);
        this.scaleFactor = parameters.getValue("scale_factor", 1.0);
        this.falseEasting = parameters.getValue("false_easting", 0.0);
        this.falseNorthing = parameters.getValue("false_northing", 0.0);
        this.isSpherical = this.semiMajor == this.semiMinor;
        this.es = 1.0 - this.semiMinor * this.semiMinor / (this.semiMajor * this.semiMajor);
        this.e = Math.sqrt(this.es);
        this.globalScale = this.scaleFactor * this.semiMajor;
    }

    static double latitudeToRadians(double y, boolean edge) throws IllegalArgumentException {
        if (edge ? y >= -90.0 && y <= 90.0 : y > -90.0 && y < 90.0) {
            return Math.toRadians(y);
        }
        throw new IllegalArgumentException(Resources.format(57, new Latitude(y)));
    }

    static double longitudeToRadians(double x, boolean edge) throws IllegalArgumentException {
        if (edge ? x >= -180.0 && x <= 180.0 : x > -180.0 && x < 180.0) {
            return Math.toRadians(x);
        }
        throw new IllegalArgumentException(Resources.format(58, new Longitude(x)));
    }

    final double ensureInRange(double x) {
        if (this.centralMeridian != 0.0) {
            if (x > Math.PI) {
                x -= Math.PI * 2;
            } else if (x < -Math.PI) {
                x += Math.PI * 2;
            }
        }
        return x;
    }

    static boolean contains(Projection projection, String word) {
        String name = projection.getClassName().trim();
        int length = word.length();
        int index = 0;
        while ((index = name.indexOf(95, index)) >= 0) {
            if (!name.regionMatches(true, ++index, word, 0, length)) continue;
            return true;
        }
        return true;
    }

    public abstract String getName(Locale var1);

    public final int getDimSource() {
        return 2;
    }

    public final int getDimTarget() {
        return 2;
    }

    private boolean checkTransform(Point2D point, Point2D target, boolean inverse) {
        if (!(point instanceof CheckPoint)) {
            try {
                double latitude;
                double longitude;
                double distance;
                point = new CheckPoint(point);
                if (inverse) {
                    point = ((MathTransform2D)this.inverse()).transform(point, point);
                    double y1 = Math.toRadians(point.getY());
                    double y2 = Math.toRadians(target.getY());
                    double dx = Math.toRadians(Math.abs(target.getX() - point.getX()) % 360.0);
                    double rho = Math.sin(y1) * Math.sin(y2) + Math.cos(y1) * Math.cos(y2) * Math.cos(dx);
                    if (rho > 1.0) {
                        if (!$assertionsDisabled && !(rho <= 1.000001)) {
                            throw new AssertionError(rho);
                        }
                        rho = 1.0;
                    }
                    if (rho < -1.0) {
                        if (!$assertionsDisabled && !(rho >= -1.000001)) {
                            throw new AssertionError(rho);
                        }
                        rho = -1.0;
                    }
                    distance = Math.acos(rho) * this.semiMajor;
                    longitude = point.getX();
                    latitude = point.getY();
                } else {
                    longitude = point.getX();
                    latitude = point.getY();
                    point = this.transform(point, point);
                    distance = point.distance(target);
                }
                boolean edge = Math.abs(longitude) > 179.0 || Math.abs(latitude) > 89.0;
                double d = edge ? 5.0 : 1.0;
                if (distance > d) {
                    throw new AssertionError(distance);
                }
            }
            catch (TransformException exception) {
                AssertionError error = new AssertionError((Object)exception.getLocalizedMessage());
                ((Throwable)((Object)error)).initCause(exception);
                throw error;
            }
        }
        return true;
    }

    protected abstract Point2D inverseTransformNormalized(double var1, double var3, Point2D var5) throws ProjectionException;

    protected abstract Point2D transformNormalized(double var1, double var3, Point2D var5) throws ProjectionException;

    public final Point2D transform(Point2D ptSrc, Point2D ptDst) throws ProjectionException {
        double x = ptSrc.getX();
        double y = ptSrc.getY();
        if (x < -180.000001 || x > 180.000001) {
            throw new PointOutsideEnvelopeException(Resources.format(58, new Longitude(x)));
        }
        if (y < -90.000001 || y > 90.000001) {
            throw new PointOutsideEnvelopeException(Resources.format(57, new Latitude(y)));
        }
        ptDst = this.transformNormalized(this.ensureInRange(Math.toRadians(x) - this.centralMeridian), Math.toRadians(y), ptDst);
        ptDst.setLocation(this.globalScale * ptDst.getX() + this.falseEasting, this.globalScale * ptDst.getY() + this.falseNorthing);
        if (!$assertionsDisabled && !this.checkTransform(ptDst, ptSrc != ptDst ? ptSrc : new Point2D.Double(x, y), true)) {
            throw new AssertionError();
        }
        return ptDst;
    }

    public final void transform(double[] src, int srcOffset, double[] dest, int dstOffset, int numPts) throws ProjectionException {
        boolean reverse;
        boolean bl = reverse = src == dest && srcOffset < dstOffset && srcOffset + 2 * numPts > dstOffset;
        if (reverse) {
            srcOffset += 2 * numPts;
            dstOffset += 2 * numPts;
        }
        Point2D.Double point = new Point2D.Double();
        ProjectionException firstException = null;
        while (--numPts >= 0) {
            block5: {
                try {
                    point.x = src[srcOffset++];
                    point.y = src[srcOffset++];
                    this.transform(point, point);
                    dest[dstOffset++] = point.x;
                    dest[dstOffset++] = point.y;
                }
                catch (ProjectionException exception) {
                    dest[dstOffset++] = Double.NaN;
                    dest[dstOffset++] = Double.NaN;
                    if (firstException != null) break block5;
                    firstException = exception;
                }
            }
            if (!reverse) continue;
            srcOffset -= 4;
            dstOffset -= 4;
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public final void transform(float[] src, int srcOffset, float[] dest, int dstOffset, int numPts) throws ProjectionException {
        boolean reverse;
        boolean bl = reverse = src == dest && srcOffset < dstOffset && srcOffset + 2 * numPts > dstOffset;
        if (reverse) {
            srcOffset += 2 * numPts;
            dstOffset += 2 * numPts;
        }
        Point2D.Double point = new Point2D.Double();
        ProjectionException firstException = null;
        while (--numPts >= 0) {
            block5: {
                try {
                    point.x = src[srcOffset++];
                    point.y = src[srcOffset++];
                    this.transform(point, point);
                    dest[dstOffset++] = (float)point.x;
                    dest[dstOffset++] = (float)point.y;
                }
                catch (ProjectionException exception) {
                    dest[dstOffset++] = Float.NaN;
                    dest[dstOffset++] = Float.NaN;
                    if (firstException != null) break block5;
                    firstException = exception;
                }
            }
            if (!reverse) continue;
            srcOffset -= 4;
            dstOffset -= 4;
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public final MathTransform inverse() {
        if (this.inverse == null) {
            this.inverse = new Inverse();
        }
        return this.inverse;
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.semiMajor);
        code = code * 37L + Double.doubleToLongBits(this.semiMinor);
        code = code * 37L + Double.doubleToLongBits(this.centralMeridian);
        code = code * 37L + Double.doubleToLongBits(this.latitudeOfOrigin);
        return (int)code ^ (int)(code >>> 32);
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            MapProjection that = (MapProjection)object;
            return MapProjection.equals(this.semiMajor, that.semiMajor) && MapProjection.equals(this.semiMinor, that.semiMinor) && MapProjection.equals(this.centralMeridian, that.centralMeridian) && MapProjection.equals(this.latitudeOfOrigin, that.latitudeOfOrigin) && MapProjection.equals(this.scaleFactor, that.scaleFactor) && MapProjection.equals(this.falseEasting, that.falseEasting) && MapProjection.equals(this.falseNorthing, that.falseNorthing);
        }
        return false;
    }

    static boolean equals(double value1, double value2) {
        return Double.doubleToLongBits(value1) == Double.doubleToLongBits(value2);
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer("PARAM_MT[\"");
        buffer.append(this.classification);
        buffer.append('\"');
        this.toString(buffer);
        buffer.append(']');
        return buffer.toString();
    }

    void toString(StringBuffer buffer) {
        List<String> names = Arrays.asList(this.descriptor.getParamNames());
        MapProjection.addParameter(names, buffer, "semi_major", this.semiMajor);
        MapProjection.addParameter(names, buffer, "semi_minor", this.semiMinor);
        MapProjection.addParameter(names, buffer, "central_meridian", Math.toDegrees(this.centralMeridian));
        MapProjection.addParameter(names, buffer, "latitude_of_origin", Math.toDegrees(this.latitudeOfOrigin));
        MapProjection.addParameter(names, buffer, "scale_factor", this.scaleFactor);
        MapProjection.addParameter(names, buffer, "false_easting", this.falseEasting);
        MapProjection.addParameter(names, buffer, "false_northing", this.falseNorthing);
    }

    private static void addParameter(Collection names, StringBuffer buffer, String key, double value) {
        if (names.contains(key)) {
            MapProjection.addParameter(buffer, key, value);
        }
    }

    static void addParameter(StringBuffer buffer, String key, double value) {
        buffer.append(", PARAMETER[\"");
        buffer.append(key);
        buffer.append("\",");
        buffer.append(value);
        buffer.append(']');
    }

    final double cphi2(double ts) throws ProjectionException {
        double eccnth = 0.5 * this.e;
        double phi = 1.5707963267948966 - 2.0 * Math.atan(ts);
        for (int i = 0; i < 16; ++i) {
            double con = this.e * Math.sin(phi);
            double dphi = 1.5707963267948966 - 2.0 * Math.atan(ts * Math.pow((1.0 - con) / (1.0 + con), eccnth)) - phi;
            phi += dphi;
            if (!(Math.abs(dphi) <= 1.0E-10)) continue;
            return phi;
        }
        throw new ProjectionException(Resources.format(69));
    }

    final double msfn(double s, double c) {
        return c / Math.sqrt(1.0 - s * s * this.es);
    }

    final double tsfn(double phi, double sinphi) {
        return Math.tan(0.5 * (1.5707963267948966 - phi)) / Math.pow((1.0 - (sinphi *= this.e)) / (1.0 + sinphi), 0.5 * this.e);
    }

    static {
        $assertionsDisabled = !MapProjection.class.desiredAssertionStatus();
    }

    private final class Inverse
    extends AbstractMathTransform.Inverse
    implements MathTransform2D {
        static final /* synthetic */ boolean $assertionsDisabled;

        public Inverse() {
            super(MapProjection.this);
        }

        public final Point2D transform(Point2D ptSrc, Point2D ptDst) throws ProjectionException {
            double x0 = ptSrc.getX();
            double y0 = ptSrc.getY();
            ptDst = MapProjection.this.inverseTransformNormalized((x0 - MapProjection.this.falseEasting) / MapProjection.this.globalScale, (y0 - MapProjection.this.falseNorthing) / MapProjection.this.globalScale, ptDst);
            double x = Math.toDegrees(MapProjection.this.ensureInRange(ptDst.getX() + MapProjection.this.centralMeridian));
            double y = Math.toDegrees(ptDst.getY());
            ptDst.setLocation(x, y);
            if (x < -180.000001 || x > 180.000001) {
                throw new PointOutsideEnvelopeException(Resources.format(58, new Longitude(x)));
            }
            if (y < -90.000001 || y > 90.000001) {
                throw new PointOutsideEnvelopeException(Resources.format(57, new Latitude(y)));
            }
            if (!$assertionsDisabled && !MapProjection.this.checkTransform(ptDst, ptSrc != ptDst ? ptSrc : new Point2D.Double(x0, y0), false)) {
                throw new AssertionError();
            }
            return ptDst;
        }

        public final void transform(double[] src, int srcOffset, double[] dest, int dstOffset, int numPts) throws TransformException {
            boolean reverse;
            boolean bl = reverse = src == dest && srcOffset < dstOffset && srcOffset + 2 * numPts > dstOffset;
            if (reverse) {
                srcOffset += 2 * numPts;
                dstOffset += 2 * numPts;
            }
            Point2D.Double point = new Point2D.Double();
            ProjectionException firstException = null;
            while (--numPts >= 0) {
                block5: {
                    try {
                        point.x = src[srcOffset++];
                        point.y = src[srcOffset++];
                        this.transform(point, point);
                        dest[dstOffset++] = point.x;
                        dest[dstOffset++] = point.y;
                    }
                    catch (ProjectionException exception) {
                        dest[dstOffset++] = Double.NaN;
                        dest[dstOffset++] = Double.NaN;
                        if (firstException != null) break block5;
                        firstException = exception;
                    }
                }
                if (!reverse) continue;
                srcOffset -= 4;
                dstOffset -= 4;
            }
            if (firstException != null) {
                throw firstException;
            }
        }

        public final void transform(float[] src, int srcOffset, float[] dest, int dstOffset, int numPts) throws ProjectionException {
            boolean reverse;
            boolean bl = reverse = src == dest && srcOffset < dstOffset && srcOffset + 2 * numPts > dstOffset;
            if (reverse) {
                srcOffset += 2 * numPts;
                dstOffset += 2 * numPts;
            }
            Point2D.Double point = new Point2D.Double();
            ProjectionException firstException = null;
            while (--numPts >= 0) {
                block5: {
                    try {
                        point.x = src[srcOffset++];
                        point.y = src[srcOffset++];
                        this.transform(point, point);
                        dest[dstOffset++] = (float)point.x;
                        dest[dstOffset++] = (float)point.y;
                    }
                    catch (ProjectionException exception) {
                        dest[dstOffset++] = Float.NaN;
                        dest[dstOffset++] = Float.NaN;
                        if (firstException != null) break block5;
                        firstException = exception;
                    }
                }
                if (!reverse) continue;
                srcOffset -= 4;
                dstOffset -= 4;
            }
            if (firstException != null) {
                throw firstException;
            }
        }

        static {
            $assertionsDisabled = !(class$org$geotools$ct$proj$MapProjection == null ? (class$org$geotools$ct$proj$MapProjection = MapProjection.class$("org.geotools.ct.proj.MapProjection")) : class$org$geotools$ct$proj$MapProjection).desiredAssertionStatus();
        }
    }

    private static final class CheckPoint
    extends Point2D.Double {
        public CheckPoint(Point2D point) {
            super(point.getX(), point.getY());
        }
    }
}

