/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct.proj;

import java.awt.geom.Point2D;
import java.util.Locale;
import org.geotools.cs.Projection;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MissingParameterException;
import org.geotools.ct.proj.ConicProjection;
import org.geotools.ct.proj.ProjectionException;
import org.geotools.pt.Latitude;
import org.geotools.resources.cts.Resources;

public class LambertConformal
extends ConicProjection {
    private static final double BELGE_A = 1.42043136359877E-4;
    protected final double phi1;
    protected final double phi2;
    private final double n;
    private final double F;
    private final double rho0;
    private final boolean sp2;
    private final boolean belgium;

    protected LambertConformal(Projection parameters) throws MissingParameterException {
        this(parameters, LambertConformal.contains(parameters, "2SP"), LambertConformal.contains(parameters, "Belgium"));
    }

    LambertConformal(Projection parameters, boolean sp2, boolean belgium) throws MissingParameterException {
        super(parameters);
        boolean secant;
        this.sp2 = sp2;
        this.belgium = belgium;
        if (sp2) {
            this.phi1 = LambertConformal.latitudeToRadians(parameters.getValue("standard_parallel_1", 30.0), true);
            this.phi2 = LambertConformal.latitudeToRadians(parameters.getValue("standard_parallel_2", 45.0), true);
        } else {
            if (belgium) {
                throw new IllegalArgumentException();
            }
            this.phi1 = this.phi2 = this.latitudeOfOrigin;
        }
        if (Math.abs(this.phi1 + this.phi2) < 1.0E-6) {
            throw new IllegalArgumentException(Resources.format(44, new Latitude(Math.toDegrees(this.phi1)), new Latitude(Math.toDegrees(this.phi2))));
        }
        double cosphi1 = Math.cos(this.phi1);
        double sinphi1 = Math.sin(this.phi1);
        boolean bl = secant = Math.abs(this.phi1 - this.phi2) > 1.0E-6;
        if (this.isSpherical) {
            this.n = secant ? Math.log(cosphi1 / Math.cos(this.phi2)) / Math.log(Math.tan(0.7853981633974483 + 0.5 * this.phi2) / Math.tan(0.7853981633974483 + 0.5 * this.phi1)) : sinphi1;
            this.F = cosphi1 * Math.pow(Math.tan(0.7853981633974483 + 0.5 * this.phi1), this.n) / this.n;
            this.rho0 = Math.abs(Math.abs(this.latitudeOfOrigin) - 1.5707963267948966) >= 1.0E-6 ? this.F * Math.pow(Math.tan(0.7853981633974483 + 0.5 * this.latitudeOfOrigin), -this.n) : 0.0;
        } else {
            double m1 = this.msfn(sinphi1, cosphi1);
            double t1 = this.tsfn(this.phi1, sinphi1);
            if (secant) {
                double sinphi2 = Math.sin(this.phi2);
                double m2 = this.msfn(sinphi2, Math.cos(this.phi2));
                double t2 = this.tsfn(this.phi2, sinphi2);
                this.n = Math.log(m1 / m2) / Math.log(t1 / t2);
            } else {
                this.n = sinphi1;
            }
            this.F = m1 * Math.pow(t1, -this.n) / this.n;
            this.rho0 = Math.abs(Math.abs(this.latitudeOfOrigin) - 1.5707963267948966) >= 1.0E-6 ? this.F * Math.pow(this.tsfn(this.latitudeOfOrigin, Math.sin(this.latitudeOfOrigin)), this.n) : 0.0;
        }
    }

    public String getName(Locale locale) {
        return Resources.getResources(locale).getString(21);
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double rho;
        if (Math.abs(Math.abs(y) - 1.5707963267948966) < 1.0E-6) {
            if (y * this.n <= 0.0) {
                throw new ProjectionException(Resources.format(76, new Latitude(Math.toDegrees(y))));
            }
            rho = 0.0;
        } else {
            rho = this.isSpherical ? this.F * Math.pow(Math.tan(0.7853981633974483 + 0.5 * y), -this.n) : this.F * Math.pow(this.tsfn(y, Math.sin(y)), this.n);
        }
        x *= this.n;
        if (this.belgium) {
            x -= 1.42043136359877E-4;
        }
        y = this.rho0 - rho * Math.cos(x);
        x = rho * Math.sin(x);
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double rho = Math.sqrt(x * x + (y = this.rho0 - y) * y);
        if (rho > 1.0E-6) {
            if (this.n < 0.0) {
                rho = -rho;
                x = -x;
                y = -y;
            }
            double theta = Math.atan2(x, y);
            if (this.belgium) {
                theta += 1.42043136359877E-4;
            }
            x = theta / this.n;
            y = this.isSpherical ? 2.0 * Math.atan(Math.pow(this.F / rho, 1.0 / this.n)) - 1.5707963267948966 : this.cphi2(Math.pow(rho / this.F, 1.0 / this.n));
        } else {
            x = 0.0;
            double d = y = this.n < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.F);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            LambertConformal that = (LambertConformal)object;
            return this.sp2 == that.sp2 && this.belgium == that.belgium && LambertConformal.equals(this.n, that.n) && LambertConformal.equals(this.F, that.F) && LambertConformal.equals(this.rho0, that.rho0) && LambertConformal.equals(this.phi1, that.phi1) && LambertConformal.equals(this.phi2, that.phi2);
        }
        return false;
    }

    void toString(StringBuffer buffer) {
        super.toString(buffer);
        if (this.sp2) {
            LambertConformal.addParameter(buffer, "standard_parallel_1", Math.toDegrees(this.phi1));
            LambertConformal.addParameter(buffer, "standard_parallel_2", Math.toDegrees(this.phi2));
        }
    }

    static final class Provider
    extends org.geotools.ct.proj.Provider {
        private final boolean sp2;
        private final boolean belgium;

        public Provider(boolean sp2, boolean belgium, boolean ogc) {
            super(ogc ? (sp2 ? (belgium ? "Lambert_Conformal_Conic_2SP_Belgium" : "Lambert_Conformal_Conic_2SP") : "Lambert_Conformal_Conic_1SP") : (sp2 ? (belgium ? "Lambert_Conic_Conformal_2SP_Belgium" : "Lambert_Conic_Conformal_2SP") : "Lambert_Conic_Conformal_1SP"), 21);
            if (sp2) {
                this.remove("scale_factor");
                this.put("standard_parallel_1", 30.0, LATITUDE_RANGE);
                this.put("standard_parallel_2", 45.0, LATITUDE_RANGE);
            } else {
                this.put("latitude_of_origin", Double.NaN, LATITUDE_RANGE);
            }
            this.sp2 = sp2;
            this.belgium = belgium;
        }

        public MathTransform create(Projection parameters) throws MissingParameterException {
            return new LambertConformal(parameters, this.sp2, this.belgium);
        }
    }
}

