/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct.proj;

import java.awt.geom.Point2D;
import org.geotools.cs.Projection;
import org.geotools.ct.MissingParameterException;
import org.geotools.ct.proj.ObliqueStereographic;
import org.geotools.ct.proj.ProjectionException;
import org.geotools.resources.cts.Resources;

public class EquatorialStereographic
extends ObliqueStereographic {
    static final double k0 = 2.0;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected EquatorialStereographic(Projection parameters) throws MissingParameterException {
        super(parameters);
        if (!$assertionsDisabled && ((ObliqueStereographic)this).k0 != 2.0) {
            throw new AssertionError();
        }
        this.latitudeOfOrigin = 0.0;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        if (!$assertionsDisabled && (ptDst = super.transformNormalized(x, y, ptDst)) == null) {
            throw new AssertionError();
        }
        double chi = 2.0 * Math.atan(this.ssfn(y, Math.sin(y))) - 1.5707963267948966;
        double cosChi = Math.cos(chi);
        double A = 2.0 / (1.0 + cosChi * Math.cos(x));
        x = A * cosChi * Math.sin(x);
        y = A * Math.sin(chi);
        if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6 * this.globalScale)) {
            throw new AssertionError(x);
        }
        if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6 * this.globalScale)) {
            throw new AssertionError(y);
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    static {
        $assertionsDisabled = !EquatorialStereographic.class.desiredAssertionStatus();
    }

    static final class Spherical
    extends EquatorialStereographic {
        static final /* synthetic */ boolean $assertionsDisabled;

        protected Spherical(Projection parameters) throws MissingParameterException {
            super(parameters);
            if (!$assertionsDisabled && !this.isSpherical) {
                throw new AssertionError();
            }
        }

        protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (!$assertionsDisabled && (ptDst = super.transformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            double coslat = Math.cos(y);
            double f = 1.0 + coslat * Math.cos(x);
            if (!(f >= 1.0E-10)) {
                throw new ProjectionException(Resources.format(79));
            }
            f = 2.0 / f;
            x = f * coslat * Math.sin(x);
            y = f * Math.sin(y);
            if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6 * this.globalScale)) {
                throw new AssertionError(x);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6 * this.globalScale)) {
                throw new AssertionError(y);
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (!$assertionsDisabled && (ptDst = super.inverseTransformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            double rho = Math.sqrt(x * x + y * y);
            if (Math.abs(rho) < 1.0E-10) {
                y = 0.0;
                x = 0.0;
            } else {
                double c = 2.0 * Math.atan(rho / 2.0);
                double cosc = Math.cos(c);
                double sinc = Math.sin(c);
                y = Math.asin(y * sinc / rho);
                double t = x * sinc;
                double ct = rho * cosc;
                double d = x = Math.abs(t) < 1.0E-10 && Math.abs(ct) < 1.0E-10 ? 0.0 : Math.atan2(t, ct);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6)) {
                throw new AssertionError(x);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6)) {
                throw new AssertionError(y);
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        static {
            $assertionsDisabled = !(class$org$geotools$ct$proj$EquatorialStereographic == null ? (class$org$geotools$ct$proj$EquatorialStereographic = EquatorialStereographic.class$("org.geotools.ct.proj.EquatorialStereographic")) : class$org$geotools$ct$proj$EquatorialStereographic).desiredAssertionStatus();
        }
    }
}

