/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ct.proj;

import java.awt.geom.Point2D;
import org.geotools.cs.Projection;
import org.geotools.ct.MissingParameterException;
import org.geotools.ct.proj.ObliqueOrthographic;
import org.geotools.ct.proj.ProjectionException;
import org.geotools.resources.cts.Resources;

public class EquatorialOrthographic
extends ObliqueOrthographic {
    static final /* synthetic */ boolean $assertionsDisabled;

    protected EquatorialOrthographic(Projection parameters) throws MissingParameterException {
        super(parameters);
        if (!$assertionsDisabled && !(this.latitudeOfOrigin < 1.0E-6)) {
            throw new AssertionError(this.latitudeOfOrigin);
        }
        this.latitudeOfOrigin = 0.0;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double coslam;
        if (!$assertionsDisabled && (ptDst = super.transformNormalized(x, y, ptDst)) == null) {
            throw new AssertionError();
        }
        double cosphi = Math.cos(y);
        if (cosphi * (coslam = Math.cos(x)) < -1.0E-10) {
            throw new ProjectionException(Resources.format(98));
        }
        y = Math.sin(y);
        x = cosphi * Math.sin(x);
        if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6 * this.globalScale)) {
            throw new AssertionError(x);
        }
        if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6 * this.globalScale)) {
            throw new AssertionError(y);
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        if (!$assertionsDisabled && (ptDst = super.inverseTransformNormalized(x, y, ptDst)) == null) {
            throw new AssertionError();
        }
        double rho = Math.sqrt(x * x + y * y);
        double sinc = rho;
        if (sinc > 1.0) {
            if (sinc - 1.0 > 1.0E-10) {
                throw new ProjectionException(Resources.format(98));
            }
            sinc = 1.0;
        }
        double cosc = Math.sqrt(1.0 - sinc * sinc);
        if (Math.abs(rho) <= 1.0E-10) {
            y = this.latitudeOfOrigin;
            x = 0.0;
        } else {
            double phi = y * sinc / rho;
            x *= sinc;
            y = cosc * rho;
            phi = Math.abs(phi) >= 1.0 ? (phi < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : Math.asin(phi);
            x = y == 0.0 ? (x == 0.0 ? 0.0 : (x < 0.0 ? -1.5707963267948966 : 1.5707963267948966)) : Math.atan2(x, y);
            y = phi;
        }
        if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6)) {
            throw new AssertionError(x);
        }
        if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6)) {
            throw new AssertionError(y);
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    static {
        $assertionsDisabled = !EquatorialOrthographic.class.desiredAssertionStatus();
    }
}

